/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import com.codeborne.selenide.Driver;
import com.codeborne.selenide.SelenideElement;
import com.codeborne.selenide.impl.WebElementWrapper;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.pagefactory.ElementLocator;

@ParametersAreNonnullByDefault
public class SelenideElementListProxy
implements InvocationHandler {
    private final Driver driver;
    private final ElementLocator locator;

    public static List<SelenideElement> wrap(Driver driver, ElementLocator locator) {
        SelenideElementListProxy handler = new SelenideElementListProxy(driver, locator);
        return (List)Proxy.newProxyInstance(SelenideElementListProxy.class.getClassLoader(), new Class[]{List.class}, (InvocationHandler)handler);
    }

    private SelenideElementListProxy(Driver driver, ElementLocator locator) {
        this.driver = driver;
        this.locator = locator;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        ArrayList<SelenideElement> elements = new ArrayList<SelenideElement>();
        for (WebElement webElement : this.locator.findElements()) {
            elements.add(WebElementWrapper.wrap(this.driver, webElement));
        }
        try {
            return method.invoke(elements, args);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }
}

