/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import com.codeborne.selenide.Config;
import com.codeborne.selenide.files.FileFilter;
import com.codeborne.selenide.impl.Downloads;
import com.codeborne.selenide.impl.Waiter;
import com.codeborne.selenide.impl.WebElementSource;
import com.codeborne.selenide.impl.WindowsCloser;
import com.codeborne.selenide.proxy.DownloadedFile;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
public class DownloadFileToFolder {
    private static final Logger log = LoggerFactory.getLogger(DownloadFileToFolder.class);
    private final Waiter waiter;
    private final WindowsCloser windowsCloser;

    DownloadFileToFolder(Waiter waiter, WindowsCloser windowsCloser) {
        this.waiter = waiter;
        this.windowsCloser = windowsCloser;
    }

    public DownloadFileToFolder() {
        this(new Waiter(), new WindowsCloser());
    }

    @CheckReturnValue
    @Nonnull
    public File download(WebElementSource anyClickableElement, WebElement clickable, long timeout, FileFilter fileFilter) throws FileNotFoundException {
        WebDriver webDriver = anyClickableElement.driver().getWebDriver();
        return this.windowsCloser.runAndCloseArisedWindows(webDriver, () -> this.clickAndWaitForNewFilesInDownloadsFolder(anyClickableElement, clickable, timeout, fileFilter));
    }

    @CheckReturnValue
    @Nonnull
    private File clickAndWaitForNewFilesInDownloadsFolder(WebElementSource anyClickableElement, WebElement clickable, long timeout, FileFilter fileFilter) throws FileNotFoundException {
        Config config = anyClickableElement.driver().config();
        File folder = new File(config.downloadsFolder());
        PreviousDownloadsCompleted previousFiles = new PreviousDownloadsCompleted();
        this.waiter.wait(folder, previousFiles, timeout, config.pollingInterval());
        clickable.click();
        HasDownloads hasDownloads = new HasDownloads(fileFilter, previousFiles.previousFiles);
        this.waiter.wait(folder, hasDownloads, timeout, config.pollingInterval());
        if (log.isInfoEnabled()) {
            log.info(hasDownloads.downloads.filesAsString());
        }
        return hasDownloads.downloads.firstDownloadedFile(anyClickableElement.toString(), timeout, fileFilter);
    }

    @CheckReturnValue
    @Nonnull
    private static List<File> allDownloadedFiles(File folder) {
        Object[] files = folder.listFiles();
        if (log.isDebugEnabled()) {
            log.debug("all downloaded files in {}: {}", (Object)folder.getAbsolutePath(), (Object)Arrays.toString(files));
        }
        return files == null ? Collections.emptyList() : Arrays.asList(files);
    }

    @ParametersAreNonnullByDefault
    private static class PreviousDownloadsCompleted
    implements Predicate<File> {
        List<File> previousFiles = Collections.emptyList();

        private PreviousDownloadsCompleted() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean test(File folder) {
            List files = DownloadFileToFolder.allDownloadedFiles(folder);
            try {
                boolean bl = this.previousFiles.size() == files.size();
                return bl;
            }
            finally {
                this.previousFiles = files;
            }
        }
    }

    @ParametersAreNonnullByDefault
    private static class HasDownloads
    implements Predicate<File> {
        private final FileFilter fileFilter;
        private final Downloads previousFiles;
        Downloads downloads;

        private HasDownloads(FileFilter fileFilter, List<File> previousFiles) {
            this.fileFilter = fileFilter;
            this.previousFiles = this.toDownloads(previousFiles);
        }

        @Override
        public boolean test(File folder) {
            Downloads files = this.toDownloads(DownloadFileToFolder.allDownloadedFiles(folder));
            List<DownloadedFile> newFiles = this.diff(files, this.previousFiles);
            this.downloads = new Downloads(newFiles);
            return !this.downloads.files(this.fileFilter).isEmpty();
        }

        private List<DownloadedFile> diff(Downloads currentFiles, Downloads previousFiles) {
            ArrayList<DownloadedFile> newFiles = new ArrayList<DownloadedFile>(currentFiles.files());
            newFiles.removeAll(previousFiles.files());
            return newFiles;
        }

        private Downloads toDownloads(List<File> newFiles) {
            Downloads downloads = new Downloads();
            for (File file : newFiles) {
                if (!file.exists()) continue;
                downloads.add(new DownloadedFile(file, Collections.emptyMap()));
            }
            return downloads;
        }
    }
}

