/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.drivercommands;

import com.codeborne.selenide.Config;
import com.codeborne.selenide.impl.Cleanup;
import com.codeborne.selenide.proxy.SelenideProxyServer;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.remote.UnreachableBrowserException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
public class CloseDriverCommand {
    private static final Logger log = LoggerFactory.getLogger(CloseDriverCommand.class);

    public void closeAsync(Config config, @Nullable WebDriver webDriver, @Nullable SelenideProxyServer selenideProxyServer) {
        long threadId = Thread.currentThread().getId();
        if (config.holdBrowserOpen()) {
            log.info("Hold browser and proxy open: {} -> {}, {}", new Object[]{threadId, webDriver, selenideProxyServer});
        } else if (webDriver != null) {
            log.info("Close webdriver: {} -> {}", (Object)threadId, (Object)webDriver);
            if (selenideProxyServer != null) {
                log.info("Close proxy server: {} -> {}", (Object)threadId, (Object)selenideProxyServer);
            }
            long start = System.currentTimeMillis();
            Thread t = new Thread(() -> this.close(webDriver, selenideProxyServer));
            t.setDaemon(true);
            t.start();
            try {
                t.join();
            }
            catch (InterruptedException e) {
                long duration = System.currentTimeMillis() - start;
                log.debug("Failed to close webdriver {} in {} ms", new Object[]{threadId, duration, e});
                Thread.currentThread().interrupt();
            }
            long duration = System.currentTimeMillis() - start;
            log.info("Closed webdriver {} in {} ms", (Object)threadId, (Object)duration);
        } else if (selenideProxyServer != null) {
            log.info("Close proxy server: {} -> {}", (Object)threadId, (Object)selenideProxyServer);
            selenideProxyServer.shutdown();
        }
    }

    private void close(WebDriver webdriver, @Nullable SelenideProxyServer proxy) {
        try {
            log.info("Trying to close the browser {} ...", (Object)webdriver.getClass().getSimpleName());
            webdriver.quit();
        }
        catch (UnreachableBrowserException e) {
            log.debug("Browser is unreachable", (Throwable)e);
        }
        catch (WebDriverException cannotCloseBrowser) {
            log.error("Cannot close browser normally: {}", (Object)Cleanup.of.webdriverExceptionMessage(cannotCloseBrowser));
        }
        if (proxy != null) {
            log.info("Trying to shutdown {} ...", (Object)proxy);
            proxy.shutdown();
        }
    }
}

