/*
 * Decompiled with CFR 0.152.
 */
package com.code_intelligence.jazzer.third_party.org.jacoco.core.internal.flow;

import com.code_intelligence.jazzer.third_party.org.jacoco.core.internal.flow.IFrame;
import com.code_intelligence.jazzer.third_party.org.objectweb.asm.MethodVisitor;
import com.code_intelligence.jazzer.third_party.org.objectweb.asm.Opcodes;
import com.code_intelligence.jazzer.third_party.org.objectweb.asm.commons.AnalyzerAdapter;
import java.util.ArrayList;
import java.util.List;

class FrameSnapshot
implements IFrame {
    private static final FrameSnapshot NOP = new FrameSnapshot(null, null);
    private final Object[] locals;
    private final Object[] stack;

    private FrameSnapshot(Object[] locals, Object[] stack) {
        this.locals = locals;
        this.stack = stack;
    }

    static IFrame create(AnalyzerAdapter analyzer, int popCount) {
        if (analyzer == null || analyzer.locals == null) {
            return NOP;
        }
        Object[] locals = FrameSnapshot.reduce(analyzer.locals, 0);
        Object[] stack = FrameSnapshot.reduce(analyzer.stack, popCount);
        return new FrameSnapshot(locals, stack);
    }

    private static Object[] reduce(List<Object> source, int popCount) {
        ArrayList<Object> copy2 = new ArrayList<Object>(source);
        int size = source.size() - popCount;
        copy2.subList(size, source.size()).clear();
        int i = size;
        while (--i >= 0) {
            Object type2 = source.get(i);
            if (type2 != Opcodes.LONG && type2 != Opcodes.DOUBLE) continue;
            copy2.remove(i + 1);
        }
        return copy2.toArray();
    }

    @Override
    public void accept(MethodVisitor mv) {
        if (this.locals != null) {
            mv.visitFrame(-1, this.locals.length, this.locals, this.stack.length, this.stack);
        }
    }
}

