/*
 * Decompiled with CFR 0.152.
 */
package com.code_intelligence.jazzer.mutation.support;

import com.code_intelligence.jazzer.mutation.support.Preconditions;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Objects;

public final class InputStreamSupport {
    private static final InputStream infiniteZerosStream = new ExtendWithNullInputStream();

    public static byte[] readAllBytes(InputStream stream) throws IOException {
        byte[] buffer;
        Objects.requireNonNull(stream);
        ArrayDeque<byte[]> buffers = new ArrayDeque<byte[]>();
        int arrayLength = 0;
        block0: while (true) {
            byte[] buffer2 = new byte[Math.max(8192, stream.available())];
            buffers.add(buffer2);
            int off = 0;
            while (true) {
                if (off >= buffer2.length) continue block0;
                int bytesRead = stream.read(buffer2, off, buffer2.length - off);
                if (bytesRead == -1) break block0;
                off += bytesRead;
                arrayLength += bytesRead;
            }
            break;
        }
        byte[] result = new byte[arrayLength];
        int offset = 0;
        int remaining = arrayLength;
        while ((buffer = (byte[])buffers.poll()) != null) {
            int toCopy = Math.min(buffer.length, remaining);
            System.arraycopy(buffer, 0, result, offset, toCopy);
            remaining -= toCopy;
        }
        return result;
    }

    public static InputStream infiniteZeros() {
        return infiniteZerosStream;
    }

    public static InputStream extendWithZeros(InputStream stream) {
        if (stream instanceof ExtendWithNullInputStream) {
            return stream;
        }
        return new ExtendWithNullInputStream(Objects.requireNonNull(stream));
    }

    public static InputStream cap(InputStream stream, long bytes) {
        Objects.requireNonNull(stream);
        Preconditions.require(bytes >= 0L, "bytes must be non-negative");
        return new CappedInputStream(stream, bytes);
    }

    private InputStreamSupport() {
    }

    public static final class ExtendWithNullInputStream
    extends InputStream {
        private static final InputStream ALWAYS_EOF = new ByteArrayInputStream(new byte[0]);
        private final InputStream stream;
        private boolean eof;

        private ExtendWithNullInputStream() {
            this.stream = ALWAYS_EOF;
            this.eof = true;
        }

        private ExtendWithNullInputStream(InputStream stream) {
            this.stream = stream;
            this.eof = false;
        }

        @Override
        public int read() throws IOException {
            if (this.eof) {
                return 0;
            }
            int res = this.stream.read();
            if (res != -1) {
                return res;
            }
            this.eof = true;
            return 0;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            if (this.eof) {
                Arrays.fill(b, off, off + len, (byte)0);
            } else {
                int bytesRead = this.stream.read(b, off, len);
                if (bytesRead < len) {
                    this.eof = true;
                    Arrays.fill(b, Math.max(off, off + bytesRead), off + len, (byte)0);
                }
            }
            return len;
        }

        @Override
        public int available() throws IOException {
            if (this.eof) {
                return Integer.MAX_VALUE;
            }
            return this.stream.available();
        }

        @Override
        public void close() throws IOException {
            this.stream.close();
        }
    }

    private static final class CappedInputStream
    extends InputStream {
        private final InputStream stream;
        private long remaining;

        CappedInputStream(InputStream stream, long remaining) {
            this.stream = stream;
            this.remaining = remaining;
        }

        @Override
        public int read() throws IOException {
            if (this.remaining == 0L) {
                return -1;
            }
            int res = this.stream.read();
            if (res != -1) {
                --this.remaining;
            }
            return res;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            if (this.remaining == 0L) {
                return -1;
            }
            int res = this.stream.read(b, off, (int)Math.min((long)len, this.remaining));
            if (res != -1) {
                this.remaining -= (long)res;
            }
            return res;
        }

        @Override
        public int available() throws IOException {
            return (int)Math.min((long)this.stream.available(), this.remaining);
        }

        @Override
        public void close() throws IOException {
            this.stream.close();
        }
    }
}

