/*
 * Decompiled with CFR 0.152.
 */
package com.code_intelligence.jazzer.mutation.mutator.proto;

import com.code_intelligence.jazzer.mutation.annotation.proto.WithDefaultInstance;
import com.code_intelligence.jazzer.mutation.api.InPlaceMutator;
import com.code_intelligence.jazzer.mutation.combinator.MutatorCombinators;
import com.code_intelligence.jazzer.mutation.support.Preconditions;
import com.code_intelligence.jazzer.mutation.support.StreamSupport;
import com.code_intelligence.jazzer.mutation.support.TypeHolder;
import com.code_intelligence.jazzer.mutation.support.TypeSupport;
import com.google.protobuf.ByteString;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

final class TypeLibrary {
    private static final AnnotatedType RAW_LIST = new TypeHolder<List>(){}.annotatedType();
    private static final AnnotatedType RAW_MAP = new TypeHolder<Map>(){}.annotatedType();
    private static final Map<Descriptors.FieldDescriptor.JavaType, AnnotatedType> BASE_TYPE_WITH_PRESENCE = Stream.of(StreamSupport.entry(Descriptors.FieldDescriptor.JavaType.BOOLEAN, Boolean.class), StreamSupport.entry(Descriptors.FieldDescriptor.JavaType.BYTE_STRING, ByteString.class), StreamSupport.entry(Descriptors.FieldDescriptor.JavaType.DOUBLE, Double.class), StreamSupport.entry(Descriptors.FieldDescriptor.JavaType.ENUM, Descriptors.EnumValueDescriptor.class), StreamSupport.entry(Descriptors.FieldDescriptor.JavaType.FLOAT, Float.class), StreamSupport.entry(Descriptors.FieldDescriptor.JavaType.INT, Integer.class), StreamSupport.entry(Descriptors.FieldDescriptor.JavaType.LONG, Long.class), StreamSupport.entry(Descriptors.FieldDescriptor.JavaType.MESSAGE, Message.class), StreamSupport.entry(Descriptors.FieldDescriptor.JavaType.STRING, String.class)).collect(Collectors.collectingAndThen(Collectors.toMap(Map.Entry::getKey, e -> TypeSupport.asAnnotatedType((Class)e.getValue())), map -> Collections.unmodifiableMap(new EnumMap(map))));

    private TypeLibrary() {
    }

    static <T extends Message.Builder> AnnotatedType getTypeToMutate(Descriptors.FieldDescriptor field) {
        if (field.isRequired()) {
            return TypeLibrary.getBaseType(field);
        }
        if (field.isMapField()) {
            AnnotatedType keyType = TypeLibrary.getBaseType((Descriptors.FieldDescriptor)field.getMessageType().getFields().get(0));
            AnnotatedType valueType = TypeLibrary.getBaseType((Descriptors.FieldDescriptor)field.getMessageType().getFields().get(1));
            return TypeSupport.withTypeArguments(RAW_MAP, keyType, valueType);
        }
        if (field.isRepeated()) {
            return TypeSupport.withTypeArguments(RAW_LIST, TypeLibrary.getBaseType(field));
        }
        if (field.hasPresence()) {
            return BASE_TYPE_WITH_PRESENCE.get(field.getJavaType());
        }
        return TypeLibrary.getBaseType(field);
    }

    private static <T extends Message.Builder> AnnotatedType getBaseType(Descriptors.FieldDescriptor field) {
        return TypeSupport.notNull(BASE_TYPE_WITH_PRESENCE.get(field.getJavaType()));
    }

    static <T> InPlaceMutator<T> withoutInitIfRecursive(InPlaceMutator<T> mutator, Descriptors.FieldDescriptor field) {
        if (field.isRequired() || !TypeLibrary.isRecursiveField(field)) {
            return mutator;
        }
        return MutatorCombinators.withoutInit(mutator);
    }

    static boolean isRecursiveField(Descriptors.FieldDescriptor field) {
        return TypeSupport.containedInDirectedCycle(field, f -> {
            Descriptors.FieldDescriptor realField;
            Descriptors.FieldDescriptor fieldDescriptor = realField = f.isMapField() ? (Descriptors.FieldDescriptor)f.getMessageType().getFields().get(1) : f;
            if (realField.getJavaType() != Descriptors.FieldDescriptor.JavaType.MESSAGE) {
                return Stream.empty();
            }
            return realField.getMessageType().getFields().stream();
        });
    }

    static Message getDefaultInstance(Class<? extends Message> messageClass) {
        Method getDefaultInstance;
        try {
            getDefaultInstance = messageClass.getMethod("getDefaultInstance", new Class[0]);
            Preconditions.check(Modifier.isStatic(getDefaultInstance.getModifiers()));
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException(String.format("Message class for builder type %s does not have a getDefaultInstance method", messageClass.getName()), e);
        }
        try {
            return (Message)getDefaultInstance.invoke(null, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new IllegalStateException(String.format(getDefaultInstance + " isn't accessible or threw an exception", new Object[0]), e);
        }
    }

    static Message getDefaultInstance(WithDefaultInstance withDefaultInstance) {
        Method method;
        Class<?> clazz;
        String[] parts = withDefaultInstance.value().split("#");
        if (parts.length != 2) {
            throw new IllegalArgumentException(String.format("Expected @WithDefaultInstance(\"%s\") to specify a fully-qualified method name (e.g. com.example.MyClass#getDefaultInstance)", withDefaultInstance.value()));
        }
        try {
            clazz = Class.forName(parts[0]);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(String.format("Failed to find class '%s' specified by @WithDefaultInstance(\"%s\")", parts[0], withDefaultInstance.value()), e);
        }
        try {
            method = clazz.getDeclaredMethod(parts[1], new Class[0]);
            method.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(String.format("Failed to find method specified by @WithDefaultInstance(\"%s\")", withDefaultInstance.value()), e);
        }
        if (!Modifier.isStatic(method.getModifiers())) {
            throw new IllegalArgumentException(String.format("Expected method specified by @WithDefaultInstance(\"%s\") to be static", withDefaultInstance.value()));
        }
        if (!Message.class.isAssignableFrom(method.getReturnType())) {
            throw new IllegalArgumentException(String.format("Expected return type of method specified by @WithDefaultInstance(\"%s\") to be a subtype of %s, got %s", withDefaultInstance.value(), Message.class.getName(), method.getReturnType().getName()));
        }
        try {
            return (Message)method.invoke(null, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new IllegalArgumentException(String.format("Failed to execute method specified by @WithDefaultInstance(\"%s\")", withDefaultInstance.value()), e);
        }
    }
}

