/*
 * Decompiled with CFR 0.152.
 */
package com.code_intelligence.jazzer.mutation.mutator.collection;

import com.code_intelligence.jazzer.mutation.annotation.WithSize;
import com.code_intelligence.jazzer.mutation.api.Debuggable;
import com.code_intelligence.jazzer.mutation.api.MutatorFactory;
import com.code_intelligence.jazzer.mutation.api.PseudoRandom;
import com.code_intelligence.jazzer.mutation.api.SerializingInPlaceMutator;
import com.code_intelligence.jazzer.mutation.api.SerializingMutator;
import com.code_intelligence.jazzer.mutation.mutator.collection.ChunkCrossOvers;
import com.code_intelligence.jazzer.mutation.mutator.collection.ChunkMutations;
import com.code_intelligence.jazzer.mutation.support.Preconditions;
import com.code_intelligence.jazzer.mutation.support.RandomSupport;
import com.code_intelligence.jazzer.mutation.support.TypeSupport;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.AnnotatedType;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;

final class ListMutatorFactory
extends MutatorFactory {
    ListMutatorFactory() {
    }

    @Override
    public Optional<SerializingMutator<?>> tryCreate(AnnotatedType type2, MutatorFactory factory) {
        Optional<WithSize> withSize = Optional.ofNullable(type2.getAnnotation(WithSize.class));
        int minSize = withSize.map(WithSize::min).orElse(0);
        int maxSize = withSize.map(WithSize::max).orElse(1000);
        return TypeSupport.parameterTypeIfParameterized(type2, List.class).flatMap(factory::tryCreate).map(elementMutator -> new ListMutator(elementMutator, minSize, maxSize));
    }

    private static final class ListMutator<T>
    extends SerializingInPlaceMutator<List<T>> {
        private static final int DEFAULT_MIN_SIZE = 0;
        private static final int DEFAULT_MAX_SIZE = 1000;
        private final SerializingMutator<T> elementMutator;
        private final int minSize;
        private final int maxSize;

        ListMutator(SerializingMutator<T> elementMutator, int minSize, int maxSize) {
            this.elementMutator = elementMutator;
            this.minSize = minSize;
            this.maxSize = maxSize;
            Preconditions.require(maxSize >= 1, String.format("WithSize#max=%d needs to be greater than 0", maxSize));
            Preconditions.require(minSize >= 0, String.format("WithSize#min=%d needs to be positive", minSize));
            Preconditions.require(minSize <= maxSize, String.format("WithSize#min=%d needs to be smaller or equal than WithSize#max=%d", minSize, maxSize));
        }

        @Override
        public List<T> read(DataInputStream in) throws IOException {
            int size = RandomSupport.clamp(in.readInt(), this.minSize, this.maxSize);
            ArrayList list = new ArrayList(size);
            for (int i = 0; i < size; ++i) {
                list.add(this.elementMutator.read(in));
            }
            return list;
        }

        @Override
        public void write(List<T> list, DataOutputStream out) throws IOException {
            out.writeInt(list.size());
            for (T element : list) {
                this.elementMutator.write(element, out);
            }
        }

        @Override
        protected List<T> makeDefaultInstance() {
            return new ArrayList(this.maxInitialSize());
        }

        @Override
        public void initInPlace(List<T> list, PseudoRandom prng) {
            int targetSize = prng.closedRange(this.minInitialSize(), this.maxInitialSize());
            list.clear();
            for (int i = 0; i < targetSize; ++i) {
                list.add(this.elementMutator.init(prng));
            }
        }

        @Override
        public void mutateInPlace(List<T> list, PseudoRandom prng) {
            switch (ChunkMutations.MutationAction.pickRandomMutationAction(list, this.minSize, this.maxSize, prng)) {
                case DELETE_CHUNK: {
                    ChunkMutations.deleteRandomChunk(list, this.minSize, prng, this.elementMutator.hasFixedSize());
                    break;
                }
                case INSERT_CHUNK: {
                    ChunkMutations.insertRandomChunk(list, this.maxSize, this.elementMutator, prng);
                    break;
                }
                case MUTATE_CHUNK: {
                    ChunkMutations.mutateRandomChunk(list, this.elementMutator, prng);
                    break;
                }
                default: {
                    throw new IllegalStateException("unsupported action");
                }
            }
        }

        @Override
        public void crossOverInPlace(List<T> reference, List<T> otherReference, PseudoRandom prng) {
            switch (ChunkCrossOvers.CrossOverAction.pickRandomCrossOverAction(reference, otherReference, this.maxSize, prng)) {
                case INSERT_CHUNK: {
                    ChunkCrossOvers.insertChunk(reference, otherReference, this.maxSize, prng, this.elementMutator.hasFixedSize());
                    break;
                }
                case OVERWRITE_CHUNK: {
                    ChunkCrossOvers.overwriteChunk(reference, otherReference, prng, this.elementMutator.hasFixedSize());
                    break;
                }
                case CROSS_OVER_CHUNK: {
                    ChunkCrossOvers.crossOverChunk(reference, otherReference, this.elementMutator, prng);
                    break;
                }
            }
        }

        @Override
        public boolean hasFixedSize() {
            return false;
        }

        @Override
        public List<T> detach(List<T> value) {
            return value.stream().map(this.elementMutator::detach).collect(Collectors.toCollection(() -> new ArrayList(value.size())));
        }

        @Override
        public String toDebugString(Predicate<Debuggable> isInCycle) {
            return "List<" + this.elementMutator.toDebugString(isInCycle) + ">";
        }

        private int minInitialSize() {
            return this.minSize;
        }

        private int maxInitialSize() {
            return Math.min(this.maxSize, this.minSize + 1);
        }
    }
}

