/*
 * Decompiled with CFR 0.152.
 */
package com.code_intelligence.jazzer.driver;

import com.code_intelligence.jazzer.driver.OptItem;
import com.code_intelligence.jazzer.driver.OptParser;
import com.code_intelligence.jazzer.utils.Log;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;

public final class Opt {
    public static final OptItem<List<String>> additionalClassesExcludes;
    public static final OptItem<String> agentPath;
    public static final OptItem<String> androidBootclassClassesOverrides;
    public static final OptItem<String> androidInitOptions;
    public static final OptItem<String> autofuzz;
    public static final OptItem<Boolean> asan;
    public static final OptItem<List<String>> autofuzzIgnore;
    public static final OptItem<String> coverageDump;
    public static final OptItem<String> coverageReport;
    public static final OptItem<List<String>> cp;
    public static final OptItem<List<String>> customHookExcludes;
    public static final OptItem<List<String>> customHooks;
    public static final OptItem<List<String>> customHookIncludes;
    public static final OptItem<Boolean> dedup;
    public static final OptItem<List<String>> disabledHooks;
    public static final OptItem<String> dumpClassesDir;
    public static final OptItem<Boolean> experimentalMutator;
    public static final OptItem<Long> experimentalCrossOverFrequency;
    public static final OptItem<Boolean> fuzzNative;
    public static final OptItem<Boolean> hooks;
    public static final OptItem<Boolean> hwasan;
    public static final OptItem<String> idSyncFile;
    public static final OptItem<List<String>> ignore;
    public static final OptItem<List<String>> instrument;
    public static final OptItem<List<String>> instrumentationExcludes;
    public static final OptItem<List<String>> instrumentationIncludes;
    public static final OptItem<Long> keepGoing;
    public static final OptItem<String> reproducerPath;
    public static final OptItem<List<String>> targetArgs;
    public static final OptItem<String> targetClass;
    public static final OptItem<String> targetMethod;
    public static final OptItem<List<String>> trace;
    public static final OptItem<Boolean> ubsan;
    public static final OptItem<Boolean> isJUnitAndCommandLine;
    public static final OptItem<Boolean> mergeInner;
    public static final OptItem<Boolean> conditionalHooks;
    private static final OptItem<Boolean> help;
    public static final OptItem<List<String>> instrumentOnly;
    private static final OptItem<Boolean> version;

    public static void registerAndValidateCommandLineArgs(List<Map.Entry<String, String>> cliArgs) {
        OptParser.registerAndValidateCommandLineArgs(cliArgs);
    }

    public static void registerConfigurationParameters(Function<String, Optional<String>> configurationParameterGetter) {
        OptParser.registerConfigurationParameters(configurationParameterGetter);
    }

    public static void handleHelpAndVersionArgs() {
        if (help.get().booleanValue()) {
            Log.println(OptParser.getHelpText());
            System.exit(0);
        }
        if (version.get().booleanValue()) {
            Log.println("Jazzer v0.22.1");
            System.exit(0);
        }
    }

    static {
        if (Opt.class.getClassLoader() == null) {
            throw new IllegalStateException("Opt should not be loaded in the bootstrap class loader");
        }
        OptParser.stringListSetting("additional_jvm_args", "Additional arguments to pass to the JVM (separator can be escaped with '\\', native launcher only)");
        OptParser.stringListSetting("jvm_args", "Arguments to pass to the JVM (separator can be escaped with '\\', native launcher only)");
        additionalClassesExcludes = OptParser.stringListSetting("additional_classes_excludes", "Glob patterns matching names of classes from Java that are not in your jar file, but may be included in your program");
        agentPath = OptParser.stringSetting("agent_path", "", "Custom path to jazzer_agent_deploy.jar (native launcher only)");
        androidBootclassClassesOverrides = OptParser.stringSetting("android_bootpath_classes_overrides", "", "Used for fuzzing classes loaded in through the bootstrap class loader on Android. Full path to jar file with the instrumented versions of the classes you want to override.");
        androidInitOptions = OptParser.stringSetting("android_init_options", "", "Which libraries to use when initializing ART (native launcher only)");
        autofuzz = OptParser.stringSetting("autofuzz", "", "Fully qualified reference (optionally with a Javadoc-style signature) to a method on the class path to be fuzzed with automatically generated arguments (examples: java.lang.System.out::println, java.lang.String::new(byte[]))");
        asan = OptParser.boolSetting("asan", false, "Allow fuzzing of native libraries compiled with '-fsanitize=address'");
        autofuzzIgnore = OptParser.stringListSetting("autofuzz_ignore", ',', "Fully qualified names of exception classes to ignore during fuzzing");
        coverageDump = OptParser.stringSetting("coverage_dump", "", "Path to write a JaCoCo .exec file to when the fuzzer exits (if non-empty)");
        coverageReport = OptParser.stringSetting("coverage_report", "", "Path to write a human-readable coverage report to when the fuzzer exits (if non-empty)");
        cp = OptParser.stringListSetting("cp", "The class path to use for fuzzing (native launcher only)");
        customHookExcludes = OptParser.stringListSetting("custom_hook_excludes", "Glob patterns matching names of classes that should not be instrumented with hooks (custom and built-in)");
        customHooks = OptParser.stringListSetting("custom_hooks", "Names of classes to load custom hooks from");
        customHookIncludes = OptParser.stringListSetting("custom_hook_includes", "Glob patterns matching names of classes to instrument with hooks (custom and built-in)");
        dedup = OptParser.boolSetting("dedup", true, "Compute and print a deduplication token for every finding");
        disabledHooks = OptParser.stringListSetting("disabled_hooks", "Names of classes from which hooks (custom or built-in) should not be loaded from");
        dumpClassesDir = OptParser.stringSetting("dump_classes_dir", "", "Directory to dump instrumented .class files into (if non-empty)");
        experimentalMutator = OptParser.boolSetting("experimental_mutator", false, "Use an experimental structured mutator");
        experimentalCrossOverFrequency = OptParser.uint64Setting("experimental_cross_over_frequency", 100L, "(Used in experimental mutator) Frequency of cross-over mutations actually being executed when the cross-over function is picked by the underlying fuzzing engine (~1/2 of all mutations), other invocations perform type specific mutations via the experimental mutator. (0 = disabled, 1 = every call, 2 = every other call, etc.).");
        fuzzNative = OptParser.boolSetting("native", false, "Allow fuzzing of native libraries compiled with '-fsanitize=fuzzer' (implied by --asan and --ubsan)");
        hooks = OptParser.boolSetting("hooks", true, "Apply fuzzing instrumentation (use 'trace' for finer-grained control)");
        hwasan = OptParser.boolSetting("hwasan", false, "Allow fuzzing of native libraries compiled with hwasan");
        idSyncFile = OptParser.stringSetting("id_sync_file", "", "A file used by Jazzer subprocesses to coordinate coverage instrumented. If not set, Jazzer will create a temporary file and pass it to subprocesses.");
        ignore = OptParser.stringListSetting("ignore", ',', "Hex strings representing deduplication tokens of findings that should be ignored");
        instrument = OptParser.stringListSetting("instrument", ',', "Glob patterns matching names of classes that should be instrumented for fuzzing. This sets both instrumentation_includes and custom_hook_includes, depending on the mode (regression test or fuzzing). Only used for JUnit fuzz tests");
        instrumentationExcludes = OptParser.stringListSetting("instrumentation_excludes", "Glob patterns matching names of classes that should not be instrumented for fuzzing");
        instrumentationIncludes = OptParser.stringListSetting("instrumentation_includes", "Glob patterns matching names of classes to instrument for fuzzing");
        keepGoing = OptParser.uint64Setting("keep_going", 1L, "Number of distinct findings after which the fuzzer should stop");
        reproducerPath = OptParser.stringSetting("reproducer_path", ".", "Directory in which stand-alone Java reproducers are stored for each finding");
        targetArgs = OptParser.stringListSetting("target_args", ' ', "Arguments to pass to the fuzz target's fuzzerInitialize method");
        targetClass = OptParser.stringSetting("target_class", "", "Fully qualified name of the fuzz target class (required unless --autofuzz is specified)");
        targetMethod = OptParser.stringSetting("target_method", "", "The name of the @FuzzTest to execute in the class specified by --target_class");
        trace = OptParser.stringListSetting("trace", "Types of instrumentation to apply: cmp, cov, div, gep (disabled by default), indir, native");
        ubsan = OptParser.boolSetting("ubsan", false, "Allow fuzzing of native libraries compiled with '-fsanitize=undefined'");
        isJUnitAndCommandLine = OptParser.boolSetting("command_line", false, null);
        mergeInner = OptParser.boolSetting("merge_inner", false, null);
        conditionalHooks = OptParser.boolSetting("conditional_hooks", false, null);
        help = OptParser.boolSetting("help", false, "Show this list of all available arguments");
        instrumentOnly = OptParser.stringListSetting("instrument_only", ',', "Comma separated list of jar files to instrument. No fuzzing is performed.");
        version = OptParser.boolSetting("version", false, "Print version information");
    }
}

