/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.groovy.cps;

import com.cloudbees.groovy.cps.Builder;
import com.cloudbees.groovy.cps.CatchExpression;
import com.cloudbees.groovy.cps.MethodLocation;
import com.cloudbees.groovy.cps.NonCPS;
import com.cloudbees.groovy.cps.Safepoint;
import com.cloudbees.groovy.cps.TransformerConfiguration;
import com.cloudbees.groovy.cps.WorkflowTransformed;
import com.cloudbees.groovy.cps.impl.CpsCallableInvocation;
import com.cloudbees.groovy.cps.impl.CpsFunction;
import com.cloudbees.groovy.cps.sandbox.Trusted;
import com.google.common.annotations.VisibleForTesting;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.DynamicVariable;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.GroovyCodeVisitor;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.VariableScope;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.ArrayExpression;
import org.codehaus.groovy.ast.expr.AttributeExpression;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.BitwiseNegationExpression;
import org.codehaus.groovy.ast.expr.BooleanExpression;
import org.codehaus.groovy.ast.expr.CastExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ClosureListExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.ElvisOperatorExpression;
import org.codehaus.groovy.ast.expr.EmptyExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.FieldExpression;
import org.codehaus.groovy.ast.expr.GStringExpression;
import org.codehaus.groovy.ast.expr.ListExpression;
import org.codehaus.groovy.ast.expr.MapEntryExpression;
import org.codehaus.groovy.ast.expr.MapExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.MethodPointerExpression;
import org.codehaus.groovy.ast.expr.NotExpression;
import org.codehaus.groovy.ast.expr.PostfixExpression;
import org.codehaus.groovy.ast.expr.PrefixExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.RangeExpression;
import org.codehaus.groovy.ast.expr.SpreadExpression;
import org.codehaus.groovy.ast.expr.SpreadMapExpression;
import org.codehaus.groovy.ast.expr.StaticMethodCallExpression;
import org.codehaus.groovy.ast.expr.TernaryExpression;
import org.codehaus.groovy.ast.expr.TupleExpression;
import org.codehaus.groovy.ast.expr.UnaryMinusExpression;
import org.codehaus.groovy.ast.expr.UnaryPlusExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.AssertStatement;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.BreakStatement;
import org.codehaus.groovy.ast.stmt.CaseStatement;
import org.codehaus.groovy.ast.stmt.CatchStatement;
import org.codehaus.groovy.ast.stmt.ContinueStatement;
import org.codehaus.groovy.ast.stmt.DoWhileStatement;
import org.codehaus.groovy.ast.stmt.EmptyStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.ForStatement;
import org.codehaus.groovy.ast.stmt.IfStatement;
import org.codehaus.groovy.ast.stmt.ReturnStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.ast.stmt.SwitchStatement;
import org.codehaus.groovy.ast.stmt.SynchronizedStatement;
import org.codehaus.groovy.ast.stmt.ThrowStatement;
import org.codehaus.groovy.ast.stmt.TryCatchStatement;
import org.codehaus.groovy.ast.stmt.WhileStatement;
import org.codehaus.groovy.classgen.AsmClassGenerator;
import org.codehaus.groovy.classgen.BytecodeExpression;
import org.codehaus.groovy.classgen.GeneratorContext;
import org.codehaus.groovy.classgen.Verifier;
import org.codehaus.groovy.control.CompilePhase;
import org.codehaus.groovy.control.Janitor;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.control.customizers.CompilationCustomizer;
import org.codehaus.groovy.runtime.powerassert.SourceText;
import org.codehaus.groovy.syntax.SyntaxException;
import org.codehaus.groovy.syntax.Token;

public class CpsTransformer
extends CompilationCustomizer
implements GroovyCodeVisitor {
    private static final Logger LOGGER = Logger.getLogger(CpsTransformer.class.getName());
    @VisibleForTesting
    public static final AtomicLong iota = new AtomicLong();
    private SourceUnit sourceUnit;
    protected ClassNode classNode;
    protected TransformerConfiguration config = new TransformerConfiguration();
    protected ParentClosure parent;
    private static final Map<Integer, String> BINARY_OP_TO_BUILDER_METHOD = new HashMap<Integer, String>();
    private static final ClassNode OBJECT_TYPE;
    private static final ClassNode FUNCTION_TYPE;
    private static final ClassNode CATCH_EXPRESSION_TYPE;
    private static final ClassNode BUILDER_TYPE;
    private static final ClassNode CPSCALLINVK_TYPE;
    private static final ClassNode WORKFLOW_TRANSFORMED_TYPE;
    private static final ClassNode BUIDER_TYPE;
    private static final ClassNode METHOD_LOCATION_TYPE;
    private static final ClassNode SERIALIZABLE_TYPE;
    private static final VariableExpression BUILDER;
    private static final VariableExpression THIS;
    private static final Parameter IT;
    private static final int PRIVATE_STATIC_FINAL = 26;

    public CpsTransformer() {
        super(CompilePhase.CANONICALIZATION);
    }

    public void setConfiguration(@Nonnull TransformerConfiguration config) {
        this.config = config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void call(SourceUnit source, GeneratorContext context, ClassNode classNode) {
        if (classNode.isInterface()) {
            return;
        }
        this.sourceUnit = source;
        this.classNode = classNode;
        try {
            for (FieldNode field : new ArrayList(classNode.getFields())) {
                this.visitNontransformedField(field);
            }
            for (MethodNode method : new ArrayList(classNode.getMethods())) {
                this.visitMethod(method);
            }
            this.processConstructors(classNode);
            for (Statement statement : new ArrayList(classNode.getObjectInitializerStatements())) {
                this.visitNontransformedStatement(statement);
            }
            classNode.addInterface(SERIALIZABLE_TYPE);
            if (classNode.getField("__timeStamp") == null) {
                classNode.addField("__timeStamp", 10, ClassHelper.long_TYPE, (Expression)new ConstantExpression((Object)0L));
            }
            classNode.addAnnotation(new AnnotationNode(WORKFLOW_TRANSFORMED_TYPE));
        }
        finally {
            this.sourceUnit = null;
            this.classNode = null;
            this.parent = null;
        }
    }

    protected void processConstructors(ClassNode classNode) {
        for (ConstructorNode constructor : new ArrayList(classNode.getDeclaredConstructors())) {
            this.visitNontransformedMethod((MethodNode)constructor);
        }
    }

    protected boolean shouldBeTransformed(MethodNode node) {
        return !node.isSynthetic() && !this.hasAnnotation(node, NonCPS.class) && !this.hasAnnotation(node, WorkflowTransformed.class) && !node.isAbstract();
    }

    boolean hasAnnotation(MethodNode node, Class<? extends Annotation> a) {
        for (AnnotationNode ann : node.getAnnotations()) {
            if (!ann.getClassNode().getName().equals(a.getName())) continue;
            return true;
        }
        return false;
    }

    public void visitMethod(MethodNode m) {
        if (!this.shouldBeTransformed(m)) {
            this.visitNontransformedMethod(m);
            return;
        }
        final AtomicReference body = new AtomicReference();
        this.parent = new ParentClosure(){

            @Override
            public void call(Expression e) {
                body.set(e);
            }
        };
        this.visitWithSafepoint(m.getCode());
        ListExpression params = new ListExpression();
        for (Parameter p : m.getParameters()) {
            params.addExpression((Expression)new ConstantExpression((Object)p.getName()));
        }
        String cpsName = "___cps___" + iota.getAndIncrement();
        DeclarationExpression builderDeclaration = new DeclarationExpression(BUILDER, new Token(100, "=", -1, -1), this.makeBuilder(m));
        ReturnStatement returnStatement = new ReturnStatement((Expression)new ConstructorCallExpression(FUNCTION_TYPE, (Expression)new TupleExpression((Expression)params, (Expression)body.get())));
        MethodNode builderMethod = m.getDeclaringClass().addMethod(cpsName, 26, FUNCTION_TYPE, new Parameter[0], new ClassNode[0], (Statement)new BlockStatement(Arrays.asList(new ExpressionStatement((Expression)builderDeclaration), returnStatement), new VariableScope()));
        builderMethod.addAnnotation(new AnnotationNode(WORKFLOW_TRANSFORMED_TYPE));
        FieldNode f = m.getDeclaringClass().addField(cpsName, 26, FUNCTION_TYPE, (Expression)new StaticMethodCallExpression(m.getDeclaringClass(), cpsName, (Expression)new TupleExpression()));
        Parameter[] pms = m.getParameters();
        ArrayList<VariableExpression> paramExpressions = new ArrayList<VariableExpression>(pms.length);
        for (Parameter p : pms) {
            paramExpressions.add(new VariableExpression((Variable)p));
        }
        ArrayExpression paramArray = new ArrayExpression(ClassHelper.OBJECT_TYPE, paramExpressions);
        TupleExpression args = new TupleExpression((Expression)new VariableExpression((Variable)f), (Expression)THIS, (Expression)paramArray);
        ConstructorCallExpression cce = new ConstructorCallExpression(CPSCALLINVK_TYPE, (Expression)args);
        m.setCode((Statement)new ThrowStatement((Expression)cce));
        m.addAnnotation(new AnnotationNode(WORKFLOW_TRANSFORMED_TYPE));
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "in {0} transformed {1} to {2}: throw {3} plus {4}: {5}; {6}", new Object[]{this.classNode.getName(), m.getTypeDescriptor(), m.getText(), cce.getText(), builderMethod.getText(), builderDeclaration.getText(), returnStatement.getText()});
        }
    }

    protected Expression makeBuilder(MethodNode m) {
        ConstructorCallExpression b = new ConstructorCallExpression(BUIDER_TYPE, (Expression)new TupleExpression((Expression)new ConstructorCallExpression(METHOD_LOCATION_TYPE, (Expression)new TupleExpression((Expression)new ConstantExpression((Object)m.getDeclaringClass().getName()), (Expression)new ConstantExpression((Object)m.getName()), (Expression)new ConstantExpression((Object)this.sourceUnit.getName())))));
        b = new MethodCallExpression((Expression)b, "withClosureType", (Expression)new TupleExpression((Expression)new ClassExpression(this.config.getClosureType())));
        Class tag = this.getTrustTag();
        if (tag != null) {
            b = new MethodCallExpression((Expression)b, "contextualize", (Expression)new PropertyExpression((Expression)new ClassExpression(ClassHelper.makeCached((Class)tag)), "INSTANCE"));
        }
        return b;
    }

    protected Class getTrustTag() {
        return Trusted.class;
    }

    protected void visitNontransformedMethod(MethodNode m) {
    }

    protected void visitNontransformedField(FieldNode f) {
    }

    protected void visitNontransformedStatement(Statement s) {
    }

    protected void visit(ASTNode e) {
        LOGGER.log(Level.FINER, "visiting {0}:{1}", new Object[]{this.sourceUnit.getName(), e.getLineNumber()});
        if (e instanceof EmptyExpression) {
            this.visitEmptyExpression((EmptyExpression)e);
        } else if (e instanceof EmptyStatement) {
            this.visitEmptyStatement((EmptyStatement)e);
        } else {
            e.visit((GroovyCodeVisitor)this);
        }
    }

    protected void visit(Collection<? extends ASTNode> col) {
        for (ASTNode aSTNode : col) {
            this.visit(aSTNode);
        }
    }

    protected void visitWithSafepoint(final Statement st) {
        if (this.config.getSafepoints().isEmpty()) {
            this.visit((ASTNode)st);
        } else {
            this.makeNode("block", new Runnable(){

                @Override
                public void run() {
                    for (final Safepoint s : CpsTransformer.this.config.getSafepoints()) {
                        CpsTransformer.this.makeNode("staticCall", new Runnable(){

                            @Override
                            public void run() {
                                CpsTransformer.this.loc((ASTNode)st);
                                CpsTransformer.this.literal(s.node);
                                CpsTransformer.this.literal(s.methodName);
                            }
                        });
                    }
                    CpsTransformer.this.visit((ASTNode)st);
                }
            });
        }
    }

    protected void makeNode(String methodName, Expression ... args) {
        this.parent.call((Expression)new MethodCallExpression((Expression)BUILDER, methodName, (Expression)this.makeChildren(args)));
    }

    protected void makeNode(String methodName, Runnable body) {
        this.parent.call((Expression)new MethodCallExpression((Expression)BUILDER, methodName, (Expression)this.makeChildren(body)));
    }

    protected void makeNode(ClassNode type, Expression ... args) {
        this.parent.call((Expression)new ConstructorCallExpression(type, (Expression)this.makeChildren(args)));
    }

    protected void makeNode(ClassNode type, Runnable body) {
        this.parent.call((Expression)new ConstructorCallExpression(type, (Expression)this.makeChildren(body)));
    }

    protected TupleExpression makeChildren(Expression ... args) {
        return new TupleExpression(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TupleExpression makeChildren(Runnable body) {
        final ArrayList argExps = new ArrayList();
        ParentClosure old = this.parent;
        try {
            this.parent = new ParentClosure(){

                @Override
                public void call(Expression e) {
                    argExps.add(e);
                }
            };
            body.run();
            TupleExpression tupleExpression = new TupleExpression(argExps);
            return tupleExpression;
        }
        finally {
            this.parent = old;
        }
    }

    protected void loc(ASTNode e) {
        this.literal(e.getLineNumber());
    }

    protected void literal(String s) {
        this.parent.call((Expression)new ConstantExpression((Object)s));
    }

    protected void literal(ClassNode c) {
        this.parent.call((Expression)new ClassExpression(c));
    }

    protected void literal(int n) {
        this.parent.call((Expression)new ConstantExpression((Object)n, true));
    }

    protected void literal(boolean b) {
        this.parent.call((Expression)new ConstantExpression((Object)b, true));
    }

    void visitEmptyExpression(EmptyExpression e) {
        this.makeNode("noop", new Expression[0]);
    }

    void visitEmptyStatement(EmptyStatement e) {
        this.makeNode("noop", new Expression[0]);
    }

    public void visitMethodCallExpression(final MethodCallExpression call) {
        this.makeNode("functionCall", new Runnable(){

            @Override
            public void run() {
                CpsTransformer.this.loc((ASTNode)call);
                if (call.isImplicitThis() && AsmClassGenerator.isThisExpression((Expression)call.getObjectExpression())) {
                    CpsTransformer.this.makeNode("javaThis_", new Expression[0]);
                } else {
                    CpsTransformer.this.visit((ASTNode)call.getObjectExpression());
                }
                if (call.isSpreadSafe()) {
                    throw new UnsupportedOperationException("spread not yet supported in " + call.getText());
                }
                CpsTransformer.this.visit((ASTNode)call.getMethod());
                CpsTransformer.this.literal(call.isSafe());
                CpsTransformer.this.visit(((TupleExpression)call.getArguments()).getExpressions());
            }
        });
    }

    public void visitBlockStatement(final BlockStatement b) {
        this.makeNode("block", new Runnable(){

            @Override
            public void run() {
                CpsTransformer.this.visit(b.getStatements());
            }
        });
    }

    public void visitForLoop(final ForStatement forLoop) {
        if (ForStatement.FOR_LOOP_DUMMY.equals(forLoop.getVariable())) {
            final ClosureListExpression loop = (ClosureListExpression)forLoop.getCollectionExpression();
            assert (loop.getExpressions().size() == 3);
            this.makeNode("forLoop", new Runnable(){

                @Override
                public void run() {
                    CpsTransformer.this.literal(forLoop.getStatementLabel());
                    CpsTransformer.this.visit(loop.getExpressions());
                    CpsTransformer.this.visitWithSafepoint(forLoop.getLoopBlock());
                }
            });
        } else {
            this.makeNode("forInLoop", new Runnable(){

                @Override
                public void run() {
                    CpsTransformer.this.loc((ASTNode)forLoop);
                    CpsTransformer.this.literal(forLoop.getStatementLabel());
                    CpsTransformer.this.literal(forLoop.getVariableType());
                    CpsTransformer.this.literal(forLoop.getVariable().getName());
                    CpsTransformer.this.visit((ASTNode)forLoop.getCollectionExpression());
                    CpsTransformer.this.visitWithSafepoint(forLoop.getLoopBlock());
                }
            });
        }
    }

    public void visitWhileLoop(final WhileStatement loop) {
        this.makeNode("while_", new Runnable(){

            @Override
            public void run() {
                CpsTransformer.this.literal(loop.getStatementLabel());
                CpsTransformer.this.visit((ASTNode)loop.getBooleanExpression());
                CpsTransformer.this.visitWithSafepoint(loop.getLoopBlock());
            }
        });
    }

    public void visitDoWhileLoop(final DoWhileStatement loop) {
        this.makeNode("doWhile", new Runnable(){

            @Override
            public void run() {
                CpsTransformer.this.literal(loop.getStatementLabel());
                CpsTransformer.this.visit((ASTNode)loop.getBooleanExpression());
                CpsTransformer.this.visitWithSafepoint(loop.getLoopBlock());
            }
        });
    }

    public void visitIfElse(final IfStatement stmt) {
        this.makeNode("if_", new Runnable(){

            @Override
            public void run() {
                CpsTransformer.this.visit((ASTNode)stmt.getBooleanExpression());
                CpsTransformer.this.visit((ASTNode)stmt.getIfBlock());
                CpsTransformer.this.visit((ASTNode)stmt.getElseBlock());
            }
        });
    }

    public void visitExpressionStatement(ExpressionStatement statement) {
        this.visit((ASTNode)statement.getExpression());
    }

    public void visitReturnStatement(final ReturnStatement statement) {
        this.makeNode("return_", new Runnable(){

            @Override
            public void run() {
                CpsTransformer.this.visit((ASTNode)statement.getExpression());
            }
        });
    }

    public void visitAssertStatement(final AssertStatement statement) {
        Janitor j = new Janitor();
        final String text = new SourceText(statement, this.sourceUnit, j).getNormalizedText();
        j.cleanup();
        this.makeNode("assert_", new Runnable(){

            @Override
            public void run() {
                CpsTransformer.this.visit((ASTNode)statement.getBooleanExpression());
                CpsTransformer.this.visit((ASTNode)statement.getMessageExpression());
                CpsTransformer.this.literal(text);
            }
        });
    }

    public void visitTryCatchFinally(final TryCatchStatement stmt) {
        this.makeNode("tryCatch", new Runnable(){

            @Override
            public void run() {
                CpsTransformer.this.visit((ASTNode)stmt.getTryStatement());
                CpsTransformer.this.visit((ASTNode)stmt.getFinallyStatement());
                CpsTransformer.this.visit(stmt.getCatchStatements());
            }
        });
    }

    public void visitSwitch(final SwitchStatement stmt) {
        this.makeNode("switch_", new Runnable(){

            @Override
            public void run() {
                CpsTransformer.this.literal(stmt.getStatementLabel());
                CpsTransformer.this.visit((ASTNode)stmt.getExpression());
                CpsTransformer.this.visit((ASTNode)stmt.getDefaultStatement());
                CpsTransformer.this.visit(stmt.getCaseStatements());
            }
        });
    }

    public void visitCaseStatement(final CaseStatement stmt) {
        this.makeNode("case_", new Runnable(){

            @Override
            public void run() {
                CpsTransformer.this.loc((ASTNode)stmt);
                CpsTransformer.this.visit((ASTNode)stmt.getExpression());
                CpsTransformer.this.visit((ASTNode)stmt.getCode());
            }
        });
    }

    public void visitBreakStatement(BreakStatement statement) {
        this.makeNode("break_", new Expression[]{new ConstantExpression((Object)statement.getLabel())});
    }

    public void visitContinueStatement(ContinueStatement statement) {
        this.makeNode("continue_", new Expression[]{new ConstantExpression((Object)statement.getLabel())});
    }

    public void visitThrowStatement(final ThrowStatement st) {
        this.makeNode("throw_", new Runnable(){

            @Override
            public void run() {
                CpsTransformer.this.loc((ASTNode)st);
                CpsTransformer.this.visit((ASTNode)st.getExpression());
            }
        });
    }

    public void visitSynchronizedStatement(SynchronizedStatement statement) {
        throw new UnsupportedOperationException();
    }

    public void visitCatchStatement(final CatchStatement stmt) {
        this.makeNode(CATCH_EXPRESSION_TYPE, new Runnable(){

            @Override
            public void run() {
                CpsTransformer.this.literal(stmt.getExceptionType());
                CpsTransformer.this.literal(stmt.getVariable().getName());
                CpsTransformer.this.visit((ASTNode)stmt.getCode());
            }
        });
    }

    public void visitStaticMethodCallExpression(final StaticMethodCallExpression exp) {
        this.makeNode("staticCall", new Runnable(){

            @Override
            public void run() {
                CpsTransformer.this.loc((ASTNode)exp);
                CpsTransformer.this.literal(exp.getOwnerType());
                CpsTransformer.this.literal(exp.getMethod());
                CpsTransformer.this.visit(((TupleExpression)exp.getArguments()).getExpressions());
            }
        });
    }

    public void visitConstructorCallExpression(final ConstructorCallExpression call) {
        this.makeNode("new_", new Runnable(){

            @Override
            public void run() {
                CpsTransformer.this.loc((ASTNode)call);
                CpsTransformer.this.literal(call.getType());
                CpsTransformer.this.visit(((TupleExpression)call.getArguments()).getExpressions());
            }
        });
    }

    public void visitTernaryExpression(final TernaryExpression exp) {
        this.makeNode("ternaryOp", new Runnable(){

            @Override
            public void run() {
                CpsTransformer.this.visit((ASTNode)exp.getBooleanExpression());
                CpsTransformer.this.visit((ASTNode)exp.getTrueExpression());
                CpsTransformer.this.visit((ASTNode)exp.getFalseExpression());
            }
        });
    }

    public void visitShortTernaryExpression(final ElvisOperatorExpression exp) {
        this.makeNode("elvisOp", new Runnable(){

            @Override
            public void run() {
                CpsTransformer.this.visit((ASTNode)exp.getBooleanExpression());
                CpsTransformer.this.visit((ASTNode)exp.getFalseExpression());
            }
        });
    }

    private void multipleAssignment(final Expression parentExpression, TupleExpression tuple, final Expression rhs) {
        List tupleExpressions = tuple.getExpressions();
        int tupleExpressionsSize = tupleExpressions.size();
        for (int i = 0; i < tupleExpressionsSize; ++i) {
            final Expression tupleExpression = (Expression)tupleExpressions.get(i);
            ConstantExpression index = new ConstantExpression((Object)i, true);
            this.makeNode("assign", new Runnable((Expression)index){
                final /* synthetic */ Expression val$index;
                {
                    this.val$index = expression4;
                }

                @Override
                public void run() {
                    CpsTransformer.this.loc((ASTNode)parentExpression);
                    CpsTransformer.this.visit((ASTNode)tupleExpression);
                    CpsTransformer.this.makeNode("array", new Runnable(){

                        @Override
                        public void run() {
                            CpsTransformer.this.loc((ASTNode)rhs);
                            CpsTransformer.this.visit((ASTNode)rhs);
                            CpsTransformer.this.makeNode("constant", val$index);
                        }
                    });
                }
            });
        }
    }

    public void visitBinaryExpression(final BinaryExpression exp) {
        String name = BINARY_OP_TO_BUILDER_METHOD.get(exp.getOperation().getType());
        if (name != null) {
            if (name.equals("assign") && exp.getLeftExpression() instanceof TupleExpression) {
                this.multipleAssignment((Expression)exp, (TupleExpression)exp.getLeftExpression(), exp.getRightExpression());
            } else {
                this.makeNode(name, new Runnable(){

                    @Override
                    public void run() {
                        CpsTransformer.this.loc((ASTNode)exp);
                        CpsTransformer.this.visit((ASTNode)exp.getLeftExpression());
                        CpsTransformer.this.visit((ASTNode)exp.getRightExpression());
                    }
                });
            }
            return;
        }
        throw new UnsupportedOperationException("Operation: " + exp.getOperation() + " not supported");
    }

    public void visitPrefixExpression(final PrefixExpression exp) {
        this.makeNode("prefix" + this.prepostfixOperatorSuffix(exp.getOperation()), new Runnable(){

            @Override
            public void run() {
                CpsTransformer.this.loc((ASTNode)exp);
                CpsTransformer.this.visit((ASTNode)exp.getExpression());
            }
        });
    }

    public void visitPostfixExpression(final PostfixExpression exp) {
        this.makeNode("postfix" + this.prepostfixOperatorSuffix(exp.getOperation()), new Runnable(){

            @Override
            public void run() {
                CpsTransformer.this.loc((ASTNode)exp);
                CpsTransformer.this.visit((ASTNode)exp.getExpression());
            }
        });
    }

    protected String prepostfixOperatorSuffix(Token operation) {
        switch (operation.getType()) {
            case 250: {
                return "Inc";
            }
            case 260: {
                return "Dec";
            }
        }
        throw new UnsupportedOperationException("Unknown operator:" + operation.getText());
    }

    public void visitBooleanExpression(BooleanExpression exp) {
        this.visit((ASTNode)exp.getExpression());
    }

    public void visitClosureExpression(final ClosureExpression exp) {
        this.makeNode("closure", new Runnable(){

            @Override
            public void run() {
                ListExpression params;
                ListExpression types;
                CpsTransformer.this.loc((ASTNode)exp);
                if (exp.getParameters() == null) {
                    types = new ListExpression(Collections.EMPTY_LIST);
                    params = new ListExpression(Collections.EMPTY_LIST);
                } else if (exp.getParameters().length == 0) {
                    types = new ListExpression(Collections.singletonList(new ClassExpression(OBJECT_TYPE)));
                    params = new ListExpression(Collections.singletonList(new ConstantExpression((Object)"it")));
                } else {
                    Parameter[] paramArray = exp.getParameters();
                    ArrayList<ClassExpression> typesList = new ArrayList<ClassExpression>(paramArray.length);
                    ArrayList<ConstantExpression> paramsList = new ArrayList<ConstantExpression>(paramArray.length);
                    for (Parameter p : paramArray) {
                        typesList.add(new ClassExpression(p.getType()));
                        paramsList.add(new ConstantExpression((Object)p.getName()));
                    }
                    types = new ListExpression(typesList);
                    params = new ListExpression(paramsList);
                }
                CpsTransformer.this.parent.call((Expression)types);
                CpsTransformer.this.parent.call((Expression)params);
                CpsTransformer.this.visitWithSafepoint(exp.getCode());
            }
        });
    }

    public void visitTupleExpression(TupleExpression expression) {
        throw new UnsupportedOperationException();
    }

    public void visitMapExpression(final MapExpression exp) {
        if (exp.getMapEntryExpressions().size() > 125) {
            this.sourceUnit.addError(new SyntaxException("Map expressions can only contain up to 125 entries", exp.getLineNumber(), exp.getColumnNumber()));
        } else {
            this.makeNode("map", new Runnable(){

                @Override
                public void run() {
                    for (MapEntryExpression e : exp.getMapEntryExpressions()) {
                        CpsTransformer.this.visit((ASTNode)e.getKeyExpression());
                        CpsTransformer.this.visit((ASTNode)e.getValueExpression());
                    }
                }
            });
        }
    }

    public void visitMapEntryExpression(MapEntryExpression expression) {
        throw new UnsupportedOperationException();
    }

    public void visitListExpression(final ListExpression exp) {
        if (exp.getExpressions().size() > 250) {
            this.sourceUnit.addError(new SyntaxException("List expressions can only contain up to 250 elements", exp.getLineNumber(), exp.getColumnNumber()));
        } else {
            this.makeNode("list", new Runnable(){

                @Override
                public void run() {
                    CpsTransformer.this.visit(exp.getExpressions());
                }
            });
        }
    }

    public void visitRangeExpression(final RangeExpression exp) {
        this.makeNode("range", new Runnable(){

            @Override
            public void run() {
                CpsTransformer.this.loc((ASTNode)exp);
                CpsTransformer.this.visit((ASTNode)exp.getFrom());
                CpsTransformer.this.visit((ASTNode)exp.getTo());
                CpsTransformer.this.literal(exp.isInclusive());
            }
        });
    }

    public void visitPropertyExpression(final PropertyExpression exp) {
        if (exp.getObjectExpression() instanceof VariableExpression && ((VariableExpression)exp.getObjectExpression()).isThisExpression() && exp.getProperty() instanceof ConstantExpression && this.classNode.getSetterMethod("set" + Verifier.capitalize((String)((String)((ConstantExpression)exp.getProperty()).getValue())), false) != null) {
            this.makeNode("attribute", new Runnable(){

                @Override
                public void run() {
                    CpsTransformer.this.loc((ASTNode)exp);
                    CpsTransformer.this.visit((ASTNode)exp.getObjectExpression());
                    CpsTransformer.this.visit((ASTNode)exp.getProperty());
                    CpsTransformer.this.literal(exp.isSafe());
                }
            });
        } else {
            this.makeNode("property", new Runnable(){

                @Override
                public void run() {
                    CpsTransformer.this.loc((ASTNode)exp);
                    CpsTransformer.this.visit((ASTNode)exp.getObjectExpression());
                    CpsTransformer.this.visit((ASTNode)exp.getProperty());
                    CpsTransformer.this.literal(exp.isSafe());
                }
            });
        }
    }

    public void visitAttributeExpression(final AttributeExpression exp) {
        this.makeNode("attribute", new Runnable(){

            @Override
            public void run() {
                CpsTransformer.this.loc((ASTNode)exp);
                CpsTransformer.this.visit((ASTNode)exp.getObjectExpression());
                CpsTransformer.this.visit((ASTNode)exp.getProperty());
                CpsTransformer.this.literal(exp.isSafe());
            }
        });
    }

    public void visitFieldExpression(final FieldExpression exp) {
        final FieldNode f = exp.getField();
        if (f.isStatic()) {
            this.makeNode("staticField", new Runnable(){

                @Override
                public void run() {
                    CpsTransformer.this.loc((ASTNode)exp);
                    CpsTransformer.this.literal(f.getType());
                    CpsTransformer.this.literal(exp.getFieldName());
                }
            });
        } else {
            this.makeNode("property", new Runnable(){

                @Override
                public void run() {
                    CpsTransformer.this.loc((ASTNode)exp);
                    CpsTransformer.this.makeNode("this_", new Expression[0]);
                    CpsTransformer.this.literal(exp.getFieldName());
                }
            });
        }
    }

    public void visitMethodPointerExpression(final MethodPointerExpression exp) {
        this.makeNode("methodPointer", new Runnable(){

            @Override
            public void run() {
                CpsTransformer.this.loc((ASTNode)exp);
                CpsTransformer.this.visit((ASTNode)exp.getExpression());
                CpsTransformer.this.visit((ASTNode)exp.getMethodName());
            }
        });
    }

    public void visitConstantExpression(ConstantExpression expression) {
        this.makeNode("constant", new Expression[]{expression});
    }

    public void visitClassExpression(ClassExpression expression) {
        this.makeNode("constant", new Expression[]{expression});
    }

    public void visitVariableExpression(final VariableExpression exp) {
        Variable ref = exp.getAccessedVariable();
        if (ref instanceof VariableExpression || ref instanceof Parameter) {
            this.makeNode("localVariable", new Runnable(){

                @Override
                public void run() {
                    CpsTransformer.this.loc((ASTNode)exp);
                    CpsTransformer.this.literal(exp.getName());
                }
            });
        } else if (ref instanceof DynamicVariable || ref instanceof PropertyNode || ref instanceof FieldNode) {
            if (ref instanceof FieldNode && this.classNode.getGetterMethod("get" + Verifier.capitalize((String)exp.getName())) != null) {
                this.makeNode("attribute", new Runnable(){

                    @Override
                    public void run() {
                        CpsTransformer.this.loc((ASTNode)exp);
                        CpsTransformer.this.makeNode("javaThis_", new Expression[0]);
                        CpsTransformer.this.visit((ASTNode)new ConstantExpression((Object)exp.getName()));
                        CpsTransformer.this.literal(false);
                    }
                });
            } else {
                this.makeNode("property", new Runnable(){

                    @Override
                    public void run() {
                        CpsTransformer.this.loc((ASTNode)exp);
                        CpsTransformer.this.makeNode("javaThis_", new Expression[0]);
                        CpsTransformer.this.literal(exp.getName());
                    }
                });
            }
        } else if ("this".equals(exp.getName())) {
            this.makeNode("this_", new Expression[0]);
        } else if ("super".equals(exp.getName())) {
            this.makeNode("super_", new Runnable(){

                @Override
                public void run() {
                    CpsTransformer.this.literal(CpsTransformer.this.classNode);
                }
            });
        } else {
            this.sourceUnit.addError(new SyntaxException("Unsupported expression for CPS transformation", exp.getLineNumber(), exp.getColumnNumber()));
        }
    }

    public void visitDeclarationExpression(final DeclarationExpression exp) {
        if (exp.isMultipleAssignmentDeclaration()) {
            this.makeNode("sequence", new Runnable(){

                @Override
                public void run() {
                    for (Expression e : exp.getTupleExpression().getExpressions()) {
                        final VariableExpression v = (VariableExpression)e;
                        CpsTransformer.this.makeNode("declareVariable", new Runnable(){

                            @Override
                            public void run() {
                                CpsTransformer.this.literal(v.getType());
                                CpsTransformer.this.literal(v.getName());
                            }
                        });
                    }
                    CpsTransformer.this.multipleAssignment((Expression)exp, exp.getTupleExpression(), exp.getRightExpression());
                }
            });
        } else {
            this.makeNode("declareVariable", new Runnable(){

                @Override
                public void run() {
                    VariableExpression v = exp.getVariableExpression();
                    CpsTransformer.this.loc((ASTNode)exp);
                    CpsTransformer.this.literal(v.getType());
                    CpsTransformer.this.literal(v.getName());
                    CpsTransformer.this.visit((ASTNode)exp.getRightExpression());
                }
            });
        }
    }

    public void visitGStringExpression(final GStringExpression exp) {
        this.makeNode("gstring", new Runnable(){

            @Override
            public void run() {
                CpsTransformer.this.loc((ASTNode)exp);
                CpsTransformer.this.makeNode("list", new Runnable(){

                    @Override
                    public void run() {
                        CpsTransformer.this.visit(exp.getValues());
                    }
                });
                CpsTransformer.this.makeNode("list", new Runnable(){

                    @Override
                    public void run() {
                        CpsTransformer.this.visit(exp.getStrings());
                    }
                });
            }
        });
    }

    public void visitArrayExpression(final ArrayExpression exp) {
        if (exp.getSizeExpression() == null) {
            throw new UnsupportedOperationException(exp.getText());
        }
        this.makeNode("newArray", new Runnable(){

            @Override
            public void run() {
                CpsTransformer.this.loc((ASTNode)exp);
                CpsTransformer.this.literal(exp.getElementType());
                CpsTransformer.this.visit(exp.getSizeExpression());
            }
        });
    }

    public void visitSpreadExpression(SpreadExpression expression) {
        throw new UnsupportedOperationException();
    }

    public void visitSpreadMapExpression(SpreadMapExpression expression) {
        throw new UnsupportedOperationException();
    }

    public void visitNotExpression(final NotExpression exp) {
        this.makeNode("not", new Runnable(){

            @Override
            public void run() {
                CpsTransformer.this.loc((ASTNode)exp);
                CpsTransformer.this.visit((ASTNode)exp.getExpression());
            }
        });
    }

    public void visitUnaryMinusExpression(final UnaryMinusExpression exp) {
        this.makeNode("unaryMinus", new Runnable(){

            @Override
            public void run() {
                CpsTransformer.this.loc((ASTNode)exp);
                CpsTransformer.this.visit((ASTNode)exp.getExpression());
            }
        });
    }

    public void visitUnaryPlusExpression(final UnaryPlusExpression exp) {
        this.makeNode("unaryPlus", new Runnable(){

            @Override
            public void run() {
                CpsTransformer.this.loc((ASTNode)exp);
                CpsTransformer.this.visit((ASTNode)exp.getExpression());
            }
        });
    }

    public void visitBitwiseNegationExpression(final BitwiseNegationExpression exp) {
        this.makeNode("bitwiseNegation", new Runnable(){

            @Override
            public void run() {
                CpsTransformer.this.loc((ASTNode)exp);
                CpsTransformer.this.visit((ASTNode)exp.getExpression());
            }
        });
    }

    public void visitCastExpression(final CastExpression exp) {
        this.makeNode("cast", new Runnable(){

            @Override
            public void run() {
                CpsTransformer.this.loc((ASTNode)exp);
                CpsTransformer.this.visit((ASTNode)exp.getExpression());
                CpsTransformer.this.literal(exp.getType());
                CpsTransformer.this.literal(exp.isCoerce());
            }
        });
    }

    public void visitArgumentlistExpression(ArgumentListExpression expression) {
        throw new UnsupportedOperationException();
    }

    public void visitClosureListExpression(ClosureListExpression closureListExpression) {
        throw new UnsupportedOperationException();
    }

    public void visitBytecodeExpression(BytecodeExpression expression) {
        throw new UnsupportedOperationException();
    }

    static {
        BINARY_OP_TO_BUILDER_METHOD.put(123, "compareEqual");
        BINARY_OP_TO_BUILDER_METHOD.put(120, "compareNotEqual");
        BINARY_OP_TO_BUILDER_METHOD.put(128, "compareTo");
        BINARY_OP_TO_BUILDER_METHOD.put(126, "greaterThan");
        BINARY_OP_TO_BUILDER_METHOD.put(127, "greaterThanEqual");
        BINARY_OP_TO_BUILDER_METHOD.put(124, "lessThan");
        BINARY_OP_TO_BUILDER_METHOD.put(125, "lessThanEqual");
        BINARY_OP_TO_BUILDER_METHOD.put(164, "logicalAnd");
        BINARY_OP_TO_BUILDER_METHOD.put(162, "logicalOr");
        BINARY_OP_TO_BUILDER_METHOD.put(341, "bitwiseAnd");
        BINARY_OP_TO_BUILDER_METHOD.put(351, "bitwiseAndEqual");
        BINARY_OP_TO_BUILDER_METHOD.put(340, "bitwiseOr");
        BINARY_OP_TO_BUILDER_METHOD.put(350, "bitwiseOrEqual");
        BINARY_OP_TO_BUILDER_METHOD.put(342, "bitwiseXor");
        BINARY_OP_TO_BUILDER_METHOD.put(352, "bitwiseXorEqual");
        BINARY_OP_TO_BUILDER_METHOD.put(200, "plus");
        BINARY_OP_TO_BUILDER_METHOD.put(210, "plusEqual");
        BINARY_OP_TO_BUILDER_METHOD.put(201, "minus");
        BINARY_OP_TO_BUILDER_METHOD.put(211, "minusEqual");
        BINARY_OP_TO_BUILDER_METHOD.put(202, "multiply");
        BINARY_OP_TO_BUILDER_METHOD.put(212, "multiplyEqual");
        BINARY_OP_TO_BUILDER_METHOD.put(203, "div");
        BINARY_OP_TO_BUILDER_METHOD.put(213, "divEqual");
        BINARY_OP_TO_BUILDER_METHOD.put(204, "intdiv");
        BINARY_OP_TO_BUILDER_METHOD.put(214, "intdivEqual");
        BINARY_OP_TO_BUILDER_METHOD.put(205, "mod");
        BINARY_OP_TO_BUILDER_METHOD.put(215, "modEqual");
        BINARY_OP_TO_BUILDER_METHOD.put(206, "power");
        BINARY_OP_TO_BUILDER_METHOD.put(216, "powerEqual");
        BINARY_OP_TO_BUILDER_METHOD.put(100, "assign");
        BINARY_OP_TO_BUILDER_METHOD.put(544, "instanceOf");
        BINARY_OP_TO_BUILDER_METHOD.put(30, "array");
        BINARY_OP_TO_BUILDER_METHOD.put(280, "leftShift");
        BINARY_OP_TO_BUILDER_METHOD.put(285, "leftShiftEqual");
        BINARY_OP_TO_BUILDER_METHOD.put(281, "rightShift");
        BINARY_OP_TO_BUILDER_METHOD.put(286, "rightShiftEqual");
        BINARY_OP_TO_BUILDER_METHOD.put(282, "rightShiftUnsigned");
        BINARY_OP_TO_BUILDER_METHOD.put(287, "rightShiftUnsignedEqual");
        BINARY_OP_TO_BUILDER_METHOD.put(90, "findRegex");
        BINARY_OP_TO_BUILDER_METHOD.put(94, "matchRegex");
        BINARY_OP_TO_BUILDER_METHOD.put(573, "isCase");
        OBJECT_TYPE = ClassHelper.makeCached(Object.class);
        FUNCTION_TYPE = ClassHelper.makeCached(CpsFunction.class);
        CATCH_EXPRESSION_TYPE = ClassHelper.makeCached(CatchExpression.class);
        BUILDER_TYPE = ClassHelper.makeCached(Builder.class);
        CPSCALLINVK_TYPE = ClassHelper.makeCached(CpsCallableInvocation.class);
        WORKFLOW_TRANSFORMED_TYPE = ClassHelper.makeCached(WorkflowTransformed.class);
        BUIDER_TYPE = ClassHelper.makeCached(Builder.class);
        METHOD_LOCATION_TYPE = ClassHelper.makeCached(MethodLocation.class);
        SERIALIZABLE_TYPE = ClassHelper.makeCached(Serializable.class);
        BUILDER = new VariableExpression("b", BUILDER_TYPE);
        THIS = new VariableExpression("this");
        IT = new Parameter(ClassHelper.OBJECT_TYPE, "it", (Expression)ConstantExpression.NULL);
    }

    protected static interface ParentClosure {
        public void call(Expression var1);
    }
}

