/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.r2dbc;

import com.clickhouse.client.ClickHouseRequest;
import com.clickhouse.data.ClickHouseFormat;
import com.clickhouse.r2dbc.ClickHouseResult;
import io.r2dbc.spi.Batch;
import io.r2dbc.spi.Result;
import java.util.ArrayList;
import java.util.List;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ClickHouseBatch
implements Batch {
    private static final ClickHouseFormat PREFERRED_FORMAT = ClickHouseFormat.TabSeparatedWithNamesAndTypes;
    private ClickHouseRequest<?> request;
    final List<String> sqlList;

    public ClickHouseBatch(ClickHouseRequest<?> request) {
        this.request = request;
        this.sqlList = new ArrayList<String>();
    }

    public Batch add(String sql) {
        this.sqlList.add(sql);
        return this;
    }

    public Publisher<? extends Result> execute() {
        return Flux.fromStream(this.sqlList.stream().map(sql -> {
            this.request.query(sql).format(PREFERRED_FORMAT);
            return Mono.fromFuture(() -> this.request.execute());
        })).flatMap(Mono::flux).map(ClickHouseResult::new);
    }
}

