/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.internal.opencensus.implcore.stats;

import com.clickhouse.client.internal.google.common.base.Preconditions;
import com.clickhouse.client.internal.google.common.collect.Maps;
import com.clickhouse.client.internal.opencensus.common.Duration;
import com.clickhouse.client.internal.opencensus.common.Timestamp;
import com.clickhouse.client.internal.opencensus.implcore.stats.MutableAggregation;
import com.clickhouse.client.internal.opencensus.implcore.stats.RecordUtils;
import com.clickhouse.client.internal.opencensus.metrics.data.AttachmentValue;
import com.clickhouse.client.internal.opencensus.stats.Aggregation;
import com.clickhouse.client.internal.opencensus.stats.Measure;
import com.clickhouse.client.internal.opencensus.tags.TagValue;
import java.util.List;
import java.util.Map;

final class IntervalBucket {
    private static final Duration ZERO = Duration.create(0L, 0);
    private final Timestamp start;
    private final Duration duration;
    private final Aggregation aggregation;
    private final Measure measure;
    private final Map<List<TagValue>, MutableAggregation> tagValueAggregationMap = Maps.newHashMap();

    IntervalBucket(Timestamp start, Duration duration, Aggregation aggregation, Measure measure) {
        this.start = Preconditions.checkNotNull(start, "Start");
        this.duration = Preconditions.checkNotNull(duration, "Duration");
        Preconditions.checkArgument(duration.compareTo(ZERO) > 0, "Duration must be positive");
        this.aggregation = Preconditions.checkNotNull(aggregation, "Aggregation");
        this.measure = Preconditions.checkNotNull(measure, "measure");
    }

    Map<List<TagValue>, MutableAggregation> getTagValueAggregationMap() {
        return this.tagValueAggregationMap;
    }

    Timestamp getStart() {
        return this.start;
    }

    void record(List<TagValue> tagValues, double value, Map<String, AttachmentValue> attachments, Timestamp timestamp) {
        if (!this.tagValueAggregationMap.containsKey(tagValues)) {
            this.tagValueAggregationMap.put(tagValues, RecordUtils.createMutableAggregation(this.aggregation, this.measure));
        }
        this.tagValueAggregationMap.get(tagValues).add(value, attachments, timestamp);
    }

    double getFraction(Timestamp now) {
        Duration elapsedTime = now.subtractTimestamp(this.start);
        Preconditions.checkArgument(elapsedTime.compareTo(ZERO) >= 0 && elapsedTime.compareTo(this.duration) < 0, "This bucket must be current.");
        return (double)elapsedTime.toMillis() / (double)this.duration.toMillis();
    }

    void clearStats() {
        this.tagValueAggregationMap.clear();
    }
}

