/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.internal.opencensus.implcore.trace;

import com.clickhouse.client.internal.google.common.annotations.VisibleForTesting;
import com.clickhouse.client.internal.google.common.base.Preconditions;
import com.clickhouse.client.internal.google.common.collect.EvictingQueue;
import com.clickhouse.client.internal.opencensus.common.Clock;
import com.clickhouse.client.internal.opencensus.implcore.internal.TimestampConverter;
import com.clickhouse.client.internal.opencensus.implcore.trace.internal.ConcurrentIntrusiveList;
import com.clickhouse.client.internal.opencensus.trace.Annotation;
import com.clickhouse.client.internal.opencensus.trace.AttributeValue;
import com.clickhouse.client.internal.opencensus.trace.EndSpanOptions;
import com.clickhouse.client.internal.opencensus.trace.Link;
import com.clickhouse.client.internal.opencensus.trace.MessageEvent;
import com.clickhouse.client.internal.opencensus.trace.Span;
import com.clickhouse.client.internal.opencensus.trace.SpanContext;
import com.clickhouse.client.internal.opencensus.trace.SpanId;
import com.clickhouse.client.internal.opencensus.trace.Status;
import com.clickhouse.client.internal.opencensus.trace.Tracer;
import com.clickhouse.client.internal.opencensus.trace.config.TraceParams;
import com.clickhouse.client.internal.opencensus.trace.export.SpanData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class RecordEventsSpanImpl
extends Span
implements ConcurrentIntrusiveList.Element<RecordEventsSpanImpl> {
    private static final Logger logger = Logger.getLogger(Tracer.class.getName());
    private static final EnumSet<Span.Options> RECORD_EVENTS_SPAN_OPTIONS = EnumSet.of(Span.Options.RECORD_EVENTS);
    @Nullable
    private final SpanId parentSpanId;
    @Nullable
    private final Boolean hasRemoteParent;
    private final TraceParams traceParams;
    private final StartEndHandler startEndHandler;
    private final String name;
    @Nullable
    private final Span.Kind kind;
    private final Clock clock;
    private final TimestampConverter timestampConverter;
    private final long startNanoTime;
    @Nullable
    @GuardedBy(value="this")
    private AttributesWithCapacity attributes;
    @Nullable
    @GuardedBy(value="this")
    private TraceEvents<EventWithNanoTime<Annotation>> annotations;
    @Nullable
    @GuardedBy(value="this")
    private TraceEvents<EventWithNanoTime<MessageEvent>> messageEvents;
    @Nullable
    @GuardedBy(value="this")
    private TraceEvents<Link> links;
    @GuardedBy(value="this")
    private int numberOfChildren;
    @Nullable
    @GuardedBy(value="this")
    private Status status;
    @GuardedBy(value="this")
    private long endNanoTime;
    @GuardedBy(value="this")
    private boolean hasBeenEnded;
    @GuardedBy(value="this")
    private boolean sampleToLocalSpanStore;
    @Nullable
    private RecordEventsSpanImpl next = null;
    @Nullable
    private RecordEventsSpanImpl prev = null;

    @VisibleForTesting
    public static RecordEventsSpanImpl startSpan(SpanContext context, String name, @Nullable Span.Kind kind, @Nullable SpanId parentSpanId, @Nullable Boolean hasRemoteParent, TraceParams traceParams, StartEndHandler startEndHandler, @Nullable TimestampConverter timestampConverter, Clock clock) {
        RecordEventsSpanImpl span = new RecordEventsSpanImpl(context, name, kind, parentSpanId, hasRemoteParent, traceParams, startEndHandler, timestampConverter, clock);
        startEndHandler.onStart(span);
        return span;
    }

    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Status getStatus() {
        RecordEventsSpanImpl recordEventsSpanImpl = this;
        synchronized (recordEventsSpanImpl) {
            return this.getStatusWithDefault();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getEndNanoTime() {
        RecordEventsSpanImpl recordEventsSpanImpl = this;
        synchronized (recordEventsSpanImpl) {
            return this.hasBeenEnded ? this.endNanoTime : this.clock.nowNanos();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLatencyNs() {
        RecordEventsSpanImpl recordEventsSpanImpl = this;
        synchronized (recordEventsSpanImpl) {
            return this.hasBeenEnded ? this.endNanoTime - this.startNanoTime : this.clock.nowNanos() - this.startNanoTime;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getSampleToLocalSpanStore() {
        RecordEventsSpanImpl recordEventsSpanImpl = this;
        synchronized (recordEventsSpanImpl) {
            Preconditions.checkState(this.hasBeenEnded, "Running span does not have the SampleToLocalSpanStore set.");
            return this.sampleToLocalSpanStore;
        }
    }

    @Nullable
    public Span.Kind getKind() {
        return this.kind;
    }

    @Nullable
    TimestampConverter getTimestampConverter() {
        return this.timestampConverter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SpanData toSpanData() {
        RecordEventsSpanImpl recordEventsSpanImpl = this;
        synchronized (recordEventsSpanImpl) {
            SpanData.Attributes attributesSpanData = this.attributes == null ? SpanData.Attributes.create(Collections.emptyMap(), 0) : SpanData.Attributes.create(this.attributes, this.attributes.getNumberOfDroppedAttributes());
            SpanData.TimedEvents<Annotation> annotationsSpanData = RecordEventsSpanImpl.createTimedEvents(this.getInitializedAnnotations(), this.timestampConverter);
            SpanData.TimedEvents messageEventsSpanData = RecordEventsSpanImpl.createTimedEvents(this.getInitializedNetworkEvents(), this.timestampConverter);
            SpanData.Links linksSpanData = this.links == null ? SpanData.Links.create(Collections.emptyList(), 0) : SpanData.Links.create(new ArrayList<Link>(((TraceEvents)this.links).events), ((TraceEvents)this.links).getNumberOfDroppedEvents());
            return SpanData.create(this.getContext(), this.parentSpanId, this.hasRemoteParent, this.name, this.kind, this.timestampConverter.convertNanoTime(this.startNanoTime), attributesSpanData, annotationsSpanData, messageEventsSpanData, linksSpanData, this.numberOfChildren, this.hasBeenEnded ? this.getStatusWithDefault() : null, this.hasBeenEnded ? this.timestampConverter.convertNanoTime(this.endNanoTime) : null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putAttribute(String key, AttributeValue value) {
        Preconditions.checkNotNull(key, "key");
        Preconditions.checkNotNull(value, "value");
        RecordEventsSpanImpl recordEventsSpanImpl = this;
        synchronized (recordEventsSpanImpl) {
            if (this.hasBeenEnded) {
                logger.log(Level.FINE, "Calling putAttributes() on an ended Span.");
                return;
            }
            this.getInitializedAttributes().putAttribute(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putAttributes(Map<String, AttributeValue> attributes) {
        Preconditions.checkNotNull(attributes, "attributes");
        RecordEventsSpanImpl recordEventsSpanImpl = this;
        synchronized (recordEventsSpanImpl) {
            if (this.hasBeenEnded) {
                logger.log(Level.FINE, "Calling putAttributes() on an ended Span.");
                return;
            }
            this.getInitializedAttributes().putAttributes(attributes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addAnnotation(String description, Map<String, AttributeValue> attributes) {
        Preconditions.checkNotNull(description, "description");
        Preconditions.checkNotNull(attributes, "attribute");
        RecordEventsSpanImpl recordEventsSpanImpl = this;
        synchronized (recordEventsSpanImpl) {
            if (this.hasBeenEnded) {
                logger.log(Level.FINE, "Calling addAnnotation() on an ended Span.");
                return;
            }
            this.getInitializedAnnotations().addEvent(new EventWithNanoTime(this.clock.nowNanos(), Annotation.fromDescriptionAndAttributes(description, attributes)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addAnnotation(Annotation annotation) {
        Preconditions.checkNotNull(annotation, "annotation");
        RecordEventsSpanImpl recordEventsSpanImpl = this;
        synchronized (recordEventsSpanImpl) {
            if (this.hasBeenEnded) {
                logger.log(Level.FINE, "Calling addAnnotation() on an ended Span.");
                return;
            }
            this.getInitializedAnnotations().addEvent(new EventWithNanoTime(this.clock.nowNanos(), annotation));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addMessageEvent(MessageEvent messageEvent) {
        Preconditions.checkNotNull(messageEvent, "messageEvent");
        RecordEventsSpanImpl recordEventsSpanImpl = this;
        synchronized (recordEventsSpanImpl) {
            if (this.hasBeenEnded) {
                logger.log(Level.FINE, "Calling addNetworkEvent() on an ended Span.");
                return;
            }
            this.getInitializedNetworkEvents().addEvent(new EventWithNanoTime(this.clock.nowNanos(), Preconditions.checkNotNull(messageEvent, "networkEvent")));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addLink(Link link) {
        Preconditions.checkNotNull(link, "link");
        RecordEventsSpanImpl recordEventsSpanImpl = this;
        synchronized (recordEventsSpanImpl) {
            if (this.hasBeenEnded) {
                logger.log(Level.FINE, "Calling addLink() on an ended Span.");
                return;
            }
            this.getInitializedLinks().addEvent(link);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setStatus(Status status) {
        Preconditions.checkNotNull(status, "status");
        RecordEventsSpanImpl recordEventsSpanImpl = this;
        synchronized (recordEventsSpanImpl) {
            if (this.hasBeenEnded) {
                logger.log(Level.FINE, "Calling setStatus() on an ended Span.");
                return;
            }
            this.status = status;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void end(EndSpanOptions options) {
        Preconditions.checkNotNull(options, "options");
        RecordEventsSpanImpl recordEventsSpanImpl = this;
        synchronized (recordEventsSpanImpl) {
            if (this.hasBeenEnded) {
                logger.log(Level.FINE, "Calling end() on an ended Span.");
                return;
            }
            if (options.getStatus() != null) {
                this.status = options.getStatus();
            }
            this.sampleToLocalSpanStore = options.getSampleToLocalSpanStore();
            this.endNanoTime = this.clock.nowNanos();
            this.hasBeenEnded = true;
        }
        this.startEndHandler.onEnd(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addChild() {
        RecordEventsSpanImpl recordEventsSpanImpl = this;
        synchronized (recordEventsSpanImpl) {
            if (this.hasBeenEnded) {
                logger.log(Level.FINE, "Calling end() on an ended Span.");
                return;
            }
            ++this.numberOfChildren;
        }
    }

    @GuardedBy(value="this")
    private AttributesWithCapacity getInitializedAttributes() {
        if (this.attributes == null) {
            this.attributes = new AttributesWithCapacity(this.traceParams.getMaxNumberOfAttributes());
        }
        return this.attributes;
    }

    @GuardedBy(value="this")
    private TraceEvents<EventWithNanoTime<Annotation>> getInitializedAnnotations() {
        if (this.annotations == null) {
            this.annotations = new TraceEvents(this.traceParams.getMaxNumberOfAnnotations());
        }
        return this.annotations;
    }

    @GuardedBy(value="this")
    private TraceEvents<EventWithNanoTime<MessageEvent>> getInitializedNetworkEvents() {
        if (this.messageEvents == null) {
            this.messageEvents = new TraceEvents(this.traceParams.getMaxNumberOfMessageEvents());
        }
        return this.messageEvents;
    }

    @GuardedBy(value="this")
    private TraceEvents<Link> getInitializedLinks() {
        if (this.links == null) {
            this.links = new TraceEvents(this.traceParams.getMaxNumberOfLinks());
        }
        return this.links;
    }

    @GuardedBy(value="this")
    private Status getStatusWithDefault() {
        return this.status == null ? Status.OK : this.status;
    }

    private static <T> SpanData.TimedEvents<T> createTimedEvents(TraceEvents<EventWithNanoTime<T>> events, TimestampConverter timestampConverter) {
        if (events == null) {
            return SpanData.TimedEvents.create(Collections.emptyList(), 0);
        }
        ArrayList eventsList = new ArrayList(((TraceEvents)events).events.size());
        for (EventWithNanoTime networkEvent : ((TraceEvents)events).events) {
            eventsList.add(networkEvent.toSpanDataTimedEvent(timestampConverter));
        }
        return SpanData.TimedEvents.create(eventsList, ((TraceEvents)events).getNumberOfDroppedEvents());
    }

    @Override
    @Nullable
    public RecordEventsSpanImpl getNext() {
        return this.next;
    }

    @Override
    public void setNext(@Nullable RecordEventsSpanImpl element) {
        this.next = element;
    }

    @Override
    @Nullable
    public RecordEventsSpanImpl getPrev() {
        return this.prev;
    }

    @Override
    public void setPrev(@Nullable RecordEventsSpanImpl element) {
        this.prev = element;
    }

    private RecordEventsSpanImpl(SpanContext context, String name, @Nullable Span.Kind kind, @Nullable SpanId parentSpanId, @Nullable Boolean hasRemoteParent, TraceParams traceParams, StartEndHandler startEndHandler, @Nullable TimestampConverter timestampConverter, Clock clock) {
        super(context, RECORD_EVENTS_SPAN_OPTIONS);
        this.parentSpanId = parentSpanId;
        this.hasRemoteParent = hasRemoteParent;
        this.name = name;
        this.kind = kind;
        this.traceParams = traceParams;
        this.startEndHandler = startEndHandler;
        this.clock = clock;
        this.hasBeenEnded = false;
        this.sampleToLocalSpanStore = false;
        this.numberOfChildren = 0;
        this.timestampConverter = timestampConverter != null ? timestampConverter : TimestampConverter.now(clock);
        this.startNanoTime = clock.nowNanos();
    }

    private static final class EventWithNanoTime<T> {
        private final long nanoTime;
        private final T event;

        private EventWithNanoTime(long nanoTime, T event) {
            this.nanoTime = nanoTime;
            this.event = event;
        }

        private SpanData.TimedEvent<T> toSpanDataTimedEvent(TimestampConverter timestampConverter) {
            return SpanData.TimedEvent.create(timestampConverter.convertNanoTime(this.nanoTime), this.event);
        }
    }

    private static final class TraceEvents<T> {
        private int totalRecordedEvents = 0;
        private final EvictingQueue<T> events;

        private int getNumberOfDroppedEvents() {
            return this.totalRecordedEvents - this.events.size();
        }

        TraceEvents(int maxNumEvents) {
            this.events = EvictingQueue.create(maxNumEvents);
        }

        void addEvent(T event) {
            ++this.totalRecordedEvents;
            this.events.add(event);
        }
    }

    private static final class AttributesWithCapacity
    extends LinkedHashMap<String, AttributeValue> {
        private final int capacity;
        private int totalRecordedAttributes = 0;
        private static final long serialVersionUID = 42L;

        private AttributesWithCapacity(int capacity) {
            super(capacity + 1, 1.0f, true);
            this.capacity = capacity;
        }

        private void putAttribute(String key, AttributeValue value) {
            ++this.totalRecordedAttributes;
            this.put(key, value);
        }

        private void putAttributes(Map<String, AttributeValue> attributes) {
            this.totalRecordedAttributes += attributes.size();
            this.putAll(attributes);
        }

        private int getNumberOfDroppedAttributes() {
            return this.totalRecordedAttributes - this.size();
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, AttributeValue> eldest) {
            return this.size() > this.capacity;
        }
    }

    public static interface StartEndHandler {
        public void onStart(RecordEventsSpanImpl var1);

        public void onEnd(RecordEventsSpanImpl var1);
    }
}

