/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.grpc;

import com.clickhouse.client.ClickHouseChecker;
import com.clickhouse.client.ClickHouseConfig;
import com.clickhouse.client.ClickHouseNode;
import com.clickhouse.client.ClickHouseUtils;
import com.clickhouse.client.config.ClickHouseOption;
import com.clickhouse.client.config.ClickHouseSslMode;
import com.clickhouse.client.grpc.ClickHouseGrpcChannelFactory;
import com.clickhouse.client.grpc.config.ClickHouseGrpcOption;
import io.grpc.ManagedChannelBuilder;
import io.grpc.netty.shaded.io.grpc.netty.NettyChannelBuilder;
import io.grpc.netty.shaded.io.netty.channel.ChannelOption;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2SecurityUtil;
import io.grpc.netty.shaded.io.netty.handler.ssl.CipherSuiteFilter;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslContext;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslContextBuilder;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslProvider;
import io.grpc.netty.shaded.io.netty.handler.ssl.SupportedCipherSuiteFilter;
import io.grpc.netty.shaded.io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import java.io.FileNotFoundException;
import javax.net.ssl.SSLException;

final class NettyChannelFactoryImpl
extends ClickHouseGrpcChannelFactory {
    private final NettyChannelBuilder builder;

    NettyChannelFactoryImpl(ClickHouseConfig config, ClickHouseNode server) {
        super(config, server);
        this.builder = NettyChannelBuilder.forAddress((String)server.getHost(), (int)server.getPort());
        int flowControlWindow = (Integer)config.getOption((ClickHouseOption)ClickHouseGrpcOption.FLOW_CONTROL_WINDOW);
        if (flowControlWindow > 0) {
            this.builder.flowControlWindow(flowControlWindow);
        }
    }

    protected SslContext getSslContext() throws SSLException {
        SslContextBuilder builder = SslContextBuilder.forClient();
        ClickHouseSslMode sslMode = this.config.getSslMode();
        if (sslMode == ClickHouseSslMode.NONE) {
            builder.trustManager(InsecureTrustManagerFactory.INSTANCE);
        } else if (sslMode == ClickHouseSslMode.STRICT) {
            String sslRootCert = this.config.getSslRootCert();
            if (!ClickHouseChecker.isNullOrEmpty((CharSequence)sslRootCert)) {
                try {
                    builder.trustManager(ClickHouseUtils.getFileInputStream((String)sslRootCert));
                }
                catch (FileNotFoundException e) {
                    throw new SSLException("Failed to setup trust manager using given root certificate", e);
                }
            }
            String sslCert = this.config.getSslCert();
            String sslKey = this.config.getSslKey();
            if (!ClickHouseChecker.isNullOrEmpty((CharSequence)sslCert) && !ClickHouseChecker.isNullOrEmpty((CharSequence)sslKey)) {
                try {
                    builder.keyManager(ClickHouseUtils.getFileInputStream((String)sslCert), ClickHouseUtils.getFileInputStream((String)sslKey));
                }
                catch (FileNotFoundException e) {
                    throw new SSLException("Failed to setup key manager using given certificate and key", e);
                }
            }
        }
        builder.sslProvider(SslProvider.JDK).ciphers((Iterable)Http2SecurityUtil.CIPHERS, (CipherSuiteFilter)SupportedCipherSuiteFilter.INSTANCE);
        return builder.build();
    }

    @Override
    protected ManagedChannelBuilder<?> getChannelBuilder() {
        return this.builder;
    }

    @Override
    protected void setupSsl() {
        if (!this.config.isSsl()) {
            this.builder.usePlaintext();
        } else {
            SslContext sslContext;
            try {
                sslContext = this.getSslContext();
            }
            catch (SSLException e) {
                throw new IllegalStateException("Failed to build ssl context", e);
            }
            this.builder.useTransportSecurity().sslContext(sslContext);
        }
    }

    @Override
    protected void setupTimeout() {
        this.builder.withOption(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)this.config.getConnectionTimeout());
    }
}

