/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.grpc;

import com.clickhouse.client.AbstractClient;
import com.clickhouse.client.ClickHouseChecker;
import com.clickhouse.client.ClickHouseColumn;
import com.clickhouse.client.ClickHouseCompression;
import com.clickhouse.client.ClickHouseConfig;
import com.clickhouse.client.ClickHouseCredentials;
import com.clickhouse.client.ClickHouseException;
import com.clickhouse.client.ClickHouseNode;
import com.clickhouse.client.ClickHouseProtocol;
import com.clickhouse.client.ClickHouseRequest;
import com.clickhouse.client.ClickHouseResponse;
import com.clickhouse.client.ClickHouseUtils;
import com.clickhouse.client.config.ClickHouseOption;
import com.clickhouse.client.data.ClickHouseExternalTable;
import com.clickhouse.client.grpc.ClickHouseGrpcChannelFactory;
import com.clickhouse.client.grpc.ClickHouseGrpcResponse;
import com.clickhouse.client.grpc.ClickHouseStreamObserver;
import com.clickhouse.client.grpc.config.ClickHouseGrpcOption;
import com.clickhouse.client.grpc.impl.ClickHouseGrpc;
import com.clickhouse.client.grpc.impl.ExternalTable;
import com.clickhouse.client.grpc.impl.NameAndType;
import com.clickhouse.client.grpc.impl.QueryInfo;
import com.clickhouse.client.grpc.impl.Result;
import com.clickhouse.client.logging.Logger;
import com.clickhouse.client.logging.LoggerFactory;
import com.google.protobuf.ByteString;
import io.grpc.Channel;
import io.grpc.Context;
import io.grpc.ManagedChannel;
import io.grpc.Status;
import io.grpc.StatusException;
import io.grpc.stub.StreamObserver;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketTimeoutException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletionException;
import java.util.concurrent.TimeUnit;

public class ClickHouseGrpcClient
extends AbstractClient<ManagedChannel> {
    private static final Logger log = LoggerFactory.getLogger(ClickHouseGrpcClient.class);
    static final List<ClickHouseProtocol> SUPPORTED = Collections.singletonList(ClickHouseProtocol.GRPC);

    protected static QueryInfo convert(ClickHouseRequest<?> request) {
        String sql;
        List stmts;
        int size;
        List externalTables;
        ClickHouseConfig config = request.getConfig();
        ClickHouseNode server = request.getServer();
        ClickHouseCredentials credentials = server.getCredentials(config);
        QueryInfo.Builder builder = QueryInfo.newBuilder();
        String database = server.getDatabase(config);
        if (!ClickHouseChecker.isNullOrEmpty((CharSequence)database)) {
            builder.setDatabase(server.getDatabase(config));
        }
        builder.setUserName(credentials.getUserName()).setPassword(credentials.getPassword()).setOutputFormat(request.getFormat().name());
        Optional optionalValue = request.getSessionId();
        if (optionalValue.isPresent()) {
            builder.setSessionId((String)optionalValue.get());
        }
        if (config.isSessionCheck()) {
            builder.setSessionCheck(true);
        }
        if (config.getSessionTimeout() > 0) {
            builder.setSessionTimeout(config.getSessionTimeout());
        }
        if ((optionalValue = request.getQueryId()).isPresent()) {
            builder.setQueryId((String)optionalValue.get());
        }
        ClickHouseCompression outputCompression = config.getResponseCompressAlgorithm();
        builder.setOutputCompressionType(outputCompression.encoding());
        for (Map.Entry s : request.getSettings().entrySet()) {
            builder.putSettings((String)s.getKey(), String.valueOf(s.getValue()));
        }
        ClickHouseCompression inputCompression = config.getRequestCompressAlgorithm();
        Optional input = request.getInputStream();
        if (input.isPresent()) {
            builder.setInputCompressionType(inputCompression.encoding());
            try {
                builder.setInputData(ByteString.readFrom((InputStream)((InputStream)input.get())));
            }
            catch (IOException e) {
                throw new CompletionException((Throwable)ClickHouseException.of((Throwable)e, (ClickHouseNode)server));
            }
        }
        if (!(externalTables = request.getExternalTables()).isEmpty()) {
            for (ClickHouseExternalTable external : externalTables) {
                ExternalTable.Builder b = ExternalTable.newBuilder().setName(external.getName());
                for (ClickHouseColumn c : ClickHouseColumn.parse((String)external.getStructure())) {
                    b.addColumns(NameAndType.newBuilder().setName(c.getColumnName()).setType(c.getOriginalTypeName()).build());
                }
                b.setCompressionType(inputCompression.encoding());
                if (external.getFormat() != null) {
                    b.setFormat(external.getFormat().name());
                }
                try {
                    builder.addExternalTables(b.setData(ByteString.readFrom((InputStream)external.getContent())).build());
                }
                catch (IOException e) {
                    throw new CompletionException((Throwable)ClickHouseException.of((Throwable)e, (ClickHouseNode)server));
                }
            }
        }
        if ((size = (stmts = request.getStatements(false)).size()) == 0) {
            throw new IllegalArgumentException("At least one SQL statement is required for execution");
        }
        if (size == 1) {
            sql = (String)stmts.get(0);
        } else {
            if (!builder.getSessionCheck()) {
                builder.setSessionCheck(true);
            }
            if (ClickHouseChecker.isNullOrEmpty((CharSequence)builder.getSessionId())) {
                builder.setSessionId(UUID.randomUUID().toString());
            }
            StringBuilder sb = new StringBuilder();
            for (String s : stmts) {
                sb.append(s).append(';').append('\n');
            }
            sql = sb.toString();
        }
        log.debug((Object)"Query: %s", new Object[]{sql});
        return builder.setQuery(sql).build();
    }

    protected boolean checkHealth(ClickHouseNode server, int timeout) {
        return true;
    }

    protected void closeConnection(ManagedChannel connection, boolean force) {
        if (!force) {
            connection.shutdown();
        } else {
            connection.shutdownNow();
        }
    }

    protected Collection<ClickHouseProtocol> getSupportedProtocols() {
        return SUPPORTED;
    }

    protected ManagedChannel newConnection(ManagedChannel connection, ClickHouseNode server, ClickHouseRequest<?> request) {
        if (connection != null) {
            this.closeConnection(connection, false);
        }
        return ClickHouseGrpcChannelFactory.getFactory(request.getConfig(), server).create();
    }

    protected void fill(ClickHouseRequest<?> request, StreamObserver<QueryInfo> observer) {
        try {
            observer.onNext((Object)ClickHouseGrpcClient.convert(request));
        }
        finally {
            observer.onCompleted();
        }
    }

    protected Object[] getAsyncExecArguments(ClickHouseRequest<?> sealedRequest) {
        ClickHouseGrpc.ClickHouseStub stub = ClickHouseGrpc.newStub((Channel)this.getConnection(sealedRequest));
        ClickHouseStreamObserver responseObserver = new ClickHouseStreamObserver(sealedRequest.getConfig(), sealedRequest.getServer(), sealedRequest.getOutputStream().orElse(null));
        StreamObserver<QueryInfo> requestObserver = stub.executeQueryWithStreamIO(responseObserver);
        if (sealedRequest.hasInputStream()) {
            this.getExecutor().execute(() -> this.fill(sealedRequest, requestObserver));
        } else {
            this.fill(sealedRequest, requestObserver);
        }
        return new Object[]{requestObserver, responseObserver};
    }

    protected ClickHouseResponse sendAsync(ClickHouseRequest<?> sealedRequest, Object ... args) throws ClickHouseException, IOException {
        StreamObserver requestObserver = (StreamObserver)args[0];
        ClickHouseStreamObserver responseObserver = (ClickHouseStreamObserver)args[1];
        ClickHouseConfig config = sealedRequest.getConfig();
        int timeout = config.getConnectionTimeout() / 1000 + Math.max(config.getSocketTimeout() / 1000, config.getMaxExecutionTime());
        try {
            if (!responseObserver.await(timeout, TimeUnit.SECONDS)) {
                if (!Context.current().withCancellation().cancel((Throwable)new StatusException(Status.CANCELLED))) {
                    requestObserver.onError((Throwable)new StatusException(Status.CANCELLED));
                }
                throw new SocketTimeoutException(ClickHouseUtils.format((String)"Timed out after waiting for %d %s", (Object[])new Object[]{timeout, TimeUnit.SECONDS}));
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw ClickHouseException.of((Throwable)e, (ClickHouseNode)sealedRequest.getServer());
        }
        ClickHouseGrpcResponse response = new ClickHouseGrpcResponse(sealedRequest.getConfig(), (Map<String, Object>)sealedRequest.getSettings(), responseObserver);
        IOException cause = responseObserver.getError();
        if (cause != null) {
            throw ClickHouseException.of((Throwable)cause, (ClickHouseNode)sealedRequest.getServer());
        }
        return response;
    }

    protected ClickHouseResponse send(ClickHouseRequest<?> sealedRequest) throws ClickHouseException, IOException {
        ManagedChannel channel = (ManagedChannel)this.getConnection(sealedRequest);
        ClickHouseGrpc.ClickHouseBlockingStub stub = ClickHouseGrpc.newBlockingStub((Channel)channel);
        Result result = stub.executeQuery(ClickHouseGrpcClient.convert(sealedRequest));
        ClickHouseGrpcResponse response = new ClickHouseGrpcResponse(sealedRequest.getConfig(), (Map<String, Object>)sealedRequest.getSettings(), result);
        if (result.hasException()) {
            throw new ClickHouseException(result.getException().getCode(), result.getException().getDisplayText(), sealedRequest.getServer());
        }
        return response;
    }

    public boolean accept(ClickHouseProtocol protocol) {
        return ClickHouseProtocol.GRPC == protocol || super.accept(protocol);
    }

    public Class<? extends ClickHouseOption> getOptionClass() {
        return ClickHouseGrpcOption.class;
    }
}

