/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.data;

import com.clickhouse.client.ClickHouseDataType;
import com.clickhouse.client.data.BinaryStreamUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Objects;
import org.roaringbitmap.RoaringBitmap;
import org.roaringbitmap.buffer.ImmutableRoaringBitmap;
import org.roaringbitmap.buffer.MutableRoaringBitmap;
import org.roaringbitmap.longlong.Roaring64Bitmap;
import org.roaringbitmap.longlong.Roaring64NavigableMap;

public abstract class ClickHouseBitmap {
    private static final int[] EMPTY_INT_ARRAY = new int[0];
    private static final long[] EMPTY_LONG_ARRAY = new long[0];
    private static final ClickHouseBitmap EMPTY_INT8_BITMAP = ClickHouseBitmap.wrap(ImmutableRoaringBitmap.bitmapOf((int[])EMPTY_INT_ARRAY), ClickHouseDataType.Int8);
    private static final ClickHouseBitmap EMPTY_UINT8_BITMAP = ClickHouseBitmap.wrap(ImmutableRoaringBitmap.bitmapOf((int[])EMPTY_INT_ARRAY), ClickHouseDataType.UInt8);
    private static final ClickHouseBitmap EMPTY_INT16_BITMAP = ClickHouseBitmap.wrap(ImmutableRoaringBitmap.bitmapOf((int[])EMPTY_INT_ARRAY), ClickHouseDataType.Int16);
    private static final ClickHouseBitmap EMPTY_UINT16_BITMAP = ClickHouseBitmap.wrap(ImmutableRoaringBitmap.bitmapOf((int[])EMPTY_INT_ARRAY), ClickHouseDataType.UInt16);
    private static final ClickHouseBitmap EMPTY_INT32_BITMAP = ClickHouseBitmap.wrap(ImmutableRoaringBitmap.bitmapOf((int[])EMPTY_INT_ARRAY), ClickHouseDataType.Int32);
    private static final ClickHouseBitmap EMPTY_UINT32_BITMAP = ClickHouseBitmap.wrap(ImmutableRoaringBitmap.bitmapOf((int[])EMPTY_INT_ARRAY), ClickHouseDataType.UInt32);
    protected final ClickHouseDataType innerType;
    protected final int byteLen;
    protected final Object reference;

    public static ClickHouseBitmap empty() {
        return ClickHouseBitmap.empty(null);
    }

    public static ClickHouseBitmap empty(ClickHouseDataType type) {
        ClickHouseBitmap v;
        if (type == null) {
            type = ClickHouseDataType.UInt32;
        }
        switch (type) {
            case Int8: {
                v = EMPTY_INT8_BITMAP;
                break;
            }
            case UInt8: {
                v = EMPTY_UINT8_BITMAP;
                break;
            }
            case Int16: {
                v = EMPTY_INT16_BITMAP;
                break;
            }
            case UInt16: {
                v = EMPTY_UINT16_BITMAP;
                break;
            }
            case Int32: {
                v = EMPTY_INT32_BITMAP;
                break;
            }
            case UInt32: {
                v = EMPTY_UINT32_BITMAP;
                break;
            }
            case Int64: 
            case UInt64: {
                v = ClickHouseBitmap.wrap(Roaring64NavigableMap.bitmapOf((long[])EMPTY_LONG_ARRAY), type);
                break;
            }
            default: {
                throw new IllegalArgumentException("Only native integer types are supported but we got: " + type.name());
            }
        }
        return v;
    }

    public static ClickHouseBitmap wrap(byte ... values) {
        boolean isUnsigned = true;
        int len = values.length;
        int[] ints = new int[len];
        for (int i = 0; i < len; ++i) {
            int v;
            ints[i] = v = values[i];
            if (!isUnsigned || v >= 0) continue;
            isUnsigned = false;
        }
        return ClickHouseBitmap.wrap(RoaringBitmap.bitmapOf((int[])ints), isUnsigned ? ClickHouseDataType.UInt8 : ClickHouseDataType.Int8);
    }

    public static ClickHouseBitmap wrap(short ... values) {
        boolean isUnsigned = true;
        int len = values.length;
        int[] ints = new int[len];
        for (int i = 0; i < len; ++i) {
            int v;
            ints[i] = v = values[i];
            if (!isUnsigned || v >= 0) continue;
            isUnsigned = false;
        }
        return ClickHouseBitmap.wrap(RoaringBitmap.bitmapOf((int[])ints), isUnsigned ? ClickHouseDataType.UInt16 : ClickHouseDataType.Int16);
    }

    public static ClickHouseBitmap wrap(int ... values) {
        boolean isUnsigned = true;
        int len = values.length;
        int[] ints = new int[len];
        for (int i = 0; i < len; ++i) {
            int v;
            ints[i] = v = values[i];
            if (!isUnsigned || v >= 0) continue;
            isUnsigned = false;
        }
        return ClickHouseBitmap.wrap(RoaringBitmap.bitmapOf((int[])ints), isUnsigned ? ClickHouseDataType.UInt32 : ClickHouseDataType.Int32);
    }

    public static ClickHouseBitmap wrap(long ... values) {
        boolean isUnsigned = true;
        int len = values.length;
        long[] longs = new long[len];
        for (int i = 0; i < len; ++i) {
            long v;
            longs[i] = v = values[i];
            if (!isUnsigned || v >= 0L) continue;
            isUnsigned = false;
        }
        return ClickHouseBitmap.wrap(Roaring64NavigableMap.bitmapOf((long[])longs), isUnsigned ? ClickHouseDataType.UInt64 : ClickHouseDataType.Int64);
    }

    public static ClickHouseBitmap wrap(Object bitmap, ClickHouseDataType innerType) {
        ClickHouseBitmap b;
        if (bitmap instanceof RoaringBitmap) {
            b = new ClickHouseRoaringBitmap((RoaringBitmap)bitmap, innerType);
        } else if (bitmap instanceof MutableRoaringBitmap) {
            b = new ClickHouseMutableRoaringBitmap((MutableRoaringBitmap)bitmap, innerType);
        } else if (bitmap instanceof ImmutableRoaringBitmap) {
            b = new ClickHouseImmutableRoaringBitmap((ImmutableRoaringBitmap)bitmap, innerType);
        } else if (bitmap instanceof Roaring64Bitmap) {
            b = new ClickHouseRoaring64NavigableMap(Roaring64NavigableMap.bitmapOf((long[])((Roaring64Bitmap)bitmap).toArray()), innerType);
        } else if (bitmap instanceof Roaring64NavigableMap) {
            b = new ClickHouseRoaring64NavigableMap((Roaring64NavigableMap)bitmap, innerType);
        } else {
            throw new IllegalArgumentException("Only RoaringBitmap is supported but got: " + bitmap);
        }
        return b;
    }

    public static ClickHouseBitmap deserialize(InputStream in, ClickHouseDataType innerType) throws IOException {
        return ClickHouseBitmap.deserialize(in instanceof DataInputStream ? (DataInputStream)in : new DataInputStream(in), innerType);
    }

    public static ClickHouseBitmap deserialize(DataInputStream in, ClickHouseDataType innerType) throws IOException {
        ClickHouseBitmap rb;
        int byteLen = ClickHouseBitmap.byteLength(innerType);
        int flag = in.readUnsignedByte();
        if (flag == 0) {
            byte cardinality = (byte)in.readUnsignedByte();
            byte[] bytes = new byte[2 + byteLen * cardinality];
            bytes[0] = (byte)flag;
            bytes[1] = cardinality;
            in.read(bytes, 2, bytes.length - 2);
            rb = ClickHouseBitmap.deserialize(bytes, innerType);
        } else {
            int len = BinaryStreamUtils.readVarInt(in);
            byte[] bytes = new byte[len];
            if (byteLen <= 4) {
                in.readFully(bytes);
                RoaringBitmap b = new RoaringBitmap();
                b.deserialize(ClickHouseBitmap.flip(ClickHouseBitmap.newBuffer(len).put(bytes)));
                rb = ClickHouseBitmap.wrap(b, innerType);
            } else {
                bytes[0] = 0;
                for (int i = 4; i > 0; --i) {
                    bytes[i] = in.readByte();
                }
                if (in.readByte() != 0 || in.readByte() != 0 || in.readByte() != 0 || in.readByte() != 0) {
                    throw new IllegalStateException("Not able to deserialize ClickHouseBitmap for too many bitmaps(>4294967295)!");
                }
                in.readFully(bytes, 5, len - 8);
                Roaring64NavigableMap b = new Roaring64NavigableMap();
                b.deserialize((DataInput)new DataInputStream(new ByteArrayInputStream(bytes)));
                rb = ClickHouseBitmap.wrap(b, innerType);
            }
        }
        return rb;
    }

    public static ClickHouseBitmap deserialize(byte[] bytes, ClickHouseDataType innerType) throws IOException {
        ClickHouseBitmap rb = ClickHouseBitmap.wrap(new byte[0]);
        if (bytes == null || bytes.length == 0) {
            return rb;
        }
        int byteLen = ClickHouseBitmap.byteLength(innerType);
        ByteBuffer buffer = ClickHouseBitmap.newBuffer(bytes.length);
        if ((buffer = (ByteBuffer)((Buffer)buffer.put(bytes)).flip()).get() == 0) {
            int cardinality = buffer.get();
            if (byteLen == 1) {
                byte[] values = new byte[cardinality];
                for (int i = 0; i < cardinality; ++i) {
                    values[i] = buffer.get();
                }
                rb = ClickHouseBitmap.wrap(values);
            } else if (byteLen == 2) {
                short[] values = new short[cardinality];
                for (int i = 0; i < cardinality; ++i) {
                    values[i] = buffer.getShort();
                }
                rb = ClickHouseBitmap.wrap(values);
            } else if (byteLen == 4) {
                int[] values = new int[cardinality];
                for (int i = 0; i < cardinality; ++i) {
                    values[i] = buffer.getInt();
                }
                rb = ClickHouseBitmap.wrap(values);
            } else {
                long[] values = new long[cardinality];
                for (int i = 0; i < cardinality; ++i) {
                    values[i] = buffer.getLong();
                }
                rb = ClickHouseBitmap.wrap(values);
            }
        } else {
            int len = BinaryStreamUtils.readVarInt(buffer);
            if (buffer.remaining() < len) {
                throw new IllegalStateException("Need " + len + " bytes to deserialize ClickHouseBitmap but only got " + buffer.remaining());
            }
            if (byteLen <= 4) {
                RoaringBitmap b = new RoaringBitmap();
                b.deserialize(buffer);
                rb = ClickHouseBitmap.wrap(b, innerType);
            } else {
                byte[] bitmaps = new byte[4];
                buffer.get(bitmaps);
                if (buffer.get() != 0 || buffer.get() != 0 || buffer.get() != 0 || buffer.get() != 0) {
                    throw new IllegalStateException("Not able to deserialize ClickHouseBitmap for too many bitmaps(>4294967295)!");
                }
                ((Buffer)buffer).position(buffer.position() - 5);
                buffer.put((byte)0);
                for (int i = 3; i >= 0; --i) {
                    buffer.put(bitmaps[i]);
                }
                ((Buffer)buffer).position(buffer.position() - 5);
                bitmaps = new byte[buffer.remaining()];
                buffer.get(bitmaps);
                Roaring64NavigableMap b = new Roaring64NavigableMap();
                b.deserialize((DataInput)new DataInputStream(new ByteArrayInputStream(bitmaps)));
                rb = ClickHouseBitmap.wrap(b, innerType);
            }
        }
        return rb;
    }

    private static ByteBuffer newBuffer(int capacity) {
        ByteBuffer buffer = ByteBuffer.allocate(capacity);
        if (buffer.order() != ByteOrder.LITTLE_ENDIAN) {
            buffer = buffer.slice().order(ByteOrder.LITTLE_ENDIAN);
        }
        return buffer;
    }

    private static ByteBuffer flip(ByteBuffer buffer) {
        return (ByteBuffer)((Buffer)buffer).flip();
    }

    private static int byteLength(ClickHouseDataType type) {
        int byteLen;
        switch (Objects.requireNonNull(type)) {
            case Int8: 
            case UInt8: 
            case Int16: 
            case UInt16: 
            case Int32: 
            case UInt32: 
            case Int64: 
            case UInt64: {
                byteLen = type.getByteLength();
                break;
            }
            default: {
                throw new IllegalArgumentException("Only native integer types are supported but we got: " + type.name());
            }
        }
        return byteLen;
    }

    protected ClickHouseBitmap(Object bitmap, ClickHouseDataType innerType) {
        this.innerType = innerType;
        this.byteLen = ClickHouseBitmap.byteLength(innerType);
        this.reference = Objects.requireNonNull(bitmap);
    }

    public abstract boolean isEmpty();

    public abstract int getCardinality();

    public long getLongCardinality() {
        return this.getCardinality();
    }

    public abstract void serialize(ByteBuffer var1);

    public abstract int serializedSizeInBytes();

    public long serializedSizeInBytesAsLong() {
        return this.serializedSizeInBytes();
    }

    public abstract int[] toIntArray();

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ClickHouseBitmap b = (ClickHouseBitmap)obj;
        return Objects.equals((Object)this.innerType, (Object)b.innerType) && Objects.equals(this.byteLen, b.byteLen) && Objects.equals(this.reference, b.reference);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.innerType, this.byteLen, this.reference});
    }

    public long[] toLongArray() {
        int[] ints = this.toIntArray();
        int len = ints.length;
        long[] longs = new long[len];
        for (int i = 0; i < len; ++i) {
            longs[i] = ints[i];
        }
        return longs;
    }

    public ByteBuffer toByteBuffer() {
        ByteBuffer buf;
        int cardinality = this.getCardinality();
        if (cardinality <= 32) {
            buf = ClickHouseBitmap.newBuffer(2 + this.byteLen * cardinality);
            buf.put((byte)0);
            buf.put((byte)cardinality);
            if (this.byteLen == 1) {
                for (int v : this.toIntArray()) {
                    buf.put((byte)v);
                }
            } else if (this.byteLen == 2) {
                for (int v : this.toIntArray()) {
                    buf.putShort((short)v);
                }
            } else if (this.byteLen == 4) {
                for (int v : this.toIntArray()) {
                    buf.putInt(v);
                }
            } else {
                for (long v : this.toLongArray()) {
                    buf.putLong(v);
                }
            }
        } else if (this.byteLen <= 4) {
            int size = this.serializedSizeInBytes();
            int varIntSize = BinaryStreamUtils.getVarIntSize(size);
            buf = ClickHouseBitmap.newBuffer(1 + varIntSize + size);
            buf.put((byte)1);
            BinaryStreamUtils.writeVarInt(buf, size);
            this.serialize(buf);
        } else {
            long size = this.serializedSizeInBytesAsLong() - 1L + 4L;
            int varIntSize = BinaryStreamUtils.getVarLongSize(size);
            int intSize = (int)size;
            buf = ClickHouseBitmap.newBuffer(1 + varIntSize + intSize);
            buf.put((byte)1);
            BinaryStreamUtils.writeVarInt(buf, intSize);
            this.serialize(buf);
        }
        return (ByteBuffer)((Buffer)buf).flip();
    }

    public byte[] toBytes() {
        ByteBuffer buffer = this.toByteBuffer();
        byte[] bytes = new byte[buffer.remaining()];
        buffer.get(bytes);
        return bytes;
    }

    public String toBitmapBuildExpression() {
        StringBuilder sb = new StringBuilder();
        if (this.byteLen <= 4) {
            for (int v : this.toIntArray()) {
                sb.append(',').append("to").append(this.innerType.name()).append('(').append(v).append(')');
            }
        } else {
            for (long v : this.toLongArray()) {
                sb.append(',').append("to").append(this.innerType.name()).append('(').append(v).append(')');
            }
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(0).insert(0, '[').append(']');
        } else {
            sb.append("cast([] as Array(").append(this.innerType.name()).append(')').append(')');
        }
        return sb.insert(0, "bitmapBuild(").append(')').toString();
    }

    public Object unwrap() {
        return this.reference;
    }

    static class ClickHouseRoaring64NavigableMap
    extends ClickHouseBitmap {
        private final Roaring64NavigableMap rb;

        protected ClickHouseRoaring64NavigableMap(Roaring64NavigableMap bitmap, ClickHouseDataType innerType) {
            super(bitmap, innerType);
            this.rb = Objects.requireNonNull(bitmap);
        }

        @Override
        public boolean isEmpty() {
            return this.rb.isEmpty();
        }

        @Override
        public int getCardinality() {
            return this.rb.getIntCardinality();
        }

        @Override
        public long getLongCardinality() {
            return this.rb.getLongCardinality();
        }

        @Override
        public void serialize(ByteBuffer buffer) {
            int size = this.serializedSizeInBytes();
            try (ByteArrayOutputStream bas = new ByteArrayOutputStream(size);){
                DataOutputStream out = new DataOutputStream(bas);
                try {
                    this.rb.serialize((DataOutput)out);
                }
                catch (IOException e) {
                    throw new IllegalArgumentException("Failed to serialize given bitmap", e);
                }
                byte[] bytes = bas.toByteArray();
                for (int i = 4; i > 0; --i) {
                    buffer.put(bytes[i]);
                }
                buffer.putInt(0);
                buffer.put(bytes, 5, size - 5);
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to serialize given bitmap", e);
            }
        }

        @Override
        public int serializedSizeInBytes() {
            return (int)this.rb.serializedSizeInBytes();
        }

        @Override
        public long serializedSizeInBytesAsLong() {
            return this.rb.serializedSizeInBytes();
        }

        @Override
        public int[] toIntArray() {
            long[] longs = this.toLongArray();
            int len = longs.length;
            int[] ints = new int[len];
            for (int i = 0; i < len; ++i) {
                ints[i] = (int)longs[i];
            }
            return ints;
        }

        @Override
        public long[] toLongArray() {
            return this.rb.toArray();
        }
    }

    static class ClickHouseMutableRoaringBitmap
    extends ClickHouseBitmap {
        private final MutableRoaringBitmap rb;

        protected ClickHouseMutableRoaringBitmap(MutableRoaringBitmap bitmap, ClickHouseDataType innerType) {
            super(bitmap, innerType);
            this.rb = Objects.requireNonNull(bitmap);
        }

        @Override
        public boolean isEmpty() {
            return this.rb.isEmpty();
        }

        @Override
        public int getCardinality() {
            return this.rb.getCardinality();
        }

        @Override
        public void serialize(ByteBuffer buffer) {
            this.rb.serialize(buffer);
        }

        @Override
        public int serializedSizeInBytes() {
            return this.rb.serializedSizeInBytes();
        }

        @Override
        public int[] toIntArray() {
            return this.rb.toArray();
        }
    }

    static class ClickHouseImmutableRoaringBitmap
    extends ClickHouseBitmap {
        private final ImmutableRoaringBitmap rb;

        protected ClickHouseImmutableRoaringBitmap(ImmutableRoaringBitmap rb, ClickHouseDataType innerType) {
            super(rb, innerType);
            this.rb = Objects.requireNonNull(rb);
        }

        @Override
        public boolean isEmpty() {
            return this.rb.isEmpty();
        }

        @Override
        public int getCardinality() {
            return this.rb.getCardinality();
        }

        @Override
        public void serialize(ByteBuffer buffer) {
            this.rb.serialize(buffer);
        }

        @Override
        public int serializedSizeInBytes() {
            return this.rb.serializedSizeInBytes();
        }

        @Override
        public int[] toIntArray() {
            return this.rb.toArray();
        }
    }

    static class ClickHouseRoaringBitmap
    extends ClickHouseBitmap {
        private final RoaringBitmap rb;

        protected ClickHouseRoaringBitmap(RoaringBitmap bitmap, ClickHouseDataType innerType) {
            super(bitmap, innerType);
            this.rb = Objects.requireNonNull(bitmap);
        }

        @Override
        public boolean isEmpty() {
            return this.rb.isEmpty();
        }

        @Override
        public int getCardinality() {
            return this.rb.getCardinality();
        }

        @Override
        public void serialize(ByteBuffer buffer) {
            this.rb.serialize(buffer);
        }

        @Override
        public int serializedSizeInBytes() {
            return this.rb.serializedSizeInBytes();
        }

        @Override
        public int[] toIntArray() {
            return this.rb.toArray();
        }
    }
}

