/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.io.util;

import com.cedarsoftware.util.ConcurrentList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.function.Supplier;

public class SealableList<T>
implements List<T> {
    private final List<T> list;
    private final transient Supplier<Boolean> sealedSupplier;

    public SealableList(Supplier<Boolean> sealedSupplier) {
        this.list = new ConcurrentList();
        this.sealedSupplier = sealedSupplier;
    }

    public SealableList(Collection<T> col, Supplier<Boolean> sealedSupplier) {
        this.list = new ConcurrentList();
        this.list.addAll(col);
        this.sealedSupplier = sealedSupplier;
    }

    public SealableList(List<T> list, Supplier<Boolean> sealedSupplier) {
        this.list = list;
        this.sealedSupplier = sealedSupplier;
    }

    private void throwIfSealed() {
        if (this.sealedSupplier.get().booleanValue()) {
            throw new UnsupportedOperationException("This list has been sealed and is now immutable");
        }
    }

    @Override
    public boolean equals(Object other) {
        return this.list.equals(other);
    }

    @Override
    public int hashCode() {
        return this.list.hashCode();
    }

    public String toString() {
        return this.list.toString();
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.list.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> col) {
        return new HashSet<T>(this.list).containsAll(col);
    }

    @Override
    public int indexOf(Object o) {
        return this.list.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.list.lastIndexOf(o);
    }

    @Override
    public T get(int index) {
        return this.list.get(index);
    }

    @Override
    public Object[] toArray() {
        return this.list.toArray();
    }

    @Override
    public <T1> T1[] toArray(T1[] a) {
        return this.list.toArray(a);
    }

    @Override
    public Iterator<T> iterator() {
        return this.createSealHonoringIterator(this.list.iterator());
    }

    @Override
    public ListIterator<T> listIterator() {
        return this.createSealHonoringListIterator(this.list.listIterator());
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        return this.createSealHonoringListIterator(this.list.listIterator(index));
    }

    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        return new SealableList<T>(this.list.subList(fromIndex, toIndex), this.sealedSupplier);
    }

    @Override
    public boolean add(T t) {
        this.throwIfSealed();
        return this.list.add(t);
    }

    @Override
    public boolean remove(Object o) {
        this.throwIfSealed();
        return this.list.remove(o);
    }

    @Override
    public boolean addAll(Collection<? extends T> col) {
        this.throwIfSealed();
        return this.list.addAll(col);
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> col) {
        this.throwIfSealed();
        return this.list.addAll(index, col);
    }

    @Override
    public boolean removeAll(Collection<?> col) {
        this.throwIfSealed();
        return this.list.removeAll(col);
    }

    @Override
    public boolean retainAll(Collection<?> col) {
        this.throwIfSealed();
        return this.list.retainAll(col);
    }

    @Override
    public void clear() {
        this.throwIfSealed();
        this.list.clear();
    }

    @Override
    public T set(int index, T element) {
        this.throwIfSealed();
        return this.list.set(index, element);
    }

    @Override
    public void add(int index, T element) {
        this.throwIfSealed();
        this.list.add(index, element);
    }

    @Override
    public T remove(int index) {
        this.throwIfSealed();
        return this.list.remove(index);
    }

    private Iterator<T> createSealHonoringIterator(final Iterator<T> iterator) {
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public T next() {
                return iterator.next();
            }

            @Override
            public void remove() {
                SealableList.this.throwIfSealed();
                iterator.remove();
            }
        };
    }

    private ListIterator<T> createSealHonoringListIterator(final ListIterator<T> iterator) {
        return new ListIterator<T>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public T next() {
                return iterator.next();
            }

            @Override
            public boolean hasPrevious() {
                return iterator.hasPrevious();
            }

            @Override
            public T previous() {
                return iterator.previous();
            }

            @Override
            public int nextIndex() {
                return iterator.nextIndex();
            }

            @Override
            public int previousIndex() {
                return iterator.previousIndex();
            }

            @Override
            public void remove() {
                SealableList.this.throwIfSealed();
                iterator.remove();
            }

            @Override
            public void set(T e) {
                SealableList.this.throwIfSealed();
                iterator.set(e);
            }

            @Override
            public void add(T e) {
                SealableList.this.throwIfSealed();
                iterator.add(e);
            }
        };
    }
}

