/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.io.factory;

import com.cedarsoftware.io.JsonIoException;
import com.cedarsoftware.io.JsonObject;
import com.cedarsoftware.io.JsonReader;
import com.cedarsoftware.io.Resolver;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NavigableMap;
import java.util.SortedMap;
import java.util.TreeMap;

public class MapFactory
implements JsonReader.ClassFactory {
    @Override
    public Object newInstance(Class<?> c, JsonObject jObj, Resolver resolver) {
        int size;
        int defaultCapacity = resolver.getReadOptions().getDefaultCollectionCapacity();
        float loadFactor = resolver.getReadOptions().getCollectionLoadFactor();
        int minCapacity = resolver.getReadOptions().getMinCollectionCapacity();
        Object[] keys = jObj.getKeys();
        int n = size = keys != null ? keys.length : 0;
        if (NavigableMap.class.isAssignableFrom(c)) {
            return new TreeMap();
        }
        if (SortedMap.class.isAssignableFrom(c)) {
            return new TreeMap();
        }
        if (Map.class.isAssignableFrom(c)) {
            int capacity = Math.max(minCapacity, (int)((float)size / loadFactor) + 1);
            return new LinkedHashMap(capacity, loadFactor);
        }
        throw new JsonIoException("MapFactory handed Class for which it was not expecting: " + c.getName());
    }
}

