/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.io.factory;

import com.cedarsoftware.io.JsonObject;
import com.cedarsoftware.io.JsonReader;
import com.cedarsoftware.io.Resolver;
import com.cedarsoftware.util.ExceptionUtilities;
import com.cedarsoftware.util.ReflectionUtils;
import java.lang.reflect.Constructor;

public class StackTraceElementFactory
implements JsonReader.ClassFactory {
    public static final String DECLARING_CLASS = "declaringClass";
    public static final String METHOD_NAME = "methodName";
    public static final String FILE_NAME = "fileName";
    public static final String LINE_NUMBER = "lineNumber";
    public static final String CLASS_LOADER_NAME = "classLoaderName";
    public static final String MODULE_NAME = "moduleName";
    public static final String MODULE_VERSION = "moduleVersion";
    private static final Constructor<?> constructor1 = ReflectionUtils.getConstructor(StackTraceElement.class, (Class[])new Class[]{String.class, String.class, String.class, Integer.TYPE});
    private static final Constructor<?> constructor2 = ReflectionUtils.getConstructor(StackTraceElement.class, (Class[])new Class[]{String.class, String.class, String.class, String.class, String.class, String.class, Integer.TYPE});

    @Override
    public Object newInstance(Class<?> c, JsonObject jObj, Resolver resolver) {
        StackTraceElement element;
        String declaringClass = (String)jObj.get(DECLARING_CLASS);
        String methodName = (String)jObj.get(METHOD_NAME);
        String fileName = (String)jObj.get(FILE_NAME);
        Number lineNum = (Number)jObj.get(LINE_NUMBER);
        String classLoaderName = (String)jObj.get(CLASS_LOADER_NAME);
        String moduleName = (String)jObj.get(MODULE_NAME);
        String moduleVersion = (String)jObj.get(MODULE_VERSION);
        if (constructor2 != null && (element = (StackTraceElement)ExceptionUtilities.safelyIgnoreException(() -> (StackTraceElement)constructor2.newInstance(classLoaderName, moduleName, moduleVersion, declaringClass, methodName, fileName, lineNum.intValue()), null)) != null) {
            return element;
        }
        if (constructor1 != null && (element = (StackTraceElement)ExceptionUtilities.safelyIgnoreException(() -> (StackTraceElement)constructor1.newInstance(declaringClass, methodName, fileName, lineNum.intValue()), null)) != null) {
            return element;
        }
        return new StackTraceElement(declaringClass, methodName, fileName, lineNum == null ? -1 : lineNum.intValue());
    }

    @Override
    public boolean isObjectFinal() {
        return true;
    }
}

