/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.io.writers;

import com.cedarsoftware.io.JsonWriter;
import com.cedarsoftware.io.WriterContext;
import java.io.IOException;
import java.io.Writer;
import java.nio.CharBuffer;

public class CharBufferWriter
implements JsonWriter.JsonClassWriter {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void write(Object obj, boolean showType, Writer output, WriterContext context) throws IOException {
        CharBuffer chars = (CharBuffer)obj;
        output.write("\"value\":\"");
        if (chars.hasArray()) {
            char[] array = chars.array();
            int offset = chars.arrayOffset() + chars.position();
            int end = offset + chars.remaining();
            block21: for (int i = offset; i < end; ++i) {
                char c = array[i];
                switch (c) {
                    case '\"': {
                        output.write("\\\"");
                        continue block21;
                    }
                    case '\\': {
                        output.write("\\\\");
                        continue block21;
                    }
                    case '\b': {
                        output.write("\\b");
                        continue block21;
                    }
                    case '\f': {
                        output.write("\\f");
                        continue block21;
                    }
                    case '\n': {
                        output.write("\\n");
                        continue block21;
                    }
                    case '\r': {
                        output.write("\\r");
                        continue block21;
                    }
                    case '\t': {
                        output.write("\\t");
                        continue block21;
                    }
                    default: {
                        if (c < ' ') {
                            output.write(String.format("\\u%04x", c));
                            continue block21;
                        }
                        output.write(c);
                    }
                }
            }
        } else {
            int originalPosition = chars.position();
            try {
                block22: while (chars.hasRemaining()) {
                    char c = chars.get();
                    switch (c) {
                        case '\"': {
                            output.write("\\\"");
                            continue block22;
                        }
                        case '\\': {
                            output.write("\\\\");
                            continue block22;
                        }
                        case '\b': {
                            output.write("\\b");
                            continue block22;
                        }
                        case '\f': {
                            output.write("\\f");
                            continue block22;
                        }
                        case '\n': {
                            output.write("\\n");
                            continue block22;
                        }
                        case '\r': {
                            output.write("\\r");
                            continue block22;
                        }
                        case '\t': {
                            output.write("\\t");
                            continue block22;
                        }
                    }
                    if (c < ' ') {
                        output.write(String.format("\\u%04x", c));
                        continue;
                    }
                    output.write(c);
                }
            }
            finally {
                chars.position(originalPosition);
            }
        }
        output.write("\"");
    }
}

