/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.io.factory;

import com.cedarsoftware.io.JsonIoException;
import com.cedarsoftware.io.JsonObject;
import com.cedarsoftware.io.JsonReader;
import com.cedarsoftware.io.Resolver;
import java.nio.ByteBuffer;
import java.util.Base64;

public class ByteBufferFactory
implements JsonReader.ClassFactory {
    @Override
    public ByteBuffer newInstance(Class<?> c, JsonObject jObj, Resolver resolver) {
        if (!jObj.containsKey("value")) {
            throw new JsonIoException("Invalid ByteBuffer format. Missing 'value' field.");
        }
        Object val = jObj.getValue();
        if (!(val instanceof String)) {
            throw new JsonIoException("Invalid ByteBuffer format. 'value' must be a Base64-encoded String.");
        }
        String base64 = (String)val;
        byte[] decoded = Base64.getDecoder().decode(base64);
        return ByteBuffer.wrap(decoded);
    }
}

