/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util;

import com.cedarsoftware.util.CaseInsensitiveMap;
import com.cedarsoftware.util.CompactMap;
import com.cedarsoftware.util.IdentitySet;
import com.cedarsoftware.util.TrackingMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.SortedMap;

public class MapUtilities {
    private static final int MAX_ENTRIES = 10;

    private MapUtilities() {
    }

    public static <T> T get(Map<?, T> map, Object key, T def) {
        T val = map.get(key);
        return val == null ? def : val;
    }

    public static <T extends Throwable> Object getOrThrow(Map<?, ?> map, Object key, T throwable) throws T {
        if (map == null) {
            throw new NullPointerException("Map parameter cannot be null");
        }
        if (throwable == null) {
            throw new NullPointerException("Throwable object cannot be null");
        }
        if (map.containsKey(key)) {
            return map.get(key);
        }
        throw throwable;
    }

    public static boolean isEmpty(Map<?, ?> map) {
        return map == null || map.isEmpty();
    }

    public static <T> Map<Class<?>, Set<T>> dupe(Map<Class<?>, Set<T>> other, boolean unmodifiable) {
        LinkedHashMap newItemsAssocToClass = new LinkedHashMap();
        for (Map.Entry<Class<?>, Set<T>> entry : other.entrySet()) {
            LinkedHashSet itemsAssocToClass = new LinkedHashSet(entry.getValue());
            if (unmodifiable) {
                newItemsAssocToClass.computeIfAbsent(entry.getKey(), k -> Collections.unmodifiableSet(itemsAssocToClass));
                continue;
            }
            newItemsAssocToClass.computeIfAbsent(entry.getKey(), k -> itemsAssocToClass);
        }
        if (unmodifiable) {
            return Collections.unmodifiableMap(newItemsAssocToClass);
        }
        return newItemsAssocToClass;
    }

    public static <T, V> Map<T, Set<V>> cloneMapOfSets(Map<T, Set<V>> original, boolean immutable) {
        HashMap<T, HashSet<V>> result = new HashMap<T, HashSet<V>>();
        for (Map.Entry<T, Set<V>> entry : original.entrySet()) {
            T key = entry.getKey();
            Set<V> value = entry.getValue();
            HashSet<V> clonedSet = immutable ? Collections.unmodifiableSet(value) : new HashSet<V>(value);
            result.put(key, clonedSet);
        }
        return immutable ? Collections.unmodifiableMap(result) : result;
    }

    public static <T, U, V> Map<T, Map<U, V>> cloneMapOfMaps(Map<T, Map<U, V>> original, boolean immutable) {
        LinkedHashMap<T, LinkedHashMap<U, V>> result = new LinkedHashMap<T, LinkedHashMap<U, V>>();
        for (Map.Entry<T, Map<U, V>> entry : original.entrySet()) {
            T key = entry.getKey();
            Map<U, V> value = entry.getValue();
            LinkedHashMap<U, V> clonedMap = immutable ? Collections.unmodifiableMap(value) : new LinkedHashMap<U, V>(value);
            result.put(key, clonedMap);
        }
        return immutable ? Collections.unmodifiableMap(result) : result;
    }

    public static <K, V> String mapToString(Map<K, V> map) {
        Iterator<Map.Entry<K, V>> i = map.entrySet().iterator();
        if (!i.hasNext()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        while (true) {
            Map.Entry<K, V> e = i.next();
            K key = e.getKey();
            V value = e.getValue();
            sb.append((Object)(key == map ? "(this Map)" : key));
            sb.append('=');
            sb.append((Object)(value == map ? "(this Map)" : value));
            if (!i.hasNext()) {
                return sb.append('}').toString();
            }
            sb.append(',').append(' ');
        }
    }

    @SafeVarargs
    public static <K, V> Map<K, V> mapOf(Object ... keyValues) {
        if (keyValues == null || keyValues.length == 0) {
            return Collections.unmodifiableMap(new LinkedHashMap());
        }
        if (keyValues.length % 2 != 0) {
            throw new IllegalArgumentException("Invalid number of arguments; keys and values must be paired.");
        }
        if (keyValues.length / 2 > 10) {
            throw new IllegalArgumentException("Too many entries; maximum is 10");
        }
        LinkedHashMap<Object, Object> map = new LinkedHashMap<Object, Object>(keyValues.length / 2);
        for (int i = 0; i < keyValues.length; i += 2) {
            Object key = keyValues[i];
            Object value = keyValues[i + 1];
            map.put(key, value);
        }
        return Collections.unmodifiableMap(map);
    }

    @SafeVarargs
    public static <K, V> Map<K, V> mapOfEntries(Map.Entry<K, V> ... entries) {
        if (entries == null || entries.length == 0) {
            return Collections.unmodifiableMap(new LinkedHashMap());
        }
        LinkedHashMap<K, V> map = new LinkedHashMap<K, V>(entries.length);
        for (Map.Entry<K, V> entry : entries) {
            if (entry == null) {
                throw new NullPointerException("Entries must not be null.");
            }
            map.put(entry.getKey(), entry.getValue());
        }
        return Collections.unmodifiableMap(map);
    }

    private static Map<?, ?> getUnderlyingMap(Map<?, ?> map) {
        if (map == null) {
            return null;
        }
        IdentitySet seen = new IdentitySet();
        Map current = map;
        ArrayList<String> path = new ArrayList<String>();
        path.add(current.getClass().getSimpleName());
        while (true) {
            if (!seen.add(current)) {
                throw new IllegalArgumentException("Circular map structure detected: " + String.join((CharSequence)" -> ", path));
            }
            if (current instanceof CompactMap) {
                CompactMap cMap = (CompactMap)current;
                if (cMap.getLogicalValueType() == CompactMap.LogicalValueType.MAP) {
                    current = (Map)cMap.val;
                    path.add(current.getClass().getSimpleName());
                    continue;
                }
                return current;
            }
            if (current instanceof CaseInsensitiveMap) {
                current = ((CaseInsensitiveMap)current).getWrappedMap();
                path.add(current.getClass().getSimpleName());
                continue;
            }
            if (!(current instanceof TrackingMap)) break;
            current = ((TrackingMap)current).getWrappedMap();
            path.add(current.getClass().getSimpleName());
        }
        return current;
    }

    static String getMapStructureString(Map<?, ?> map) {
        ArrayList<String> structure;
        block6: {
            if (map == null) {
                return "null";
            }
            structure = new ArrayList<String>();
            IdentitySet seen = new IdentitySet();
            Map current = map;
            while (true) {
                if (!seen.add(current)) {
                    structure.add("CYCLE -> " + current.getClass().getSimpleName());
                    break block6;
                }
                if (current instanceof CompactMap) {
                    CompactMap cMap = (CompactMap)current;
                    structure.add("CompactMap(" + cMap.getOrdering() + ")");
                    CompactMap.LogicalValueType valueType = cMap.getLogicalValueType();
                    if (valueType == CompactMap.LogicalValueType.MAP) {
                        current = (Map)cMap.val;
                        continue;
                    }
                    structure.add("[" + valueType.name() + "]");
                    break block6;
                }
                if (current instanceof CaseInsensitiveMap) {
                    structure.add("CaseInsensitiveMap");
                    current = ((CaseInsensitiveMap)current).getWrappedMap();
                    continue;
                }
                if (!(current instanceof TrackingMap)) break;
                structure.add("TrackingMap");
                current = ((TrackingMap)current).getWrappedMap();
            }
            structure.add(current.getClass().getSimpleName() + (current instanceof NavigableMap ? "(NavigableMap)" : ""));
        }
        return String.join((CharSequence)" -> ", structure);
    }

    static String detectMapOrdering(Map<?, ?> map) {
        if (map == null) {
            return "unordered";
        }
        try {
            if (map instanceof CompactMap) {
                return ((CompactMap)map).getOrdering();
            }
            Map<?, ?> underlyingMap = MapUtilities.getUnderlyingMap(map);
            if (underlyingMap instanceof CompactMap) {
                return ((CompactMap)underlyingMap).getOrdering();
            }
            if (underlyingMap instanceof SortedMap) {
                return "sorted";
            }
            if (underlyingMap instanceof LinkedHashMap || underlyingMap instanceof EnumMap) {
                return "insertion";
            }
            return "unordered";
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Cannot determine map ordering: " + e.getMessage());
        }
    }
}

