/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util.convert;

import com.cedarsoftware.util.ClassUtilities;
import com.cedarsoftware.util.StringUtilities;
import com.cedarsoftware.util.convert.Converter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Base64;
import java.util.Calendar;
import java.util.Currency;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Pattern;

final class MapConversions {
    static final String V = "_v";
    static final String VALUE = "value";
    static final String DATE = "date";
    static final String SQL_DATE = "sqlDate";
    static final String CALENDAR = "calendar";
    static final String TIMESTAMP = "timestamp";
    static final String DURATION = "duration";
    static final String INSTANT = "instant";
    static final String LOCALE = "locale";
    static final String MONTH_DAY = "monthDay";
    static final String YEAR_MONTH = "yearMonth";
    static final String PERIOD = "period";
    static final String ZONE_OFFSET = "zoneOffset";
    static final String LOCAL_DATE = "localDate";
    static final String LOCAL_TIME = "localTime";
    static final String LOCAL_DATE_TIME = "localDateTime";
    static final String OFFSET_TIME = "offsetTime";
    static final String OFFSET_DATE_TIME = "offsetDateTime";
    static final String ZONED_DATE_TIME = "zonedDateTime";
    static final String ZONE = "zone";
    static final String YEAR = "year";
    static final String EPOCH_MILLIS = "epochMillis";
    static final String MOST_SIG_BITS = "mostSigBits";
    static final String LEAST_SIG_BITS = "leastSigBits";
    static final String ID = "id";
    static final String URI_KEY = "URI";
    static final String URL_KEY = "URL";
    static final String UUID = "UUID";
    static final String CLASS = "class";
    static final String MESSAGE = "message";
    static final String DETAIL_MESSAGE = "detailMessage";
    static final String CAUSE = "cause";
    static final String CAUSE_MESSAGE = "causeMessage";
    private static final Object NO_MATCH = new Object();
    private static final String[] VALUE_KEYS = new String[]{"value", "_v"};
    private static final String[] SQL_DATE_KEYS = new String[]{"sqlDate", "value", "_v", "epochMillis"};
    private static final String[] DATE_KEYS = new String[]{"date", "value", "_v", "epochMillis"};
    private static final String[] TIMESTAMP_KEYS = new String[]{"timestamp", "value", "_v", "epochMillis"};
    private static final String[] ZONE_KEYS = new String[]{"zone", "id", "value", "_v"};
    private static final String[] CALENDAR_KEYS = new String[]{"calendar", "value", "_v", "epochMillis"};
    private static final String[] LOCALE_KEYS = new String[]{"locale", "value", "_v"};
    private static final String[] LOCAL_DATE_KEYS = new String[]{"localDate", "value", "_v"};
    private static final String[] LOCAL_TIME_KEYS = new String[]{"localTime", "value", "_v"};
    private static final String[] LDT_KEYS = new String[]{"localDateTime", "value", "_v", "epochMillis"};
    private static final String[] OFFSET_TIME_KEYS = new String[]{"offsetTime", "value", "_v"};
    private static final String[] OFFSET_KEYS = new String[]{"offsetDateTime", "value", "_v", "epochMillis"};
    private static final String[] ZDT_KEYS = new String[]{"zonedDateTime", "value", "_v", "epochMillis"};
    private static final String[] CLASS_KEYS = new String[]{"class", "value", "_v"};
    private static final String[] DURATION_KEYS = new String[]{"duration", "value", "_v"};
    private static final String[] INSTANT_KEYS = new String[]{"instant", "value", "_v"};
    private static final String[] MONTH_DAY_KEYS = new String[]{"monthDay", "value", "_v"};
    private static final String[] YEAR_MONTH_KEYS = new String[]{"yearMonth", "value", "_v"};
    private static final String[] PERIOD_KEYS = new String[]{"period", "value", "_v"};
    private static final String[] ZONE_OFFSET_KEYS = new String[]{"zoneOffset", "value", "_v"};
    private static final String[] YEAR_KEYS = new String[]{"year", "value", "_v"};
    private static final String[] URL_KEYS = new String[]{"URL", "value", "_v"};
    private static final String[] URI_KEYS = new String[]{"URI", "value", "_v"};

    private MapConversions() {
    }

    private static <T> T dispatch(Object from, Converter converter, Class<T> clazz, String[] keys) {
        Object value = MapConversions.getValue((Map)from, keys);
        if (value != NO_MATCH) {
            return converter.convert(value, clazz);
        }
        return MapConversions.fromMap(clazz, keys);
    }

    static Object toUUID(Object from, Converter converter) {
        Map map = (Map)from;
        Object mostSigBits = map.get(MOST_SIG_BITS);
        Object leastSigBits = map.get(LEAST_SIG_BITS);
        if (mostSigBits != null && leastSigBits != null) {
            long most = converter.convert(mostSigBits, Long.TYPE);
            long least = converter.convert(leastSigBits, Long.TYPE);
            return new UUID(most, least);
        }
        return MapConversions.dispatch(from, converter, UUID.class, new String[]{UUID, VALUE, V, "mostSigBits, leastSigBits"});
    }

    static Byte toByte(Object from, Converter converter) {
        return MapConversions.dispatch(from, converter, Byte.class, VALUE_KEYS);
    }

    static Short toShort(Object from, Converter converter) {
        return MapConversions.dispatch(from, converter, Short.class, VALUE_KEYS);
    }

    static Integer toInt(Object from, Converter converter) {
        return MapConversions.dispatch(from, converter, Integer.class, VALUE_KEYS);
    }

    static Long toLong(Object from, Converter converter) {
        return MapConversions.dispatch(from, converter, Long.class, VALUE_KEYS);
    }

    static Float toFloat(Object from, Converter converter) {
        return MapConversions.dispatch(from, converter, Float.class, VALUE_KEYS);
    }

    static Double toDouble(Object from, Converter converter) {
        return MapConversions.dispatch(from, converter, Double.class, VALUE_KEYS);
    }

    static Boolean toBoolean(Object from, Converter converter) {
        return MapConversions.dispatch(from, converter, Boolean.class, VALUE_KEYS);
    }

    static BigDecimal toBigDecimal(Object from, Converter converter) {
        return MapConversions.dispatch(from, converter, BigDecimal.class, VALUE_KEYS);
    }

    static BigInteger toBigInteger(Object from, Converter converter) {
        return MapConversions.dispatch(from, converter, BigInteger.class, VALUE_KEYS);
    }

    static String toString(Object from, Converter converter) {
        return MapConversions.dispatch(from, converter, String.class, VALUE_KEYS);
    }

    static StringBuffer toStringBuffer(Object from, Converter converter) {
        return MapConversions.dispatch(from, converter, StringBuffer.class, VALUE_KEYS);
    }

    static StringBuilder toStringBuilder(Object from, Converter converter) {
        return MapConversions.dispatch(from, converter, StringBuilder.class, VALUE_KEYS);
    }

    static Character toCharacter(Object from, Converter converter) {
        return MapConversions.dispatch(from, converter, Character.TYPE, VALUE_KEYS);
    }

    static AtomicInteger toAtomicInteger(Object from, Converter converter) {
        return MapConversions.dispatch(from, converter, AtomicInteger.class, VALUE_KEYS);
    }

    static AtomicLong toAtomicLong(Object from, Converter converter) {
        return MapConversions.dispatch(from, converter, AtomicLong.class, VALUE_KEYS);
    }

    static AtomicBoolean toAtomicBoolean(Object from, Converter converter) {
        return MapConversions.dispatch(from, converter, AtomicBoolean.class, VALUE_KEYS);
    }

    static Pattern toPattern(Object from, Converter converter) {
        return MapConversions.dispatch(from, converter, Pattern.class, VALUE_KEYS);
    }

    static Currency toCurrency(Object from, Converter converter) {
        return MapConversions.dispatch(from, converter, Currency.class, VALUE_KEYS);
    }

    static Date toSqlDate(Object from, Converter converter) {
        return MapConversions.dispatch(from, converter, Date.class, SQL_DATE_KEYS);
    }

    static java.util.Date toDate(Object from, Converter converter) {
        return MapConversions.dispatch(from, converter, java.util.Date.class, DATE_KEYS);
    }

    static Timestamp toTimestamp(Object from, Converter converter) {
        return MapConversions.dispatch(from, converter, Timestamp.class, TIMESTAMP_KEYS);
    }

    static TimeZone toTimeZone(Object from, Converter converter) {
        return MapConversions.dispatch(from, converter, TimeZone.class, ZONE_KEYS);
    }

    static Calendar toCalendar(Object from, Converter converter) {
        return MapConversions.dispatch(from, converter, Calendar.class, CALENDAR_KEYS);
    }

    static Locale toLocale(Object from, Converter converter) {
        return MapConversions.dispatch(from, converter, Locale.class, LOCALE_KEYS);
    }

    static LocalDate toLocalDate(Object from, Converter converter) {
        return MapConversions.dispatch(from, converter, LocalDate.class, LOCAL_DATE_KEYS);
    }

    static LocalTime toLocalTime(Object from, Converter converter) {
        return MapConversions.dispatch(from, converter, LocalTime.class, LOCAL_TIME_KEYS);
    }

    static LocalDateTime toLocalDateTime(Object from, Converter converter) {
        return MapConversions.dispatch(from, converter, LocalDateTime.class, LDT_KEYS);
    }

    static OffsetTime toOffsetTime(Object from, Converter converter) {
        return MapConversions.dispatch(from, converter, OffsetTime.class, OFFSET_TIME_KEYS);
    }

    static OffsetDateTime toOffsetDateTime(Object from, Converter converter) {
        return MapConversions.dispatch(from, converter, OffsetDateTime.class, OFFSET_KEYS);
    }

    static ZonedDateTime toZonedDateTime(Object from, Converter converter) {
        return MapConversions.dispatch(from, converter, ZonedDateTime.class, ZDT_KEYS);
    }

    static Class<?> toClass(Object from, Converter converter) {
        return MapConversions.dispatch(from, converter, Class.class, CLASS_KEYS);
    }

    static Duration toDuration(Object from, Converter converter) {
        return MapConversions.dispatch(from, converter, Duration.class, DURATION_KEYS);
    }

    static Instant toInstant(Object from, Converter converter) {
        return MapConversions.dispatch(from, converter, Instant.class, INSTANT_KEYS);
    }

    static MonthDay toMonthDay(Object from, Converter converter) {
        return MapConversions.dispatch(from, converter, MonthDay.class, MONTH_DAY_KEYS);
    }

    static YearMonth toYearMonth(Object from, Converter converter) {
        return MapConversions.dispatch(from, converter, YearMonth.class, YEAR_MONTH_KEYS);
    }

    static Period toPeriod(Object from, Converter converter) {
        return MapConversions.dispatch(from, converter, Period.class, PERIOD_KEYS);
    }

    static ZoneId toZoneId(Object from, Converter converter) {
        return MapConversions.dispatch(from, converter, ZoneId.class, ZONE_KEYS);
    }

    static ZoneOffset toZoneOffset(Object from, Converter converter) {
        return MapConversions.dispatch(from, converter, ZoneOffset.class, ZONE_OFFSET_KEYS);
    }

    static Year toYear(Object from, Converter converter) {
        return MapConversions.dispatch(from, converter, Year.class, YEAR_KEYS);
    }

    static URL toURL(Object from, Converter converter) {
        return MapConversions.dispatch(from, converter, URL.class, URL_KEYS);
    }

    static URI toURI(Object from, Converter converter) {
        return MapConversions.dispatch(from, converter, URI.class, URI_KEYS);
    }

    static ByteBuffer toByteBuffer(Object from, Converter converter) {
        Object valueObj;
        Map map = (Map)from;
        Object v = valueObj = map.containsKey(VALUE) ? map.get(VALUE) : map.get(V);
        if (valueObj == null) {
            throw new IllegalArgumentException("Unable to convert map to ByteBuffer: Missing or null 'value' or '_v' field");
        }
        if (!(valueObj instanceof String)) {
            throw new IllegalArgumentException("Unable to convert map to ByteBuffer: Value must be a Base64-encoded String, found: " + valueObj.getClass().getName());
        }
        String base64 = (String)valueObj;
        try {
            byte[] decoded = Base64.getDecoder().decode(base64);
            return ByteBuffer.wrap(decoded);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Unable to convert map to ByteBuffer: Invalid Base64 encoding", e);
        }
    }

    static CharBuffer toCharBuffer(Object from, Converter converter) {
        return MapConversions.dispatch(from, converter, CharBuffer.class, VALUE_KEYS);
    }

    static Throwable toThrowable(Object from, Converter converter, Class<?> target) {
        Map map = (Map)from;
        try {
            Class<?> specifiedClass;
            LinkedHashMap<String, Object> namedParams = new LinkedHashMap<String, Object>(map);
            Object causeValue = namedParams.get(CAUSE);
            if (causeValue instanceof String) {
                Class<?> causeClass;
                String causeClassName = (String)causeValue;
                String causeMessage = (String)namedParams.get(CAUSE_MESSAGE);
                if (StringUtilities.hasContent(causeClassName) && (causeClass = ClassUtilities.forName(causeClassName, ClassUtilities.getClassLoader(MapConversions.class))) != null) {
                    LinkedHashMap<String, String> causeMap = new LinkedHashMap<String, String>();
                    if (causeMessage != null) {
                        causeMap.put(MESSAGE, causeMessage);
                    }
                    Throwable cause = (Throwable)ClassUtilities.newInstance(converter, causeClass, causeMap);
                    namedParams.put(CAUSE, cause);
                }
                namedParams.remove(CAUSE_MESSAGE);
            } else if (causeValue instanceof Map) {
                Map causeMap = (Map)causeValue;
                Throwable cause = MapConversions.toThrowable(causeMap, converter, Throwable.class);
                namedParams.put(CAUSE, cause);
            }
            MapConversions.addThrowableAliases(namedParams);
            Class<?> classToUse = target;
            String className = (String)namedParams.get(CLASS);
            if (StringUtilities.hasContent(className) && (specifiedClass = ClassUtilities.forName(className, ClassUtilities.getClassLoader(MapConversions.class))) != null && target.isAssignableFrom(specifiedClass)) {
                classToUse = specifiedClass;
            }
            namedParams.remove(CLASS);
            Throwable exception = (Throwable)ClassUtilities.newInstance(converter, classToUse, namedParams);
            exception.setStackTrace(new StackTraceElement[0]);
            return exception;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to create " + target.getName() + " from map: " + map, e);
        }
    }

    private static void addThrowableAliases(Map<String, Object> namedParams) {
        Object messageValue;
        String[] messageFields;
        for (String field : messageFields = new String[]{DETAIL_MESSAGE, MESSAGE, "msg"}) {
            if (!namedParams.containsKey(field) || namedParams.get(field) != null) continue;
            namedParams.put(field, "");
        }
        if (!namedParams.containsKey("msg")) {
            messageValue = null;
            if (namedParams.containsKey(DETAIL_MESSAGE)) {
                messageValue = namedParams.get(DETAIL_MESSAGE);
            } else if (namedParams.containsKey(MESSAGE)) {
                messageValue = namedParams.get(MESSAGE);
            } else if (namedParams.containsKey("reason")) {
                messageValue = namedParams.get("reason");
            } else if (namedParams.containsKey("description")) {
                messageValue = namedParams.get("description");
            }
            if (messageValue != null) {
                namedParams.put("msg", messageValue);
            }
        }
        if (!namedParams.containsKey(MESSAGE)) {
            messageValue = null;
            if (namedParams.containsKey(DETAIL_MESSAGE)) {
                messageValue = namedParams.get(DETAIL_MESSAGE);
            } else if (namedParams.containsKey("msg")) {
                messageValue = namedParams.get("msg");
            }
            if (messageValue != null) {
                namedParams.put(MESSAGE, messageValue);
            }
        }
        if (!namedParams.containsKey("s")) {
            messageValue = namedParams.get(MESSAGE);
            if (messageValue == null) {
                messageValue = namedParams.get("msg");
            }
            if (messageValue == null) {
                messageValue = namedParams.get(DETAIL_MESSAGE);
            }
            if (messageValue != null) {
                namedParams.put("s", messageValue);
            }
        }
        if (!namedParams.containsKey(CAUSE) && namedParams.containsKey("rootCause")) {
            namedParams.put(CAUSE, namedParams.get("rootCause"));
        }
        if (!namedParams.containsKey("throwable") && namedParams.containsKey(CAUSE)) {
            namedParams.put("throwable", namedParams.get(CAUSE));
        }
        if (!namedParams.containsKey("t")) {
            Object causeValue = namedParams.get(CAUSE);
            if (causeValue == null) {
                causeValue = namedParams.get("throwable");
            }
            if (causeValue == null) {
                causeValue = namedParams.get("rootCause");
            }
            if (causeValue != null) {
                namedParams.put("t", causeValue);
            }
        }
        if (namedParams.containsKey("suppressionEnabled") && !namedParams.containsKey("enableSuppression")) {
            namedParams.put("enableSuppression", namedParams.get("suppressionEnabled"));
        }
        if (namedParams.containsKey("stackTraceWritable") && !namedParams.containsKey("writableStackTrace")) {
            namedParams.put("writableStackTrace", namedParams.get("stackTraceWritable"));
        }
    }

    static Map<String, ?> initMap(Object from, Converter converter) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put(V, from);
        return map;
    }

    private static <T> T fromMap(Class<T> type, String[] keys) {
        StringBuilder builder = new StringBuilder();
        builder.append("To convert from Map to '").append(Converter.getShortName(type)).append("' the map must include: ");
        builder.append(MapConversions.formatKeys(keys));
        builder.append(" as key with associated value.");
        throw new IllegalArgumentException(builder.toString());
    }

    private static String formatKeys(String[] keys) {
        if (keys == null || keys.length == 0) {
            return "";
        }
        if (keys.length == 1) {
            return "[" + keys[0] + "]";
        }
        if (keys.length == 2) {
            return "[" + keys[0] + "] or [" + keys[1] + "]";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < keys.length; ++i) {
            if (i > 0) {
                if (i == keys.length - 1) {
                    sb.append(", or ");
                } else {
                    sb.append(", ");
                }
            }
            sb.append("[").append(keys[i]).append("]");
        }
        return sb.toString();
    }

    private static Object getValue(Map<String, Object> map, String[] keys) {
        String hadKey = null;
        for (String key : keys) {
            Object value = map.get(key);
            if (value != null && (!(value instanceof String) || StringUtilities.hasContent((String)value))) {
                return value;
            }
            if (!map.containsKey(key)) continue;
            hadKey = key;
        }
        if (hadKey != null) {
            return map.get(hadKey);
        }
        return NO_MATCH;
    }
}

