/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util;

import com.cedarsoftware.util.AdjustableGZIPOutputStream;
import com.cedarsoftware.util.ByteUtilities;
import com.cedarsoftware.util.Convention;
import com.cedarsoftware.util.FastByteArrayOutputStream;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.File;
import java.io.Flushable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Arrays;
import java.util.Objects;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public final class IOUtilities {
    private static final int TRANSFER_BUFFER = 32768;

    private IOUtilities() {
    }

    public static InputStream getInputStream(URLConnection c) throws IOException {
        Convention.throwIfNull(c, "URLConnection cannot be null");
        IOUtilities.optimizeConnection(c);
        String enc = c.getContentEncoding();
        InputStream is = c.getInputStream();
        if (enc != null) {
            if ("gzip".equalsIgnoreCase(enc) || "x-gzip".equalsIgnoreCase(enc)) {
                is = new GZIPInputStream(is, 32768);
            } else if ("deflate".equalsIgnoreCase(enc)) {
                is = new InflaterInputStream(is, new Inflater(), 32768);
            }
        }
        return new BufferedInputStream(is, 32768);
    }

    private static void optimizeConnection(URLConnection c) {
        if (c instanceof HttpURLConnection) {
            HttpURLConnection http = (HttpURLConnection)c;
            http.setInstanceFollowRedirects(true);
            http.setUseCaches(false);
            http.setConnectTimeout(5000);
            http.setReadTimeout(30000);
            c.setRequestProperty("Accept-Encoding", "gzip, x-gzip, deflate");
        }
    }

    public static void transfer(File f, URLConnection c, TransferCallback cb) throws Exception {
        Convention.throwIfNull(f, "File cannot be null");
        Convention.throwIfNull(c, "URLConnection cannot be null");
        try (BufferedInputStream in = new BufferedInputStream(Files.newInputStream(f.toPath(), new OpenOption[0]));
             BufferedOutputStream out = new BufferedOutputStream(c.getOutputStream());){
            IOUtilities.transfer((InputStream)in, out, cb);
        }
    }

    public static void transfer(URLConnection c, File f, TransferCallback cb) throws Exception {
        Convention.throwIfNull(c, "URLConnection cannot be null");
        Convention.throwIfNull(f, "File cannot be null");
        try (InputStream in = IOUtilities.getInputStream(c);){
            IOUtilities.transfer(in, f, cb);
        }
    }

    public static void transfer(InputStream s, File f, TransferCallback cb) throws Exception {
        Convention.throwIfNull(s, "InputStream cannot be null");
        Convention.throwIfNull(f, "File cannot be null");
        try (BufferedOutputStream out = new BufferedOutputStream(Files.newOutputStream(f.toPath(), new OpenOption[0]));){
            IOUtilities.transfer(s, out, cb);
        }
    }

    public static void transfer(InputStream in, OutputStream out, TransferCallback cb) throws IOException {
        int count;
        Convention.throwIfNull(in, "InputStream cannot be null");
        Convention.throwIfNull(out, "OutputStream cannot be null");
        byte[] buffer = new byte[32768];
        while ((count = in.read(buffer)) != -1) {
            out.write(buffer, 0, count);
            if (cb == null) continue;
            cb.bytesTransferred(buffer, count);
            if (!cb.isCancelled()) continue;
            break;
        }
    }

    public static void transfer(InputStream in, byte[] bytes) throws IOException {
        Convention.throwIfNull(in, "InputStream cannot be null");
        Convention.throwIfNull(bytes, "byte array cannot be null");
        new DataInputStream(in).readFully(bytes);
    }

    public static void transfer(InputStream in, OutputStream out) throws IOException {
        int count;
        Convention.throwIfNull(in, "InputStream cannot be null");
        Convention.throwIfNull(out, "OutputStream cannot be null");
        byte[] buffer = new byte[32768];
        while ((count = in.read(buffer)) != -1) {
            out.write(buffer, 0, count);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void transfer(File file, OutputStream out) throws IOException {
        Convention.throwIfNull(file, "File cannot be null");
        Convention.throwIfNull(out, "OutputStream cannot be null");
        try (BufferedInputStream in = new BufferedInputStream(Files.newInputStream(file.toPath(), new OpenOption[0]), 32768);){
            IOUtilities.transfer((InputStream)in, out);
        }
        finally {
            IOUtilities.flush(out);
        }
    }

    public static void close(XMLStreamReader reader) {
        if (reader != null) {
            try {
                reader.close();
            }
            catch (XMLStreamException xMLStreamException) {
                // empty catch block
            }
        }
    }

    public static void close(XMLStreamWriter writer) {
        if (writer != null) {
            try {
                writer.close();
            }
            catch (XMLStreamException xMLStreamException) {
                // empty catch block
            }
        }
    }

    public static void close(Closeable c) {
        if (c != null) {
            try {
                c.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void flush(Flushable f) {
        if (f != null) {
            try {
                f.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void flush(XMLStreamWriter writer) {
        if (writer != null) {
            try {
                writer.flush();
            }
            catch (XMLStreamException xMLStreamException) {
                // empty catch block
            }
        }
    }

    public static byte[] inputStreamToBytes(InputStream in) {
        byte[] byArray;
        Convention.throwIfNull(in, "Inputstream cannot be null");
        FastByteArrayOutputStream out = new FastByteArrayOutputStream(16384);
        try {
            IOUtilities.transfer(in, (OutputStream)out);
            byArray = out.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    out.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                return null;
            }
        }
        out.close();
        return byArray;
    }

    public static void transfer(URLConnection c, byte[] bytes) throws IOException {
        Convention.throwIfNull(c, "URLConnection cannot be null");
        Convention.throwIfNull(bytes, "byte array cannot be null");
        try (BufferedOutputStream out = new BufferedOutputStream(c.getOutputStream());){
            ((OutputStream)out).write(bytes);
        }
    }

    public static void compressBytes(ByteArrayOutputStream original, ByteArrayOutputStream compressed) throws IOException {
        Convention.throwIfNull(original, "Original ByteArrayOutputStream cannot be null");
        Convention.throwIfNull(compressed, "Compressed ByteArrayOutputStream cannot be null");
        try (AdjustableGZIPOutputStream gzipStream = new AdjustableGZIPOutputStream((OutputStream)compressed, 1);){
            original.writeTo(gzipStream);
            gzipStream.flush();
        }
    }

    public static void compressBytes(FastByteArrayOutputStream original, FastByteArrayOutputStream compressed) throws IOException {
        Convention.throwIfNull(original, "Original FastByteArrayOutputStream cannot be null");
        Convention.throwIfNull(compressed, "Compressed FastByteArrayOutputStream cannot be null");
        try (AdjustableGZIPOutputStream gzipStream = new AdjustableGZIPOutputStream((OutputStream)compressed, 1);){
            ((DeflaterOutputStream)gzipStream).write(original.toByteArray(), 0, original.size());
            gzipStream.flush();
        }
    }

    public static byte[] compressBytes(byte[] bytes) {
        return IOUtilities.compressBytes(bytes, 0, bytes.length);
    }

    public static byte[] compressBytes(byte[] bytes, int offset, int len) {
        byte[] byArray;
        Convention.throwIfNull(bytes, "Byte array cannot be null");
        FastByteArrayOutputStream byteStream = new FastByteArrayOutputStream();
        try {
            try (AdjustableGZIPOutputStream gzipStream = new AdjustableGZIPOutputStream((OutputStream)byteStream, 1);){
                ((DeflaterOutputStream)gzipStream).write(bytes, offset, len);
                gzipStream.flush();
            }
            byArray = Arrays.copyOf(byteStream.toByteArray(), byteStream.size());
        }
        catch (Throwable throwable) {
            try {
                try {
                    byteStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new RuntimeException("Error compressing bytes.", e);
            }
        }
        byteStream.close();
        return byArray;
    }

    public static byte[] uncompressBytes(byte[] bytes) {
        return IOUtilities.uncompressBytes(bytes, 0, bytes.length);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static byte[] uncompressBytes(byte[] bytes, int offset, int len) {
        Objects.requireNonNull(bytes, "Byte array cannot be null");
        if (ByteUtilities.isGzipped(bytes)) {
            try (ByteArrayInputStream byteStream = new ByteArrayInputStream(bytes, offset, len);){
                byte[] byArray;
                try (GZIPInputStream gzipStream = new GZIPInputStream((InputStream)byteStream, 32768);){
                    byArray = IOUtilities.inputStreamToBytes(gzipStream);
                }
                return byArray;
            }
            catch (Exception e) {
                throw new RuntimeException("Error uncompressing bytes", e);
            }
        }
        return bytes;
    }

    @FunctionalInterface
    public static interface TransferCallback {
        public void bytesTransferred(byte[] var1, int var2);

        default public boolean isCancelled() {
            return false;
        }
    }
}

