/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util.convert;

import com.cedarsoftware.util.convert.Converter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

final class CharacterConversions {
    private CharacterConversions() {
    }

    static String toString(Object from, Converter converter) {
        return "" + from;
    }

    static boolean toBoolean(Object from, Converter converter) {
        char c = ((Character)from).charValue();
        return c == '\u0001' || c == 't' || c == 'T' || c == '1' || c == 'y' || c == 'Y';
    }

    static byte toByte(Object from, Converter converter) {
        return (byte)((Character)from).charValue();
    }

    static short toShort(Object from, Converter converter) {
        return (short)((Character)from).charValue();
    }

    static int toInt(Object from, Converter converter) {
        return ((Character)from).charValue();
    }

    static long toLong(Object from, Converter converter) {
        return ((Character)from).charValue();
    }

    static float toFloat(Object from, Converter converter) {
        return ((Character)from).charValue();
    }

    static double toDouble(Object from, Converter converter) {
        return ((Character)from).charValue();
    }

    static AtomicInteger toAtomicInteger(Object from, Converter converter) {
        return new AtomicInteger(((Character)from).charValue());
    }

    static AtomicLong toAtomicLong(Object from, Converter converter) {
        return new AtomicLong(((Character)from).charValue());
    }

    static AtomicBoolean toAtomicBoolean(Object from, Converter converter) {
        return new AtomicBoolean(CharacterConversions.toBoolean(from, converter));
    }

    static BigInteger toBigInteger(Object from, Converter converter) {
        return BigInteger.valueOf(((Character)from).charValue());
    }

    static BigDecimal toBigDecimal(Object from, Converter converter) {
        return BigDecimal.valueOf(((Character)from).charValue());
    }
}

