/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util.convert;

import com.cedarsoftware.util.ArrayUtilities;
import com.cedarsoftware.util.convert.CharBufferConversions;
import com.cedarsoftware.util.convert.Converter;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;

final class ByteBufferConversions {
    private ByteBufferConversions() {
    }

    static CharBuffer toCharBuffer(Object from, Converter converter) {
        ByteBuffer buffer = ByteBufferConversions.toByteBuffer(from, converter);
        return converter.getOptions().getCharset().decode(buffer);
    }

    static ByteBuffer toByteBuffer(Object from, Converter converter) {
        return ((ByteBuffer)from).asReadOnlyBuffer();
    }

    static byte[] toByteArray(Object from, Converter converter) {
        ByteBuffer buffer = ByteBufferConversions.toByteBuffer(from, converter);
        if (buffer == null || !buffer.hasRemaining()) {
            return ArrayUtilities.EMPTY_BYTE_ARRAY;
        }
        byte[] bytes = new byte[buffer.remaining()];
        buffer.get(bytes);
        return bytes;
    }

    static String toString(Object from, Converter converter) {
        return ByteBufferConversions.toCharBuffer(from, converter).toString();
    }

    static char[] toCharArray(Object from, Converter converter) {
        return CharBufferConversions.toCharArray(ByteBufferConversions.toCharBuffer(from, converter), converter);
    }

    static StringBuffer toStringBuffer(Object from, Converter converter) {
        return new StringBuffer(ByteBufferConversions.toCharBuffer(from, converter));
    }

    static StringBuilder toStringBuilder(Object from, Converter converter) {
        return new StringBuilder(ByteBufferConversions.toCharBuffer(from, converter));
    }
}

