/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util;

import com.cedarsoftware.util.StreamGobbler;
import java.io.File;

public class Executor {
    private String _error;
    private String _out;

    public int exec(String command) {
        try {
            Process proc = Runtime.getRuntime().exec(command);
            return this.runIt(proc);
        }
        catch (Exception e) {
            System.err.println("Error occurred executing command: " + command);
            e.printStackTrace(System.err);
            return -1;
        }
    }

    public int exec(String[] cmdarray) {
        try {
            Process proc = Runtime.getRuntime().exec(cmdarray);
            return this.runIt(proc);
        }
        catch (Exception e) {
            System.err.println("Error occurred executing command: " + this.cmdArrayToString(cmdarray));
            e.printStackTrace(System.err);
            return -1;
        }
    }

    public int exec(String command, String[] envp) {
        try {
            Process proc = Runtime.getRuntime().exec(command, envp);
            return this.runIt(proc);
        }
        catch (Exception e) {
            System.err.println("Error occurred executing command: " + command);
            e.printStackTrace(System.err);
            return -1;
        }
    }

    public int exec(String[] cmdarray, String[] envp) {
        try {
            Process proc = Runtime.getRuntime().exec(cmdarray, envp);
            return this.runIt(proc);
        }
        catch (Exception e) {
            System.err.println("Error occurred executing command: " + this.cmdArrayToString(cmdarray));
            e.printStackTrace(System.err);
            return -1;
        }
    }

    public int exec(String command, String[] envp, File dir) {
        try {
            Process proc = Runtime.getRuntime().exec(command, envp, dir);
            return this.runIt(proc);
        }
        catch (Exception e) {
            System.err.println("Error occurred executing command: " + command);
            e.printStackTrace(System.err);
            return -1;
        }
    }

    public int exec(String[] cmdarray, String[] envp, File dir) {
        try {
            Process proc = Runtime.getRuntime().exec(cmdarray, envp, dir);
            return this.runIt(proc);
        }
        catch (Exception e) {
            System.err.println("Error occurred executing command: " + this.cmdArrayToString(cmdarray));
            e.printStackTrace(System.err);
            return -1;
        }
    }

    private int runIt(Process proc) throws InterruptedException {
        StreamGobbler errors = new StreamGobbler(proc.getErrorStream());
        Thread errorGobbler = new Thread(errors);
        StreamGobbler out = new StreamGobbler(proc.getInputStream());
        Thread outputGobbler = new Thread(out);
        errorGobbler.start();
        outputGobbler.start();
        int exitVal = proc.waitFor();
        errorGobbler.join();
        outputGobbler.join();
        this._error = errors.getResult();
        this._out = out.getResult();
        return exitVal;
    }

    public String getError() {
        return this._error;
    }

    public String getOut() {
        return this._out;
    }

    private String cmdArrayToString(String[] cmdArray) {
        StringBuilder s = new StringBuilder();
        for (String cmd : cmdArray) {
            s.append(cmd);
            s.append(' ');
        }
        return s.toString();
    }
}

