/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util;

import com.cedarsoftware.util.SealableSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableSet;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.function.Supplier;

public class SealableNavigableSet<T>
implements NavigableSet<T> {
    private final NavigableSet<T> navSet;
    private final transient Supplier<Boolean> sealedSupplier;

    public SealableNavigableSet(Supplier<Boolean> sealedSupplier) {
        this.sealedSupplier = sealedSupplier;
        this.navSet = new ConcurrentSkipListSet<T>();
    }

    public SealableNavigableSet(Comparator<? super T> comparator, Supplier<Boolean> sealedSupplier) {
        this.sealedSupplier = sealedSupplier;
        this.navSet = new ConcurrentSkipListSet<T>(comparator);
    }

    public SealableNavigableSet(Collection<? extends T> col, Supplier<Boolean> sealedSupplier) {
        this(sealedSupplier);
        this.addAll(col);
    }

    public SealableNavigableSet(SortedSet<T> set, Supplier<Boolean> sealedSupplier) {
        this.sealedSupplier = sealedSupplier;
        this.navSet = new ConcurrentSkipListSet<T>(set);
    }

    public SealableNavigableSet(NavigableSet<T> set, Supplier<Boolean> sealedSupplier) {
        this.sealedSupplier = sealedSupplier;
        this.navSet = set;
    }

    private void throwIfSealed() {
        if (this.sealedSupplier.get().booleanValue()) {
            throw new UnsupportedOperationException("This set has been sealed and is now immutable");
        }
    }

    @Override
    public boolean equals(Object o) {
        return o == this || this.navSet.equals(o);
    }

    @Override
    public int hashCode() {
        return this.navSet.hashCode();
    }

    public String toString() {
        return this.navSet.toString();
    }

    @Override
    public int size() {
        return this.navSet.size();
    }

    @Override
    public boolean isEmpty() {
        return this.navSet.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.navSet.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> col) {
        return this.navSet.containsAll(col);
    }

    @Override
    public Comparator<? super T> comparator() {
        return this.navSet.comparator();
    }

    @Override
    public T first() {
        return (T)this.navSet.first();
    }

    @Override
    public T last() {
        return (T)this.navSet.last();
    }

    @Override
    public Object[] toArray() {
        return this.navSet.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.navSet.toArray(a);
    }

    @Override
    public T lower(T e) {
        return this.navSet.lower(e);
    }

    @Override
    public T floor(T e) {
        return this.navSet.floor(e);
    }

    @Override
    public T ceiling(T e) {
        return this.navSet.ceiling(e);
    }

    @Override
    public T higher(T e) {
        return this.navSet.higher(e);
    }

    @Override
    public Iterator<T> iterator() {
        return this.createSealHonoringIterator(this.navSet.iterator());
    }

    @Override
    public Iterator<T> descendingIterator() {
        return this.createSealHonoringIterator(this.navSet.descendingIterator());
    }

    @Override
    public NavigableSet<T> descendingSet() {
        return new SealableNavigableSet<T>(this.navSet.descendingSet(), this.sealedSupplier);
    }

    @Override
    public SortedSet<T> subSet(T fromElement, T toElement) {
        return this.subSet(fromElement, true, toElement, false);
    }

    @Override
    public NavigableSet<T> subSet(T fromElement, boolean fromInclusive, T toElement, boolean toInclusive) {
        return new SealableNavigableSet<T>(this.navSet.subSet(fromElement, fromInclusive, toElement, toInclusive), this.sealedSupplier);
    }

    @Override
    public SortedSet<T> headSet(T toElement) {
        return this.headSet(toElement, false);
    }

    @Override
    public NavigableSet<T> headSet(T toElement, boolean inclusive) {
        return new SealableNavigableSet<T>(this.navSet.headSet(toElement, inclusive), this.sealedSupplier);
    }

    @Override
    public SortedSet<T> tailSet(T fromElement) {
        return this.tailSet(fromElement, false);
    }

    @Override
    public NavigableSet<T> tailSet(T fromElement, boolean inclusive) {
        return new SealableNavigableSet<T>(this.navSet.tailSet(fromElement, inclusive), this.sealedSupplier);
    }

    @Override
    public boolean add(T e) {
        this.throwIfSealed();
        return this.navSet.add(e);
    }

    @Override
    public boolean addAll(Collection<? extends T> col) {
        this.throwIfSealed();
        return this.navSet.addAll(col);
    }

    @Override
    public void clear() {
        this.throwIfSealed();
        this.navSet.clear();
    }

    @Override
    public boolean remove(Object o) {
        this.throwIfSealed();
        return this.navSet.remove(o);
    }

    @Override
    public boolean removeAll(Collection<?> col) {
        this.throwIfSealed();
        return this.navSet.removeAll(col);
    }

    @Override
    public boolean retainAll(Collection<?> col) {
        this.throwIfSealed();
        return this.navSet.retainAll(col);
    }

    @Override
    public T pollFirst() {
        this.throwIfSealed();
        return this.navSet.pollFirst();
    }

    @Override
    public T pollLast() {
        this.throwIfSealed();
        return this.navSet.pollLast();
    }

    private Iterator<T> createSealHonoringIterator(final Iterator<T> iterator) {
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public T next() {
                Object item = iterator.next();
                if (item instanceof Map.Entry) {
                    Map.Entry entry = (Map.Entry)item;
                    return new SealableSet.SealAwareEntry(entry, SealableNavigableSet.this.sealedSupplier);
                }
                return item;
            }

            @Override
            public void remove() {
                SealableNavigableSet.this.throwIfSealed();
                iterator.remove();
            }
        };
    }
}

