/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoft.test.utils.matchers;

import com.cedarsoft.test.utils.matchers.ContainsFileMatcher;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;

public class ContainsOnlyFilesMatcher
extends BaseMatcher<File> {
    @Nonnull
    private final List<String> filePaths;

    public ContainsOnlyFilesMatcher(String ... relativeFilePaths) {
        this.filePaths = new ArrayList<String>(Arrays.asList(relativeFilePaths));
    }

    public boolean matches(Object o) {
        File dir = (File)o;
        if (!((File)o).isDirectory()) {
            return false;
        }
        Collection files = FileUtils.listFiles((File)dir, (IOFileFilter)TrueFileFilter.INSTANCE, (IOFileFilter)TrueFileFilter.INSTANCE);
        if (files.size() != this.filePaths.size()) {
            return false;
        }
        Set<? extends File> expected = this.createExepectedSet(dir);
        for (File file : files) {
            if (expected.contains(file)) continue;
            return false;
        }
        return true;
    }

    @Nonnull
    private Set<? extends File> createExepectedSet(@Nonnull File baseDir) {
        HashSet<File> expected = new HashSet<File>();
        for (String filePath : this.filePaths) {
            expected.add(new File(baseDir, filePath));
        }
        return expected;
    }

    public void describeTo(Description description) {
        description.appendText("contains only files " + this.filePaths);
    }

    @Nonnull
    public List<? extends String> getFilePaths() {
        return Collections.unmodifiableList(this.filePaths);
    }

    @Nonnull
    public static Matcher<File> containsOnlyFiles(String ... relativeFilePaths) {
        return new ContainsOnlyFilesMatcher(relativeFilePaths);
    }

    @Nonnull
    public static String toTree(@Nonnull File dir) {
        return ContainsFileMatcher.toTree(dir);
    }
}

