/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoft.test.utils.matchers;

import com.cedarsoft.test.utils.matchers.AndMatcher;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;

public class ContainsFileMatcher
extends BaseMatcher<File> {
    @Nonnull
    private final String relativeFilePath;

    public ContainsFileMatcher(@Nonnull String relativeFilePath) {
        this.relativeFilePath = relativeFilePath;
    }

    public boolean matches(Object o) {
        File file = (File)o;
        if (!file.isDirectory()) {
            return false;
        }
        File searched = new File(file, this.relativeFilePath);
        return searched.isFile();
    }

    public void describeTo(Description description) {
        description.appendText("contains file ");
        description.appendValue((Object)this.relativeFilePath);
    }

    @Nonnull
    public static ContainsFileMatcher containsFile(@Nonnull String relativeFilePath) {
        return new ContainsFileMatcher(relativeFilePath);
    }

    @Nonnull
    public static Matcher<File> empty() {
        return new BaseMatcher<File>(){

            public boolean matches(Object o) {
                return ((File)o).list().length == 0;
            }

            public void describeTo(Description description) {
                description.appendText("empty");
            }
        };
    }

    @Nonnull
    public static Matcher<File> containsFiles(String ... relativeFilePaths) {
        ArrayList<ContainsFileMatcher> matchers = new ArrayList<ContainsFileMatcher>();
        for (String relativeFilePath : relativeFilePaths) {
            matchers.add(ContainsFileMatcher.containsFile(relativeFilePath));
        }
        return new AndMatcher(matchers);
    }

    @Nonnull
    public static String toTree(final @Nonnull File dir) {
        ArrayList files = Lists.newArrayList((Iterator)FileUtils.iterateFiles((File)dir, (IOFileFilter)TrueFileFilter.TRUE, (IOFileFilter)TrueFileFilter.TRUE));
        ArrayList names = Lists.newArrayList((Iterable)Lists.transform((List)files, (Function)new Function<File, String>(){

            public String apply(File from) {
                return from.getPath().substring(dir.getPath().length() + 1);
            }
        }));
        Collections.sort(names);
        Joiner joiner = Joiner.on((String)"\n");
        return joiner.join((Iterable)names);
    }

    @Nonnull
    public static String toMessage(@Nonnull File dir) {
        return dir.getAbsolutePath() + ":\n" + ContainsFileMatcher.toTree(dir);
    }
}

