/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoft.test.utils;

import com.google.common.base.Joiner;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class ThreadRule
implements TestRule {
    public static final String STACK_TRACE_ELEMENT_SEPARATOR = "\n\tat ";
    @Nullable
    private final ThreadMatcher ignoredThreadMatcher;
    private Collection<Thread> initialThreads;

    public ThreadRule() {
        this(new DefaultThreadMatcher());
    }

    public ThreadRule(@Nullable ThreadMatcher ignoredThreadMatcher) {
        this.ignoredThreadMatcher = ignoredThreadMatcher;
    }

    public Statement apply(final Statement base, Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                ThreadRule.this.before();
                try {
                    base.evaluate();
                }
                catch (Throwable t) {
                    ThreadRule.this.afterFailing();
                    throw t;
                }
                ThreadRule.this.after();
            }
        };
    }

    private void before() {
        if (this.initialThreads != null) {
            throw new IllegalStateException("???");
        }
        this.initialThreads = Thread.getAllStackTraces().keySet();
    }

    @Nonnull
    public Collection<? extends Thread> getInitialThreads() {
        if (this.initialThreads == null) {
            throw new IllegalStateException("not initialized yet");
        }
        return Collections.unmodifiableCollection(this.initialThreads);
    }

    private void afterFailing() {
        Set<? extends Thread> remainingThreads = this.getRemainingThreads();
        if (!remainingThreads.isEmpty()) {
            System.err.print("Some threads have been left:\n" + this.buildMessage(remainingThreads));
        }
    }

    private void after() {
        Set<? extends Thread> remainingThreads = this.getRemainingThreads();
        if (!remainingThreads.isEmpty()) {
            throw new IllegalStateException("Some threads have been left:\n" + this.buildMessage(remainingThreads));
        }
    }

    @Nonnull
    public Set<? extends Thread> getRemainingThreads() {
        Set<Thread> threadsNow = Thread.getAllStackTraces().keySet();
        HashSet<Thread> remainingThreads = new HashSet<Thread>(threadsNow);
        remainingThreads.removeAll(this.initialThreads);
        Iterator iterator = remainingThreads.iterator();
        while (iterator.hasNext()) {
            Thread remainingThread = (Thread)iterator.next();
            if (!remainingThread.isAlive()) {
                iterator.remove();
                continue;
            }
            if (this.ignoredThreadMatcher != null && this.ignoredThreadMatcher.shallIgnore(remainingThread)) {
                iterator.remove();
                continue;
            }
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException ignore) {
                // empty catch block
            }
            if (remainingThread.isAlive()) continue;
            iterator.remove();
        }
        return remainingThreads;
    }

    @Nonnull
    private String buildMessage(@Nonnull Set<? extends Thread> remainingThreads) {
        StringBuilder builder = new StringBuilder();
        builder.append("// Remaining Threads:").append("\n");
        builder.append("-----------------------").append("\n");
        for (Thread thread : remainingThreads) {
            builder.append("---");
            builder.append("\n");
            builder.append(thread);
            builder.append(STACK_TRACE_ELEMENT_SEPARATOR);
            builder.append(Joiner.on((String)STACK_TRACE_ELEMENT_SEPARATOR).join((Object[])thread.getStackTrace()));
            builder.append("\n");
        }
        builder.append("-----------------------").append("\n");
        return builder.toString();
    }

    public static class DefaultThreadMatcher
    implements ThreadMatcher {
        @Override
        public boolean shallIgnore(@Nonnull Thread remainingThread) {
            return remainingThread.getThreadGroup().getName().equals("system") && remainingThread.getName().equals("Keep-Alive-Timer") || remainingThread.getThreadGroup().getName().equals("system") && remainingThread.getName().equals("process reaper") || remainingThread.getThreadGroup().getName().equals("system") && remainingThread.getName().equals("Keep-Alive-SocketCleaner") || remainingThread.getThreadGroup().getName().equals("system") && remainingThread.getName().equals("Java2D Disposer") || remainingThread.getThreadGroup().getName().equals("system") && remainingThread.getName().equals("AWT-XAWT") || remainingThread.getThreadGroup().getName().equals("main") && remainingThread.getName().equals("AWT-Shutdown") || remainingThread.getThreadGroup().getName().equals("main") && remainingThread.getName().equals("AWT-Windows") || remainingThread.getThreadGroup().getName().equals("main") && remainingThread.getName().startsWith("QuantumRenderer");
        }
    }

    public static interface ThreadMatcher {
        public boolean shallIgnore(@Nonnull Thread var1);
    }
}

