/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoft.test.utils;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.io.IOUtils;

public class TestUtils {
    private TestUtils() {
    }

    public static void cleanupFields(@Nullable Object test) throws IllegalAccessException {
        if (test == null) {
            return;
        }
        for (Field field : test.getClass().getDeclaredFields()) {
            if (Modifier.isFinal(field.getModifiers())) continue;
            field.setAccessible(true);
            field.set(test, null);
        }
    }

    @Nonnull
    public static File getTmpDir() {
        return new File(System.getProperty("java.io.tmpdir"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    @Nonnull
    public static File createTmpFile(@Nonnull String prefix, @Nonnull String suffix, @Nonnull InputStream in) throws IOException {
        File file = File.createTempFile(prefix, suffix);
        file.deleteOnExit();
        FileOutputStream out = new FileOutputStream(file);
        try {
            IOUtils.copy((InputStream)in, (OutputStream)out);
        }
        finally {
            out.close();
        }
        return file;
    }

    @Deprecated
    @Nonnull
    public static File createEmptyTmpDir() {
        File tmp = TestUtils.getTmpDir();
        File dir = null;
        while (dir == null || dir.exists()) {
            dir = new File(tmp, String.valueOf((int)(Math.random() * 1000000.0)));
        }
        dir.mkdir();
        return dir;
    }
}

