/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoft.test.utils;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import javax.annotation.Nonnull;
import org.junit.rules.MethodRule;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.Statement;

public class SystemOutRule
implements MethodRule {
    @Nonnull
    private final ByteArrayOutputStream newOut = new ByteArrayOutputStream();
    private PrintStream oldOut;
    @Nonnull
    private final ByteArrayOutputStream newErr = new ByteArrayOutputStream();
    private PrintStream oldErr;

    public Statement apply(final Statement base, FrameworkMethod method, Object target) {
        return new Statement(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void evaluate() throws Throwable {
                SystemOutRule.this.before();
                try {
                    base.evaluate();
                }
                finally {
                    SystemOutRule.this.after();
                }
            }
        };
    }

    protected void before() {
        if (this.oldOut != null) {
            throw new IllegalStateException("oldOut is not null: " + this.oldOut);
        }
        this.oldOut = System.out;
        System.setOut(new PrintStream(this.newOut));
        if (this.oldErr != null) {
            throw new IllegalStateException("oldErr is not null: " + this.oldErr);
        }
        this.oldErr = System.err;
        System.setErr(new PrintStream(this.newErr));
    }

    protected void after() {
        System.setOut(this.oldOut);
        this.oldOut = null;
    }

    @Nonnull
    public String getOutAsString() {
        return this.newOut.toString();
    }

    @Nonnull
    public String getErrAsString() {
        return this.newErr.toString();
    }

    @Nonnull
    public PrintStream getOldOut() {
        if (this.oldOut == null) {
            throw new IllegalStateException("old out is null. Rule not activated");
        }
        return this.oldOut;
    }

    @Nonnull
    public PrintStream getOldErr() {
        if (this.oldErr == null) {
            throw new IllegalStateException("oldErr is null. Rule not activated");
        }
        return this.oldErr;
    }
}

