/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoft.test.utils;

import java.lang.reflect.Field;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ReflectionToString {
    private ReflectionToString() {
    }

    @Nonnull
    public static String toString(@Nullable Object object) {
        if (object == null) {
            return "<null>";
        }
        StringBuilder builder = new StringBuilder();
        builder.append(object.getClass().getName()).append(" {\n");
        for (Class<?> daClass = object.getClass(); daClass != null; daClass = daClass.getSuperclass()) {
            for (Field field : daClass.getDeclaredFields()) {
                field.setAccessible(true);
                builder.append("\t");
                builder.append(field.getName()).append(": ");
                try {
                    builder.append(field.get(object));
                }
                catch (IllegalAccessException e) {
                    builder.append("<failed due to ").append(e.getMessage()).append(">");
                }
                builder.append("\n");
            }
        }
        builder.append("}");
        return builder.toString();
    }
}

