/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoft.test.utils;

import java.awt.EventQueue;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.fest.assertions.Assertions;
import org.fest.assertions.ObjectAssert;

public class MemoryLeakVerifier<T> {
    private static final int MAX_GC_ITERATIONS = 50;
    private static final int GC_SLEEP_TIME = 100;
    @Nonnull
    private final WeakReference<T> reference;

    public MemoryLeakVerifier(@Nonnull T object) {
        this.reference = new WeakReference<T>(object);
    }

    @Nonnull
    public WeakReference<T> getReference() {
        return this.reference;
    }

    @Nullable
    public Object getObject() {
        return this.reference.get();
    }

    public void assertGarbageCollected() {
        Runtime runtime = Runtime.getRuntime();
        for (int i = 0; i < 50; ++i) {
            runtime.runFinalization();
            runtime.gc();
            if (this.getObject() == null) break;
            try {
                EventQueue.invokeAndWait(new NoOp());
                Thread.sleep(100L);
                continue;
            }
            catch (InterruptedException ignore) {
                continue;
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        ((ObjectAssert)Assertions.assertThat((Object)this.getObject()).describedAs("object should not exist after 50 collections")).isNull();
    }

    private static class NoOp
    implements Runnable {
        private NoOp() {
        }

        @Override
        public void run() {
        }
    }
}

