/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoft.test.utils;

import java.util.Locale;
import javax.annotation.Nonnull;
import org.junit.rules.MethodRule;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.Statement;

public class LocaleRule
implements MethodRule {
    @Nonnull
    protected final Locale locale;
    private Locale oldLocale;

    public LocaleRule() throws IllegalArgumentException {
        this(Locale.US);
    }

    public LocaleRule(@Nonnull Locale locale) {
        this.locale = locale;
    }

    public Statement apply(final Statement base, FrameworkMethod method, Object target) {
        return new Statement(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void evaluate() throws Throwable {
                LocaleRule.this.before();
                try {
                    base.evaluate();
                }
                finally {
                    LocaleRule.this.after();
                }
            }
        };
    }

    private void before() {
        this.oldLocale = Locale.getDefault();
        Locale.setDefault(this.locale);
    }

    private void after() {
        Locale.setDefault(this.oldLocale);
    }

    @Nonnull
    public Locale getLocale() {
        return this.locale;
    }

    public Locale getOldLocale() {
        return this.oldLocale;
    }
}

