/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoft.test.utils;

import com.cedarsoft.test.utils.AssertUtils;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Charsets;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.Charset;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.junit.ComparisonFailure;
import org.xml.sax.SAXException;

public class JsonUtils {
    private JsonUtils() {
    }

    public static void assertJsonEquals(@Nonnull URL control, @Nullable String test) throws SAXException, IOException {
        JsonUtils.assertJsonEquals(control, test, Charsets.UTF_8);
    }

    public static void assertJsonEquals(@Nonnull URL control, @Nullable String test, @Nonnull Charset charset) throws SAXException, IOException {
        JsonUtils.assertJsonEquals(AssertUtils.toString(control, charset), test);
    }

    public static void assertJsonEquals(@Nullable String control, @Nullable String test) throws IOException {
        if (test == null || test.trim().isEmpty()) {
            throw new ComparisonFailure("Empty test json", JsonUtils.formatJson(control).trim(), JsonUtils.formatJson(test).trim());
        }
        if (control == null || control.trim().isEmpty()) {
            throw new ComparisonFailure("Empty control json", JsonUtils.formatJson(control).trim(), JsonUtils.formatJson(test).trim());
        }
        try {
            ObjectMapper mapper = new ObjectMapper();
            JsonNode testTree = mapper.readTree(test);
            JsonNode controlTree = mapper.readTree(control);
            if (!controlTree.equals((Object)testTree)) {
                throw new ComparisonFailure("JSON comparison failed", JsonUtils.formatJson(control).trim(), JsonUtils.formatJson(test).trim());
            }
        }
        catch (JsonProcessingException e) {
            throw new ComparisonFailure("JSON parsing error (" + e.getMessage() + ")", JsonUtils.formatJson(control).trim(), JsonUtils.formatJson(test).trim());
        }
    }

    @Deprecated
    public static void assertJsonEquals(@Nullable String err, @Nullable String control, @Nullable String test) throws IOException, ComparisonFailure {
        JsonUtils.assertJsonEquals(control, test);
    }

    @Nonnull
    public static String formatJson(@Nullable String unformated) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            JsonNode tree = mapper.readTree(unformated);
            StringWriter out = new StringWriter();
            JsonGenerator jsonGenerator = mapper.getJsonFactory().createJsonGenerator((Writer)out);
            jsonGenerator.useDefaultPrettyPrinter();
            jsonGenerator.writeTree((TreeNode)tree);
            return out.toString();
        }
        catch (Exception ignore) {
            return String.valueOf(unformated);
        }
    }
}

