/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoft.test.utils;

import javax.annotation.Nonnull;
import org.joda.time.DateTimeZone;
import org.junit.rules.MethodRule;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.Statement;

public class DateTimeZoneRule
implements MethodRule {
    @Nonnull
    protected final DateTimeZone zone;
    private DateTimeZone oldTimeZone;

    public DateTimeZoneRule() throws IllegalArgumentException {
        this("America/New_York");
    }

    public DateTimeZoneRule(@Nonnull String zoneId) throws IllegalArgumentException {
        this(DateTimeZone.forID((String)zoneId));
    }

    public DateTimeZoneRule(@Nonnull DateTimeZone zone) {
        this.zone = zone;
    }

    public Statement apply(final Statement base, FrameworkMethod method, Object target) {
        return new Statement(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void evaluate() throws Throwable {
                DateTimeZoneRule.this.before();
                try {
                    base.evaluate();
                }
                finally {
                    DateTimeZoneRule.this.after();
                }
            }
        };
    }

    private void before() {
        this.oldTimeZone = DateTimeZone.getDefault();
        DateTimeZone.setDefault((DateTimeZone)this.zone);
    }

    private void after() {
        DateTimeZone.setDefault((DateTimeZone)this.oldTimeZone);
    }

    @Nonnull
    public DateTimeZone getZone() {
        return this.zone;
    }

    @Nonnull
    public DateTimeZone getOldTimeZone() {
        if (this.oldTimeZone == null) {
            throw new IllegalStateException("No old zone set");
        }
        return this.oldTimeZone;
    }
}

