/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoft.test.utils;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class CatchAllExceptionsRule
implements TestRule {
    @Nullable
    private Thread.UncaughtExceptionHandler oldHandler;
    @Nonnull
    private final List<Throwable> caught = new ArrayList<Throwable>();

    public Statement apply(final Statement base, Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                CatchAllExceptionsRule.this.before();
                try {
                    base.evaluate();
                }
                catch (Throwable t) {
                    CatchAllExceptionsRule.this.afterFailing();
                    throw t;
                }
                CatchAllExceptionsRule.this.afterSuccess();
            }
        };
    }

    private void before() {
        this.oldHandler = Thread.getDefaultUncaughtExceptionHandler();
        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                CatchAllExceptionsRule.this.caught.add(e);
                if (CatchAllExceptionsRule.this.oldHandler != null) {
                    CatchAllExceptionsRule.this.oldHandler.uncaughtException(t, e);
                }
            }
        });
    }

    private void afterSuccess() {
        Thread.setDefaultUncaughtExceptionHandler(this.oldHandler);
        if (this.caught.isEmpty()) {
            return;
        }
        throw new AssertionError((Object)this.buildMessage());
    }

    private String buildMessage() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.caught.size()).append(" exceptions thrown but not caught in other threads:\n");
        for (Throwable throwable : this.caught) {
            builder.append("---------------------\n");
            StringWriter out = new StringWriter();
            throwable.printStackTrace(new PrintWriter(out));
            builder.append(out.toString());
        }
        builder.append("---------------------\n");
        return builder.toString();
    }

    private void afterFailing() {
        Thread.setDefaultUncaughtExceptionHandler(this.oldHandler);
    }
}

