/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoft.test.utils;

import com.cedarsoft.crypt.Algorithm;
import com.cedarsoft.crypt.Hash;
import com.cedarsoft.crypt.HashCalculator;
import com.cedarsoft.test.utils.TestUtils;
import com.cedarsoft.xml.XmlCommons;
import com.google.common.base.Charsets;
import com.google.common.io.ByteStreams;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import junit.framework.AssertionFailedError;
import org.apache.commons.io.FileUtils;
import org.custommonkey.xmlunit.XMLAssert;
import org.custommonkey.xmlunit.XMLUnit;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.AnyOf;
import org.junit.Assert;
import org.junit.ComparisonFailure;
import org.xml.sax.SAXException;

public class AssertUtils {
    @Nonnull
    public static final File FAILED_FILES_DIR = new File(TestUtils.getTmpDir(), "junit-failed-files");

    private AssertUtils() {
    }

    public static void setIgnoreWhitespace(boolean ignore) {
        XMLUnit.setIgnoreWhitespace((boolean)ignore);
    }

    public static void setIgnoreComments(boolean ignore) {
        XMLUnit.setIgnoreComments((boolean)ignore);
    }

    public static void assertXMLEquals(String control, String test) throws SAXException, IOException {
        AssertUtils.assertXMLEquals(control, test, true);
    }

    public static void assertXMLEquals(URL control, String test) throws SAXException, IOException {
        AssertUtils.assertXMLEquals(control, test, Charsets.UTF_8);
    }

    public static void assertXMLEquals(URL control, String test, @Nonnull Charset charset) throws SAXException, IOException {
        AssertUtils.assertXMLEquals(AssertUtils.toString(control, charset), test);
    }

    public static void assertXMLEquals(String control, String test, boolean ignoreWhiteSpace) throws SAXException, IOException {
        AssertUtils.assertXMLEquals(control, test, ignoreWhiteSpace, true);
    }

    public static void assertXMLEquals(URL control, String test, boolean ignoreWhiteSpace) throws SAXException, IOException {
        AssertUtils.assertXMLEquals(control, test, ignoreWhiteSpace, Charsets.UTF_8);
    }

    public static void assertXMLEquals(URL control, String test, boolean ignoreWhiteSpace, @Nonnull Charset charset) throws SAXException, IOException {
        AssertUtils.assertXMLEquals(AssertUtils.toString(control, charset), test, ignoreWhiteSpace);
    }

    @Deprecated
    public static void assertXMLEquals(@Nullable String err, @Nonnull String control, @Nonnull String test, boolean ignoreWhiteSpace) throws SAXException, IOException {
        AssertUtils.assertXMLEquals(control, test, ignoreWhiteSpace, true);
    }

    @Deprecated
    public static void assertXMLEquals(@Nullable String err, @Nonnull String control, @Nonnull String test, boolean ignoreWhiteSpace, boolean ignoreComments) throws SAXException, IOException {
        AssertUtils.assertXMLEquals(control, test, ignoreWhiteSpace, ignoreComments);
    }

    public static void assertXMLEquals(@Nonnull String control, @Nonnull String test, boolean ignoreWhiteSpace, boolean ignoreComments) throws IOException {
        if (test.trim().isEmpty()) {
            throw new ComparisonFailure("Empty test xml", AssertUtils.formatXml(control).trim(), AssertUtils.formatXml(test).trim());
        }
        if (control.trim().isEmpty()) {
            throw new ComparisonFailure("Empty control xml", AssertUtils.formatXml(control).trim(), AssertUtils.formatXml(test).trim());
        }
        try {
            AssertUtils.setIgnoreWhitespace(ignoreWhiteSpace);
            AssertUtils.setIgnoreComments(ignoreComments);
            XMLAssert.assertXMLEqual((String)control, (String)test);
            AssertUtils.setIgnoreWhitespace(false);
        }
        catch (SAXException e) {
            throw new ComparisonFailure("XML error (" + e.getMessage() + ")", AssertUtils.formatXml(control).trim(), AssertUtils.formatXml(test).trim());
        }
        catch (AssertionFailedError ignore) {
            throw new ComparisonFailure("XML comparison failed", AssertUtils.formatXml(control).trim(), AssertUtils.formatXml(test).trim());
        }
    }

    @Nonnull
    private static String formatXml(@Nonnull String control) {
        try {
            return XmlCommons.format((String)control);
        }
        catch (Exception ignore) {
            return control;
        }
    }

    @Deprecated
    public static void assertXMLEquals(@Nonnull String test, @Nonnull String err, @Nonnull URL control, boolean ignoreWhiteSpace) throws SAXException, IOException {
        AssertUtils.assertXMLEquals(test, err, control, ignoreWhiteSpace, Charsets.UTF_8);
    }

    @Deprecated
    public static void assertXMLEquals(@Nonnull String test, @Nonnull String err, @Nonnull URL control, boolean ignoreWhiteSpace, @Nonnull Charset charset) throws SAXException, IOException {
        AssertUtils.assertXMLEquals(err, AssertUtils.toString(control, charset), test, ignoreWhiteSpace);
    }

    public static <T> void assertOne(@Nullable T current, T ... expectedAlternatives) {
        ArrayList<Matcher> matchers = new ArrayList<Matcher>();
        for (T expectedAlternative : expectedAlternatives) {
            matchers.add(CoreMatchers.is(expectedAlternative));
        }
        AnyOf objectMatcher = CoreMatchers.anyOf(matchers);
        Assert.assertThat(current, (Matcher)objectMatcher);
    }

    public static void assertEquals(@Nonnull URL expectedResourceUri, @Nullable Object actual) throws IOException {
        AssertUtils.assertEquals(expectedResourceUri, actual, Charsets.UTF_8);
    }

    public static void assertEquals(@Nonnull URL expectedResourceUri, @Nullable Object actual, @Nonnull Charset charset) throws IOException {
        Assert.assertEquals((Object)AssertUtils.toString(expectedResourceUri, charset), (Object)actual);
    }

    @Nonnull
    static String toString(@Nonnull URL expectedResourceUri, @Nonnull Charset charset) throws IOException {
        return new String(ByteStreams.toByteArray((InputStream)expectedResourceUri.openStream()), charset);
    }

    public static void assertFileByHashes(@Nonnull File fileUnderTest, @Nonnull Algorithm algorithm, String ... expectedHashesAsHex) throws IOException {
        Hash[] expectedHashes = new Hash[expectedHashesAsHex.length];
        for (String expectedHashAsHex : expectedHashesAsHex) {
            expectedHashes[i] = Hash.fromHex((Algorithm)algorithm, (String)expectedHashAsHex);
        }
        AssertUtils.assertFileByHashes(fileUnderTest, expectedHashes);
    }

    public static void assertFileByHashes(@Nonnull File fileUnderTest, Hash ... expectedHashes) throws IOException {
        if (expectedHashes.length == 0) {
            throw new IllegalArgumentException("Need at least on hash");
        }
        AssertUtils.assertFileByHash(AssertUtils.guessPathFromStackTrace(), Arrays.asList(expectedHashes), fileUnderTest);
    }

    public static void assertFileByHash(@Nonnull Hash expected, @Nonnull File fileUnderTest) throws IOException {
        String path = AssertUtils.guessPathFromStackTrace();
        AssertUtils.assertFileByHash(path, expected, fileUnderTest);
    }

    public static void assertFileByHash(@Nonnull Class<?> testClass, @Nonnull String testMethodName, @Nonnull Hash expected, @Nonnull File fileUnderTest) throws IOException {
        AssertUtils.assertFileByHash(AssertUtils.createPath(testClass, testMethodName), expected, fileUnderTest);
    }

    @Nonnull
    public static String createPath(@Nonnull Class<?> testClass, @Nonnull String testMethodName) {
        return testClass.getName() + File.separator + testMethodName;
    }

    public static void assertFileByHash(@Nonnull String path, @Nonnull Hash expected, @Nonnull File fileUnderTest) throws IOException {
        Hash actual = HashCalculator.calculate((Algorithm)expected.getAlgorithm(), (File)fileUnderTest);
        if (expected.equals((Object)actual)) {
            return;
        }
        File copy = AssertUtils.createCopyFile(path, fileUnderTest.getName());
        if (copy.exists()) {
            FileUtils.moveFile((File)copy, (File)new File(copy.getParentFile(), copy.getName() + "." + System.currentTimeMillis()));
        }
        FileUtils.copyFile((File)fileUnderTest, (File)copy);
        Assert.assertThat((String)AssertUtils.createReason(copy), (Object)expected, (Matcher)CoreMatchers.is((Object)actual));
    }

    @Nonnull
    private static String createReason(@Nonnull File copy) {
        return "Stored questionable file under test at <" + copy.getAbsolutePath() + ">";
    }

    public static void assertFileByHash(@Nonnull String path, @Nonnull Iterable<? extends Hash> expectedHashes, @Nonnull File fileUnderTest) throws IOException {
        ArrayList<Hash> actualHashes = new ArrayList<Hash>();
        for (Hash hash : expectedHashes) {
            Hash actual = HashCalculator.calculate((Algorithm)hash.getAlgorithm(), (File)fileUnderTest);
            actualHashes.add(actual);
            if (!hash.equals((Object)actual)) continue;
            return;
        }
        File copy = AssertUtils.createCopyFile(path, fileUnderTest.getName());
        FileUtils.copyFile((File)fileUnderTest, (File)copy);
        Assert.assertThat((String)AssertUtils.createReason(copy), actualHashes, (Matcher)CoreMatchers.is(expectedHashes));
    }

    @Nonnull
    static File createCopyFile(@Nonnull String path, @Nonnull String name) {
        return new File(new File(FAILED_FILES_DIR, path), name);
    }

    @Nonnull
    public static String guessPathFromStackTrace() {
        StackTraceElement[] elements = Thread.currentThread().getStackTrace();
        if (elements.length < 4) {
            return "unknown";
        }
        StackTraceElement element = elements[3];
        return element.getClassName() + File.separator + element.getMethodName();
    }
}

