/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoft.io;

import com.cedarsoft.io.LinkType;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.io.IOUtils;

public class LinkUtils {
    public static boolean isLink(@Nonnull File file) throws IOException {
        if (!file.exists()) {
            throw new FileNotFoundException(file.getAbsolutePath());
        }
        String canonicalPath = file.getCanonicalPath();
        String absolutePath = file.getAbsolutePath();
        return !absolutePath.equals(canonicalPath);
    }

    public static boolean createLink(@Nonnull File linkTarget, @Nonnull File linkFile, @Nonnull LinkType linkType) throws IOException, AlreadyExistsWithOtherTargetException {
        return LinkUtils.createLink(linkTarget, linkFile, linkType == LinkType.SYMBOLIC);
    }

    public static boolean createSymbolicLink(@Nonnull File linkTarget, @Nonnull File linkFile) throws IOException, AlreadyExistsWithOtherTargetException {
        return LinkUtils.createLink(linkTarget, linkFile, true);
    }

    public static boolean createHardLink(@Nonnull File linkTarget, @Nonnull File linkFile) throws IOException, AlreadyExistsWithOtherTargetException {
        return LinkUtils.createLink(linkTarget, linkFile, false);
    }

    public static boolean createLink(@Nonnull File linkTarget, @Nonnull File linkFile, boolean symbolic) throws IOException, AlreadyExistsWithOtherTargetException {
        if (linkFile.exists()) {
            if (!symbolic) {
                throw new IOException("link still exists " + linkFile.getAbsolutePath());
            }
            if (linkFile.getCanonicalFile().equals(linkTarget.getCanonicalFile())) {
                return false;
            }
            throw new AlreadyExistsWithOtherTargetException(linkTarget, linkFile);
        }
        ArrayList<String> args = new ArrayList<String>();
        args.add("ln");
        if (symbolic) {
            args.add("-s");
        }
        args.add(linkTarget.getPath());
        args.add(linkFile.getAbsolutePath());
        ProcessBuilder builder = new ProcessBuilder(args);
        Process process = builder.start();
        try {
            int result = process.waitFor();
            if (result != 0) {
                throw new IOException("Creation of link failed: " + IOUtils.toString((InputStream)process.getErrorStream(), (Charset)Charset.defaultCharset()));
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        return true;
    }

    @Nonnull
    public static File createTempFile(@Nonnull String prefix, @Nonnull String suffix, @Nullable File parentDir) {
        File result;
        Random rand = new Random();
        String parent = parentDir == null ? System.getProperty("java.io.tmpdir") : parentDir.getPath();
        DecimalFormat fmt = new DecimalFormat("#####");
        while ((result = new File(parent, prefix + fmt.format(Math.abs(rand.nextInt())) + suffix)).exists()) {
        }
        return result;
    }

    public boolean isSymbolicLink(@Nonnull File file) throws IOException {
        return !file.getAbsoluteFile().equals(file.getCanonicalFile());
    }

    public static class AlreadyExistsWithOtherTargetException
    extends Exception {
        public AlreadyExistsWithOtherTargetException(@Nonnull File linkTarget, @Nonnull File linkFile) throws IOException {
            super("A link still exists at <" + linkFile.getAbsolutePath() + "> but with different target: <" + linkTarget.getCanonicalPath() + "> exected <" + linkFile.getCanonicalPath() + ">");
        }
    }
}

