/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoft.crypt;

import com.cedarsoft.crypt.Algorithm;
import com.cedarsoft.crypt.Hash;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.MessageDigest;
import javax.annotation.Nonnull;

public class HashCalculator {
    private HashCalculator() {
    }

    @Nonnull
    public static Hash calculate(@Nonnull Algorithm algorithm, @Nonnull byte[] value) {
        return HashCalculator.calculate(algorithm.getMessageDigest(), value);
    }

    @Nonnull
    public static Hash calculate(@Nonnull MessageDigest messageDigest, @Nonnull byte[] value) {
        messageDigest.reset();
        messageDigest.update(value);
        byte[] digest = messageDigest.digest();
        return new Hash(Algorithm.getAlgorithm(messageDigest.getAlgorithm()), digest);
    }

    @Nonnull
    public static Hash calculate(@Nonnull Algorithm algorithm, @Nonnull String value) {
        return HashCalculator.calculate(algorithm.getMessageDigest(), value);
    }

    @Nonnull
    public static Hash calculate(@Nonnull MessageDigest messageDigest, @Nonnull String value) {
        return HashCalculator.calculate(messageDigest, value.getBytes());
    }

    @Nonnull
    public static Hash calculate(@Nonnull Algorithm algorithm, @Nonnull URL resource) throws IOException {
        return HashCalculator.calculate(algorithm.getMessageDigest(), resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static Hash calculate(@Nonnull MessageDigest messageDigest, @Nonnull URL resource) throws IOException {
        InputStream in = resource.openStream();
        try {
            Hash hash = HashCalculator.calculate(messageDigest, in);
            return hash;
        }
        finally {
            in.close();
        }
    }

    @Nonnull
    public static Hash calculate(@Nonnull Algorithm algorithm, @Nonnull File file) throws IOException {
        return HashCalculator.calculate(algorithm.getMessageDigest(), file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static Hash calculate(@Nonnull MessageDigest messageDigest, @Nonnull File file) throws IOException {
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
        try {
            Hash hash = HashCalculator.calculate(messageDigest, (InputStream)in);
            return hash;
        }
        finally {
            ((InputStream)in).close();
        }
    }

    @Nonnull
    public static Hash calculate(@Nonnull Algorithm algorithm, @Nonnull InputStream resourceIn) throws IOException {
        return HashCalculator.calculate(algorithm.getMessageDigest(), resourceIn);
    }

    @Nonnull
    public static Hash calculate(@Nonnull MessageDigest messageDigest, @Nonnull InputStream resourceIn) throws IOException {
        int k;
        messageDigest.reset();
        byte[] cache = new byte[255];
        while ((k = resourceIn.read(cache)) > -1) {
            messageDigest.update(cache, 0, k);
        }
        byte[] digest = messageDigest.digest();
        return new Hash(Algorithm.getAlgorithm(messageDigest.getAlgorithm()), digest);
    }
}

