/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoft.crypt;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;

public enum Algorithm {
    MD5(128, "MD5"),
    SHA1(128, "SHA-1", "SHA1"),
    SHA256(256, "SHA-256", "SHA256"),
    SHA512(512, "SHA-512", "SHA512");

    private final int expectedLength;
    @Nonnull
    private final List<String> alternativeNames = new ArrayList<String>();

    @Nonnull
    public static Algorithm getAlgorithm(@Nonnull String algorithmString) {
        try {
            return Algorithm.valueOf(algorithmString);
        }
        catch (IllegalArgumentException ignore) {
            for (Algorithm algorithm : Algorithm.values()) {
                if (!algorithm.alternativeNames.contains(algorithmString)) continue;
                return algorithm;
            }
            throw new IllegalArgumentException("No Alogirthm found for " + algorithmString);
        }
    }

    private Algorithm(int expectedLength, String ... alternativeNames) {
        this.expectedLength = expectedLength;
        if (alternativeNames.length == 0) {
            throw new IllegalArgumentException("Need at least one algorithm name");
        }
        this.alternativeNames.addAll(Arrays.asList(alternativeNames));
    }

    @Nonnull
    public List<? extends String> getAlternativeNames() {
        return Collections.unmodifiableList(this.alternativeNames);
    }

    @Nonnull
    public MessageDigest getMessageDigest() {
        try {
            return MessageDigest.getInstance(this.alternativeNames.get(0));
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public int getExpectedLength() {
        return this.expectedLength;
    }
}

