/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.junitbenchmarks;

import com.carrotsearch.junitbenchmarks.BenchmarkOptions;
import com.carrotsearch.junitbenchmarks.Clock;
import com.carrotsearch.junitbenchmarks.GCSnapshot;
import com.carrotsearch.junitbenchmarks.IResultsConsumer;
import com.carrotsearch.junitbenchmarks.Result;
import com.carrotsearch.junitbenchmarks.SingleResult;
import com.carrotsearch.junitbenchmarks.Statistics;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.Statement;

final class BenchmarkStatement
extends Statement {
    static final int DEFAULT_WARMUP_ROUNDS = 5;
    static final int DEFAULT_BENCHMARK_ROUNDS = 10;
    private boolean ignoreAnnotationOptions = Boolean.getBoolean("jub.ignore.annotations");
    private boolean ignoreCallGC = Boolean.getBoolean("jub.ignore.callgc");
    private final Object target;
    private final FrameworkMethod method;
    private final BenchmarkOptions options;
    private final IResultsConsumer[] consumers;
    private final Statement base;

    public BenchmarkStatement(Statement base, FrameworkMethod method, Object target, IResultsConsumer ... consumers) {
        this.base = base;
        this.method = method;
        this.target = target;
        this.consumers = consumers;
        this.options = this.resolveOptions(method);
    }

    @BenchmarkOptions
    private void defaultOptions() {
    }

    private BenchmarkOptions resolveOptions(FrameworkMethod method) {
        BenchmarkOptions options = (BenchmarkOptions)method.getAnnotation(BenchmarkOptions.class);
        if (options != null) {
            return options;
        }
        for (Class<?> clz = this.target.getClass(); clz != null; clz = clz.getSuperclass()) {
            options = clz.getAnnotation(BenchmarkOptions.class);
            if (options == null) continue;
            return options;
        }
        try {
            return ((Object)((Object)this)).getClass().getDeclaredMethod("defaultOptions", new Class[0]).getAnnotation(BenchmarkOptions.class);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void evaluate() throws Throwable {
        BaseEvaluator evaluator;
        int warmupRounds = this.getIntOption(this.options.warmupRounds(), "jub.rounds.warmup", 5);
        int benchmarkRounds = this.getIntOption(this.options.benchmarkRounds(), "jub.rounds.benchmark", 10);
        int concurrency = this.getIntOption(this.options.concurrency(), "jub.concurrency", -1);
        int totalRounds = warmupRounds + benchmarkRounds;
        if (concurrency == -1) {
            evaluator = new SequentialEvaluator(warmupRounds, benchmarkRounds, totalRounds, this.options.clock());
        } else {
            if (this.options.callgc()) {
                throw new IllegalArgumentException("Concurrent benchmark execution must be combined ignoregc=\"true\".");
            }
            int threads = concurrency == 0 ? Runtime.getRuntime().availableProcessors() : concurrency;
            evaluator = new ConcurrentEvaluator(warmupRounds, benchmarkRounds, totalRounds, threads, this.options.clock());
        }
        Result result = ((BaseEvaluator)evaluator).evaluate();
        for (IResultsConsumer consumer : this.consumers) {
            consumer.accept(result);
        }
    }

    private void cleanupMemory() {
        if (this.ignoreCallGC) {
            return;
        }
        if (!this.options.callgc()) {
            return;
        }
        System.gc();
        System.gc();
        Thread.yield();
    }

    private int getIntOption(int localValue, String property, int defaultValue) {
        String v = System.getProperty(property);
        if (v != null && v.trim().length() > 0) {
            defaultValue = Integer.parseInt(v);
        }
        if (this.ignoreAnnotationOptions || localValue < 0) {
            return defaultValue;
        }
        return localValue;
    }

    private final class ConcurrentEvaluator
    extends BaseEvaluator {
        private final int concurrency;
        private final CountDownLatch latch;

        ConcurrentEvaluator(int warmupRounds, int benchmarkRounds, int totalRounds, int concurrency) {
            this(warmupRounds, benchmarkRounds, totalRounds, concurrency, Clock.REAL_TIME);
        }

        ConcurrentEvaluator(int warmupRounds, int benchmarkRounds, int totalRounds, int concurrency, Clock clock) {
            super(warmupRounds, benchmarkRounds, totalRounds, clock);
            this.concurrency = concurrency;
            this.latch = new CountDownLatch(1);
        }

        private final ExecutorService getExecutor(int concurrency, int totalRounds) {
            return new ThreadPoolExecutor(concurrency, concurrency, 10000L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(totalRounds));
        }

        private final void cleanupExecutor(ExecutorService executor) {
            List<Runnable> pending = executor.shutdownNow();
        }

        @Override
        public Result evaluate() throws Throwable {
            int i;
            ExecutorService executor = this.getExecutor(this.concurrency, this.totalRounds);
            ExecutorCompletionService<SingleResult> completed = new ExecutorCompletionService<SingleResult>(executor);
            for (i = 0; i < this.totalRounds; ++i) {
                completed.submit(new EvaluatorCallable(i));
            }
            this.latch.countDown();
            this.warmupTime = this.clock.time();
            this.benchmarkTime = 0L;
            try {
                for (i = 0; i < this.totalRounds; ++i) {
                    this.results.add(completed.take().get());
                }
                this.benchmarkTime = this.clock.time() - this.benchmarkTime;
                Result i2 = this.computeResult();
                return i2;
            }
            catch (ExecutionException e) {
                e.printStackTrace();
                throw e.getCause().getCause();
            }
            finally {
                this.cleanupExecutor(executor);
            }
        }

        @Override
        protected Result computeResult() {
            Result r = super.computeResult();
            r.concurrency = this.concurrency;
            return r;
        }

        private final class EvaluatorCallable
        implements Callable<SingleResult> {
            private final int i;

            public EvaluatorCallable(int i) {
                this.i = i;
            }

            @Override
            public SingleResult call() throws Exception {
                ConcurrentEvaluator.this.latch.await();
                return ConcurrentEvaluator.this.evaluateInternally(this.i);
            }
        }
    }

    private final class SequentialEvaluator
    extends BaseEvaluator {
        SequentialEvaluator(int warmupRounds, int benchmarkRounds, int totalRounds) {
            this(warmupRounds, benchmarkRounds, totalRounds, Clock.REAL_TIME);
        }

        SequentialEvaluator(int warmupRounds, int benchmarkRounds, int totalRounds, Clock clock) {
            super(warmupRounds, benchmarkRounds, totalRounds, clock);
        }

        @Override
        public Result evaluate() throws Throwable {
            this.warmupTime = this.clock.time();
            this.benchmarkTime = 0L;
            for (int i = 0; i < this.totalRounds; ++i) {
                this.results.add(this.evaluateInternally(i));
            }
            this.benchmarkTime = this.clock.time() - this.benchmarkTime;
            return this.computeResult();
        }
    }

    private abstract class BaseEvaluator {
        protected final ArrayList<SingleResult> results;
        protected final int warmupRounds;
        protected final int benchmarkRounds;
        protected final int totalRounds;
        protected final Clock clock;
        protected long warmupTime;
        protected long benchmarkTime;
        protected GCSnapshot gcSnapshot = null;

        protected BaseEvaluator(int warmupRounds, int benchmarkRounds, int totalRounds, Clock clock) {
            this.warmupRounds = warmupRounds;
            this.benchmarkRounds = benchmarkRounds;
            this.totalRounds = totalRounds;
            this.clock = clock;
            this.results = new ArrayList(totalRounds);
        }

        protected abstract Result evaluate() throws Throwable;

        protected final SingleResult evaluateInternally(int round) throws InvocationTargetException {
            long startTime = this.clock.time();
            BenchmarkStatement.this.cleanupMemory();
            long afterGC = this.clock.time();
            if (round == this.warmupRounds) {
                this.gcSnapshot = new GCSnapshot();
                this.benchmarkTime = this.clock.time();
                this.warmupTime = this.benchmarkTime - this.warmupTime;
            }
            try {
                BenchmarkStatement.this.base.evaluate();
                long endTime = this.clock.time();
                return new SingleResult(startTime, afterGC, endTime);
            }
            catch (Throwable t) {
                throw new InvocationTargetException(t);
            }
        }

        protected Result computeResult() {
            Statistics stats = Statistics.from(this.results.subList(this.warmupRounds, this.totalRounds));
            return new Result(BenchmarkStatement.this.target, BenchmarkStatement.this.method, this.benchmarkRounds, this.warmupRounds, this.warmupTime, this.benchmarkTime, stats.evaluation, stats.gc, this.gcSnapshot, 1);
        }
    }
}

