/*
 * Decompiled with CFR 0.152.
 */
package com.c4_soft.springaddons.security.oidc.starter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.springframework.security.oauth2.core.endpoint.OAuth2AuthorizationRequest;

public class CompositeOAuth2AuthorizationRequestCustomizer
implements Consumer<OAuth2AuthorizationRequest.Builder> {
    private final List<Consumer<OAuth2AuthorizationRequest.Builder>> delegates;

    public CompositeOAuth2AuthorizationRequestCustomizer(Consumer<OAuth2AuthorizationRequest.Builder> ... customizers) {
        this.delegates = new ArrayList<Consumer<OAuth2AuthorizationRequest.Builder>>(customizers.length + 3);
        Collections.addAll(this.delegates, customizers);
    }

    public CompositeOAuth2AuthorizationRequestCustomizer(CompositeOAuth2AuthorizationRequestCustomizer other, Consumer<OAuth2AuthorizationRequest.Builder> ... customizers) {
        this((Consumer[])Stream.concat(other.delegates.stream(), Stream.of(customizers)).toArray(Consumer[]::new));
    }

    @Override
    public void accept(OAuth2AuthorizationRequest.Builder t) {
        for (Consumer<OAuth2AuthorizationRequest.Builder> consumer : this.delegates) {
            consumer.accept(t);
        }
    }

    public CompositeOAuth2AuthorizationRequestCustomizer addCustomizer(Consumer<OAuth2AuthorizationRequest.Builder> customizer) {
        this.delegates.add(customizer);
        return this;
    }
}

