/*
 * Decompiled with CFR 0.152.
 */
package com.c4_soft.springaddons.security.oauth2.test.annotations.parameterized;

import com.c4_soft.springaddons.security.oauth2.test.annotations.WithOAuth2Login;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Collection;
import java.util.stream.Stream;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.ArgumentsProvider;
import org.junit.jupiter.params.provider.ArgumentsSource;
import org.junit.jupiter.params.support.AnnotationConsumer;
import org.springframework.security.oauth2.client.authentication.OAuth2AuthenticationToken;

@Target(value={ElementType.ANNOTATION_TYPE, ElementType.METHOD})
@Retention(value=RetentionPolicy.RUNTIME)
@ArgumentsSource(value=AuthenticationProvider.class)
public @interface OAuth2LoginAuthenticationSource {
    public WithOAuth2Login[] value() default {};

    public static class AuthenticationProvider
    implements ArgumentsProvider,
    AnnotationConsumer<OAuth2LoginAuthenticationSource> {
        private final WithOAuth2Login.OAuth2AuthenticationTokenFactory authFactory = new WithOAuth2Login.OAuth2AuthenticationTokenFactory();
        private Collection<OAuth2AuthenticationToken> arguments;

        public void accept(OAuth2LoginAuthenticationSource source) {
            this.arguments = Stream.of(source.value()).map(this.authFactory::authentication).toList();
        }

        public Stream<? extends Arguments> provideArguments(ExtensionContext context) {
            return this.arguments.stream().map(xva$0 -> Arguments.of((Object[])new Object[]{xva$0}));
        }
    }
}

