/*
 * Decompiled with CFR 0.152.
 */
package com.c4_soft.springaddons.security.oauth2.test;

import com.c4_soft.springaddons.security.oauth2.test.Defaults;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.mockito.Mockito;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.SimpleGrantedAuthority;

public class MockAuthenticationBuilder<A extends Authentication, T extends MockAuthenticationBuilder<A, T>> {
    private final A authMock;

    public MockAuthenticationBuilder(Class<A> authType, Object principal) {
        this(authType, principal, principal, principal);
    }

    public MockAuthenticationBuilder(Class<A> authType, Object principal, Object details, Object credentials) {
        this.authMock = (Authentication)Mockito.mock(authType);
        this.name("user");
        this.authorities(Defaults.AUTHORITIES.stream());
        this.setAuthenticated(true);
        this.principal(principal);
        this.details(details);
        this.credentials(credentials);
    }

    public A build() {
        return this.authMock;
    }

    public T authorities(String ... authorities) {
        return this.authorities(Stream.of(authorities));
    }

    public T authorities(Stream<String> authorities) {
        Mockito.when((Object)this.authMock.getAuthorities()).thenReturn((Object)authorities.map(SimpleGrantedAuthority::new).collect(Collectors.toSet()));
        return this.downcast();
    }

    public T name(String name) {
        Mockito.when((Object)this.authMock.getName()).thenReturn((Object)name);
        return this.downcast();
    }

    public T credentials(Object credentials) {
        Mockito.when((Object)this.authMock.getCredentials()).thenReturn(credentials);
        return this.downcast();
    }

    public T details(Object details) {
        Mockito.when((Object)this.authMock.getDetails()).thenReturn(details);
        return this.downcast();
    }

    public T principal(Object principal) {
        Mockito.when((Object)this.authMock.getPrincipal()).thenReturn(principal);
        return this.downcast();
    }

    public T setAuthenticated(boolean authenticated) {
        Mockito.when((Object)this.authMock.isAuthenticated()).thenReturn((Object)authenticated);
        return this.downcast();
    }

    public T configure(Consumer<A> authConsumer) {
        authConsumer.accept(this.authMock);
        return this.downcast();
    }

    protected T downcast() {
        return (T)this;
    }
}

