/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j.distributed.serialization;

import io.github.bucket4j.Bandwidth;
import io.github.bucket4j.BucketConfiguration;
import io.github.bucket4j.BucketState64BitsInteger;
import io.github.bucket4j.ConsumptionProbe;
import io.github.bucket4j.EstimationProbe;
import io.github.bucket4j.distributed.remote.BucketNotFoundError;
import io.github.bucket4j.distributed.remote.CommandResult;
import io.github.bucket4j.distributed.remote.ConfigurationNeedToBeReplacedError;
import io.github.bucket4j.distributed.remote.MultiResult;
import io.github.bucket4j.distributed.remote.RemoteBucketState;
import io.github.bucket4j.distributed.remote.RemoteStat;
import io.github.bucket4j.distributed.remote.RemoteVerboseResult;
import io.github.bucket4j.distributed.remote.Request;
import io.github.bucket4j.distributed.remote.UnsupportedNamedTypeError;
import io.github.bucket4j.distributed.remote.UnsupportedTypeError;
import io.github.bucket4j.distributed.remote.UsageOfObsoleteApiError;
import io.github.bucket4j.distributed.remote.UsageOfUnsupportedApiError;
import io.github.bucket4j.distributed.remote.commands.AddTokensCommand;
import io.github.bucket4j.distributed.remote.commands.CheckConfigurationVersionAndExecuteCommand;
import io.github.bucket4j.distributed.remote.commands.ConsumeAsMuchAsPossibleCommand;
import io.github.bucket4j.distributed.remote.commands.ConsumeIgnoringRateLimitsCommand;
import io.github.bucket4j.distributed.remote.commands.CreateInitialStateAndExecuteCommand;
import io.github.bucket4j.distributed.remote.commands.CreateInitialStateWithVersionOrReplaceConfigurationAndExecuteCommand;
import io.github.bucket4j.distributed.remote.commands.CreateSnapshotCommand;
import io.github.bucket4j.distributed.remote.commands.EstimateAbilityToConsumeCommand;
import io.github.bucket4j.distributed.remote.commands.ForceAddTokensCommand;
import io.github.bucket4j.distributed.remote.commands.GetAvailableTokensCommand;
import io.github.bucket4j.distributed.remote.commands.GetConfigurationCommand;
import io.github.bucket4j.distributed.remote.commands.MultiCommand;
import io.github.bucket4j.distributed.remote.commands.ReplaceConfigurationCommand;
import io.github.bucket4j.distributed.remote.commands.ReserveAndCalculateTimeToSleepCommand;
import io.github.bucket4j.distributed.remote.commands.ResetCommand;
import io.github.bucket4j.distributed.remote.commands.SyncCommand;
import io.github.bucket4j.distributed.remote.commands.TryConsumeAndReturnRemainingTokensCommand;
import io.github.bucket4j.distributed.remote.commands.TryConsumeCommand;
import io.github.bucket4j.distributed.remote.commands.VerboseCommand;
import io.github.bucket4j.distributed.serialization.PrimitiveSerializationHandles;
import io.github.bucket4j.distributed.serialization.SerializationHandle;
import io.github.bucket4j.distributed.versioning.UnsupportedNamedTypeException;
import io.github.bucket4j.distributed.versioning.UnsupportedTypeException;
import io.github.bucket4j.local.LockFreeBucket;
import io.github.bucket4j.local.SynchronizedBucket;
import io.github.bucket4j.local.ThreadUnsafeBucket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class SerializationHandles {
    public static final SerializationHandles CORE_HANDLES = new SerializationHandles(Arrays.asList(Bandwidth.SERIALIZATION_HANDLE, BucketConfiguration.SERIALIZATION_HANDLE, BucketState64BitsInteger.SERIALIZATION_HANDLE, RemoteBucketState.SERIALIZATION_HANDLE, RemoteStat.SERIALIZATION_HANDLE, CommandResult.SERIALIZATION_HANDLE, ConsumptionProbe.SERIALIZATION_HANDLE, EstimationProbe.SERIALIZATION_HANDLE, MultiResult.SERIALIZATION_HANDLE, RemoteVerboseResult.SERIALIZATION_HANDLE, BucketNotFoundError.SERIALIZATION_HANDLE, UnsupportedTypeError.SERIALIZATION_HANDLE, UsageOfObsoleteApiError.SERIALIZATION_HANDLE, UsageOfUnsupportedApiError.SERIALIZATION_HANDLE, UnsupportedNamedTypeError.SERIALIZATION_HANDLE, CreateInitialStateAndExecuteCommand.SERIALIZATION_HANDLE, MultiCommand.SERIALIZATION_HANDLE, ReserveAndCalculateTimeToSleepCommand.SERIALIZATION_HANDLE, AddTokensCommand.SERIALIZATION_HANDLE, ConsumeAsMuchAsPossibleCommand.SERIALIZATION_HANDLE, CreateSnapshotCommand.SERIALIZATION_HANDLE, GetAvailableTokensCommand.SERIALIZATION_HANDLE, EstimateAbilityToConsumeCommand.SERIALIZATION_HANDLE, TryConsumeCommand.SERIALIZATION_HANDLE, TryConsumeAndReturnRemainingTokensCommand.SERIALIZATION_HANDLE, ReplaceConfigurationCommand.SERIALIZATION_HANDLE, GetConfigurationCommand.SERIALIZATION_HANDLE, ConsumeIgnoringRateLimitsCommand.SERIALIZATION_HANDLE, VerboseCommand.SERIALIZATION_HANDLE, SyncCommand.SERIALIZATION_HANDLE, Request.SERIALIZATION_HANDLE, ForceAddTokensCommand.SERIALIZATION_HANDLE, ResetCommand.SERIALIZATION_HANDLE, ConfigurationNeedToBeReplacedError.SERIALIZATION_HANDLE, CreateInitialStateWithVersionOrReplaceConfigurationAndExecuteCommand.SERIALIZATION_HANDLE, CheckConfigurationVersionAndExecuteCommand.SERIALIZATION_HANDLE, LockFreeBucket.SERIALIZATION_HANDLE, SynchronizedBucket.SERIALIZATION_HANDLE, ThreadUnsafeBucket.SERIALIZATION_HANDLE));
    private final Collection<SerializationHandle<?>> allHandles;
    private final SerializationHandle[] handlesById;
    private final Map<String, SerializationHandle<?>> handlesByName = new HashMap();

    public SerializationHandles(Collection<SerializationHandle<?>> allHandles) {
        String typeName;
        HashMap serializersById = new HashMap();
        int maxTypeId = 0;
        for (SerializationHandle<?> handle : allHandles) {
            int typeId = handle.getTypeId();
            if (typeId <= 0) {
                throw new IllegalArgumentException("non positive typeId=" + typeId + " detected for " + handle);
            }
            maxTypeId = Math.max(maxTypeId, typeId);
            SerializationHandle<?> conflictingHandle = (SerializationHandle<?>)serializersById.get(typeId);
            if (conflictingHandle != null) {
                String msg = "Serialization ID " + typeId + " duplicated for " + handle + " and " + conflictingHandle;
                throw new IllegalArgumentException(msg);
            }
            serializersById.put(typeId, handle);
            typeName = handle.getTypeName();
            if (typeName == null || typeName.isEmpty()) {
                throw new IllegalArgumentException("null typeName detected for " + handle);
            }
            conflictingHandle = this.handlesByName.get(typeName);
            if (conflictingHandle != null) {
                String msg = "Serialization typeName " + typeName + " duplicated for " + handle + " and " + conflictingHandle;
                throw new IllegalArgumentException(msg);
            }
            this.handlesByName.put(typeName, handle);
        }
        for (SerializationHandle handle : PrimitiveSerializationHandles.primitiveHandlesById) {
            typeName = handle.getTypeName();
            if (typeName == null || typeName.isEmpty()) {
                throw new IllegalArgumentException("null typeName detected for " + handle);
            }
            SerializationHandle<?> conflictingHandle = this.handlesByName.get(typeName);
            if (conflictingHandle != null) {
                String msg = "Serialization typeName " + typeName + " duplicated for " + handle + " and " + conflictingHandle;
                throw new IllegalArgumentException(msg);
            }
            this.handlesByName.put(typeName, handle);
        }
        this.allHandles = Collections.unmodifiableCollection(allHandles);
        this.handlesById = new SerializationHandle[maxTypeId + 1];
        Iterator<SerializationHandle<?>> iterator = allHandles.iterator();
        while (iterator.hasNext()) {
            SerializationHandle handle;
            this.handlesById[handle.getTypeId()] = handle = (SerializationHandle)iterator.next();
        }
    }

    public SerializationHandles merge(SerializationHandle<?> ... handles) {
        ArrayList resultHandles = new ArrayList(this.allHandles);
        for (SerializationHandle<?> handle : handles) {
            resultHandles.add(handle);
        }
        return new SerializationHandles(resultHandles);
    }

    public <T> SerializationHandle<T> getHandleByTypeId(int typeId) {
        if (typeId > 0) {
            if (typeId >= this.handlesById.length) {
                throw new UnsupportedTypeException(typeId);
            }
            SerializationHandle serializationHandle = this.handlesById[typeId];
            if (serializationHandle == null) {
                throw new UnsupportedTypeException(typeId);
            }
            return serializationHandle;
        }
        if ((typeId = -typeId) >= PrimitiveSerializationHandles.primitiveHandlesById.length) {
            throw new UnsupportedTypeException(typeId);
        }
        return PrimitiveSerializationHandles.primitiveHandlesById[typeId];
    }

    public Collection<SerializationHandle<?>> getAllHandles() {
        return this.allHandles;
    }

    public SerializationHandle<?> getHandleByTypeName(String typeName) {
        SerializationHandle<?> handle = this.handlesByName.get(typeName);
        if (handle == null) {
            throw new UnsupportedNamedTypeException(typeName);
        }
        return handle;
    }
}

