/*
 * Decompiled with CFR 0.152.
 */
package com.braintreegateway;

import com.braintreegateway.CreditCard;
import com.braintreegateway.enums.Business;
import com.braintreegateway.enums.Consumer;
import com.braintreegateway.enums.Corporate;
import com.braintreegateway.enums.PrepaidReloadable;
import com.braintreegateway.enums.Purchase;
import com.braintreegateway.util.EnumUtils;
import com.braintreegateway.util.NodeWrapper;
import java.util.Map;

public class BinData {
    private String business;
    private String commercial;
    private String consumer;
    private String corporate;
    private String countryOfIssuance;
    private String debit;
    private String durbinRegulated;
    private String healthcare;
    private String issuingBank;
    private String payroll;
    private String prepaid;
    private String prepaidReloadable;
    private String productId;
    private String purchase;

    public BinData(NodeWrapper node) {
        this.business = node.findString("business");
        this.commercial = node.findString("commercial");
        this.consumer = node.findString("consumer");
        this.corporate = node.findString("corporate");
        this.countryOfIssuance = node.findString("country-of-issuance");
        this.debit = node.findString("debit");
        this.durbinRegulated = node.findString("durbin-regulated");
        this.healthcare = node.findString("healthcare");
        this.issuingBank = node.findString("issuing-bank");
        this.payroll = node.findString("payroll");
        this.prepaid = node.findString("prepaid");
        this.prepaidReloadable = node.findString("prepaid-reloadable");
        this.productId = node.findString("product-id");
        this.purchase = node.findString("purchase");
    }

    public BinData(Map<String, String> map) {
        this.business = map.get("business");
        this.commercial = map.get("commercial");
        this.consumer = map.get("consumer");
        this.corporate = map.get("corporate");
        this.countryOfIssuance = map.get("countryOfIssuance");
        this.debit = map.get("debit");
        this.durbinRegulated = map.get("durbinRegulated");
        this.healthcare = map.get("healthcare");
        this.issuingBank = map.get("issuingBank");
        this.payroll = map.get("payroll");
        this.prepaid = map.get("prepaid");
        this.prepaidReloadable = map.get("prepaid-reloadable");
        this.productId = map.get("productId");
        this.purchase = map.get("purchase");
    }

    public Business getBusiness() {
        return (Business)EnumUtils.findByToString((Enum[])Business.values(), (String)this.business, (Enum)Business.UNKNOWN);
    }

    public CreditCard.Commercial getCommercial() {
        return (CreditCard.Commercial)EnumUtils.findByToString((Enum[])CreditCard.Commercial.values(), (String)this.commercial, (Enum)CreditCard.Commercial.UNKNOWN);
    }

    public Consumer getConsumer() {
        return (Consumer)EnumUtils.findByToString((Enum[])Consumer.values(), (String)this.consumer, (Enum)Consumer.UNKNOWN);
    }

    public Corporate getCorporate() {
        return (Corporate)EnumUtils.findByToString((Enum[])Corporate.values(), (String)this.corporate, (Enum)Corporate.UNKNOWN);
    }

    public CreditCard.Debit getDebit() {
        return (CreditCard.Debit)EnumUtils.findByToString((Enum[])CreditCard.Debit.values(), (String)this.debit, (Enum)CreditCard.Debit.UNKNOWN);
    }

    public CreditCard.DurbinRegulated getDurbinRegulated() {
        return (CreditCard.DurbinRegulated)EnumUtils.findByToString((Enum[])CreditCard.DurbinRegulated.values(), (String)this.durbinRegulated, (Enum)CreditCard.DurbinRegulated.UNKNOWN);
    }

    public CreditCard.Healthcare getHealthcare() {
        return (CreditCard.Healthcare)EnumUtils.findByToString((Enum[])CreditCard.Healthcare.values(), (String)this.healthcare, (Enum)CreditCard.Healthcare.UNKNOWN);
    }

    public CreditCard.Payroll getPayroll() {
        return (CreditCard.Payroll)EnumUtils.findByToString((Enum[])CreditCard.Payroll.values(), (String)this.payroll, (Enum)CreditCard.Payroll.UNKNOWN);
    }

    public CreditCard.Prepaid getPrepaid() {
        return (CreditCard.Prepaid)EnumUtils.findByToString((Enum[])CreditCard.Prepaid.values(), (String)this.prepaid, (Enum)CreditCard.Prepaid.UNKNOWN);
    }

    public PrepaidReloadable getPrepaidReloadable() {
        return (PrepaidReloadable)EnumUtils.findByToString((Enum[])PrepaidReloadable.values(), (String)this.prepaidReloadable, (Enum)PrepaidReloadable.UNKNOWN);
    }

    public Purchase getPurchase() {
        return (Purchase)EnumUtils.findByToString((Enum[])Purchase.values(), (String)this.purchase, (Enum)Purchase.UNKNOWN);
    }

    public String getProductId() {
        if ("".equals(this.productId)) {
            return "Unknown";
        }
        return this.productId;
    }

    public String getCountryOfIssuance() {
        if ("".equals(this.countryOfIssuance)) {
            return "Unknown";
        }
        return this.countryOfIssuance;
    }

    public String getIssuingBank() {
        if ("".equals(this.issuingBank)) {
            return "Unknown";
        }
        return this.issuingBank;
    }
}

