/*
 * Decompiled with CFR 0.152.
 */
package com.braintreegateway;

import com.braintreegateway.Transaction;
import com.braintreegateway.util.EnumUtils;
import com.braintreegateway.util.NodeWrapper;
import java.math.BigDecimal;
import java.util.Calendar;

public class StatusEvent {
    private BigDecimal amount;
    private Transaction.Status status;
    private Calendar timestamp;
    private Transaction.Source source;
    private String user;

    public StatusEvent(NodeWrapper node) {
        this.amount = node.findBigDecimal("amount");
        this.status = EnumUtils.findByName(Transaction.Status.class, node.findString("status"), Transaction.Status.UNRECOGNIZED);
        this.timestamp = node.findDateTime("timestamp");
        this.source = EnumUtils.findByName(Transaction.Source.class, node.findString("transaction-source"), Transaction.Source.UNRECOGNIZED);
        this.user = node.findString("user");
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public Transaction.Status getStatus() {
        return this.status;
    }

    public Calendar getTimestamp() {
        return this.timestamp;
    }

    public Transaction.Source getSource() {
        return this.source;
    }

    public String getUser() {
        return this.user;
    }
}

