/*
 * Decompiled with CFR 0.152.
 */
package com.braintreegateway;

import com.braintreegateway.Configuration;
import com.braintreegateway.CreditCard;
import com.braintreegateway.CreditCardRequest;
import com.braintreegateway.ExpiredCreditCardPager;
import com.braintreegateway.ExpiringCreditCardPager;
import com.braintreegateway.IdsSearchRequest;
import com.braintreegateway.ResourceCollection;
import com.braintreegateway.Result;
import com.braintreegateway.exceptions.NotFoundException;
import com.braintreegateway.util.Http;
import com.braintreegateway.util.NodeWrapper;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.TimeZone;

public class CreditCardGateway {
    private Configuration configuration;
    private Http http;

    public CreditCardGateway(Http http, Configuration configuration) {
        this.configuration = configuration;
        this.http = http;
    }

    public Result<CreditCard> create(CreditCardRequest request) {
        NodeWrapper node = this.http.post(this.configuration.getMerchantPath() + "/payment_methods", request);
        return new Result<CreditCard>(node, CreditCard.class);
    }

    public Result<CreditCard> delete(String token) {
        this.http.delete(this.configuration.getMerchantPath() + "/payment_methods/credit_card/" + token);
        return new Result<CreditCard>();
    }

    public CreditCard find(String token) {
        if (token == null || token.trim().equals("")) {
            throw new NotFoundException();
        }
        return new CreditCard(this.http.get(this.configuration.getMerchantPath() + "/payment_methods/credit_card/" + token));
    }

    public CreditCard fromNonce(String nonce) {
        if (nonce == null || nonce.trim().equals("")) {
            throw new NotFoundException();
        }
        try {
            return new CreditCard(this.http.get(this.configuration.getMerchantPath() + "/payment_methods/from_nonce/" + nonce));
        }
        catch (NotFoundException e) {
            throw new NotFoundException("Payment method with nonce " + nonce + " locked, consumed or not found");
        }
    }

    public Result<CreditCard> update(String token, CreditCardRequest request) {
        NodeWrapper node = this.http.put(this.configuration.getMerchantPath() + "/payment_methods/credit_card/" + token, request);
        return new Result<CreditCard>(node, CreditCard.class);
    }

    public ResourceCollection<CreditCard> expired() {
        NodeWrapper response = this.http.post(this.configuration.getMerchantPath() + "/payment_methods/all/expired_ids");
        return new ResourceCollection<CreditCard>(new ExpiredCreditCardPager(this), response);
    }

    List<CreditCard> fetchExpiredCreditCards(List<String> ids) {
        IdsSearchRequest query = new IdsSearchRequest().ids().in(ids);
        NodeWrapper response = this.http.post(this.configuration.getMerchantPath() + "/payment_methods/all/expired", query);
        ArrayList<CreditCard> items = new ArrayList<CreditCard>();
        for (NodeWrapper node : response.findAll("credit-card")) {
            items.add(new CreditCard(node));
        }
        return items;
    }

    public ResourceCollection<CreditCard> expiringBetween(Calendar start, Calendar end) {
        String queryString = this.dateQueryString(start, end);
        NodeWrapper response = this.http.post(this.configuration.getMerchantPath() + "/payment_methods/all/expiring_ids?" + queryString);
        return new ResourceCollection<CreditCard>(new ExpiringCreditCardPager(this, queryString), response);
    }

    List<CreditCard> fetchExpiringCreditCards(List<String> ids, String queryString) {
        IdsSearchRequest query = new IdsSearchRequest().ids().in(ids);
        NodeWrapper response = this.http.post(this.configuration.getMerchantPath() + "/payment_methods/all/expiring?" + queryString, query);
        ArrayList<CreditCard> items = new ArrayList<CreditCard>();
        for (NodeWrapper node : response.findAll("credit-card")) {
            items.add(new CreditCard(node));
        }
        return items;
    }

    private String dateQueryString(Calendar start, Calendar end) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("MMyyyy");
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        String formattedStart = dateFormat.format(start.getTime());
        String formattedEnd = dateFormat.format(end.getTime());
        return String.format("start=%s&end=%s", formattedStart, formattedEnd);
    }
}

